/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.relpessoacontato;

import com.touchcomp.basementor.constants.enums.touch.EnumConstTipoHoraRelTouch;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.RelPessoaContatoResp;
import com.touchcomp.basementor.model.vo.RelPessoaContatoTempo;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperRelPessoaContato
implements AbstractHelper<RelPessoaContato> {
    private RelPessoaContato relPessoaContato;

    public RelPessoaContato get() {
        return this.relPessoaContato;
    }

    public void calcularValores() {
        this.relPessoaContato.setTempoOutros(Double.valueOf(this.getTempoLogs(EnumConstTipoHoraRelTouch.TIPO_HORA_OUTROS, this.relPessoaContato.getAgendamentos())));
        this.relPessoaContato.setTempoParado(Double.valueOf(this.getTempoLogs(EnumConstTipoHoraRelTouch.TIPO_HORA_PARADA, this.relPessoaContato.getAgendamentos())));
        this.relPessoaContato.setTempoProdutivo(Double.valueOf(this.getTempoLogs(EnumConstTipoHoraRelTouch.TIPO_HORA_PRODUTIVA, this.relPessoaContato.getAgendamentos())));
        this.relPessoaContato.setTempoTotal(Double.valueOf(this.relPessoaContato.getTempoOutros() + this.relPessoaContato.getTempoParado() + this.relPessoaContato.getTempoProdutivo()));
        this.relPessoaContato.setTempoTotalCobranca(Double.valueOf(this.relPessoaContato.getTempoTotal() - this.relPessoaContato.getTempoOutros()));
        this.relPessoaContato.setTempoPrevisto(Double.valueOf(this.getTempoPrevisto(this.relPessoaContato.getTempos())));
        this.relPessoaContato.setTempoDifTotalPrevisto(Double.valueOf(this.relPessoaContato.getTempoTotal() - this.relPessoaContato.getTempoPrevisto()));
        this.calcularTemposPrevRealSetores();
    }

    public double getTempoLogs(EnumConstTipoHoraRelTouch tipo, List<RelPessoaContatoLog> agendamentos) {
        double tempo = 0.0;
        for (RelPessoaContatoLog agd : agendamentos) {
            if (!ToolMethods.isEquals((Object)agd.getTipoHoraTouch().getTipoHora(), (Object)tipo.getValue())) continue;
            tempo += agd.getTempoDispendiado().doubleValue();
        }
        return tempo;
    }

    public double getTempoPrevisto(List<RelPessoaContatoTempo> agendamentos) {
        double tempo = 0.0;
        for (RelPessoaContatoTempo agd : agendamentos) {
            tempo += agd.getTempoPrevisto().doubleValue();
        }
        return tempo;
    }

    public double getTempoLogs(List<RelPessoaContatoLog> agendamentos) {
        double tempo = 0.0;
        for (RelPessoaContatoLog agd : agendamentos) {
            tempo += agd.getTempoDispendiado().doubleValue();
        }
        return tempo;
    }

    public double getTempoLogsFromSetor(EnumConstTipoHoraRelTouch tipo, List<RelPessoaContatoLog> agendamentos, SetorUsuario setorUsuario) {
        double tempo = 0.0;
        for (RelPessoaContatoLog agd : agendamentos) {
            if (!ToolMethods.isEquals((Object)agd.getUsuarioAgendamento().getSetorUsuario(), (Object)setorUsuario) || !ToolMethods.isEquals((Object)agd.getTipoHoraTouch().getTipoHora(), (Object)tipo.getValue())) continue;
            tempo += agd.getTempoDispendiado().doubleValue();
        }
        return tempo;
    }

    public void processarResponsaveis() {
        List added = this.relPessoaContato.getResponsaveisRelacionamento();
        for (RelPessoaContatoLog ag : this.relPessoaContato.getAgendamentos()) {
            Optional<RelPessoaContatoResp> found = added.stream().filter(i -> ToolMethods.isEquals((Object)i.getSetorUsuario(), (Object)ag.getUsuarioAgendamento().getSetorUsuario())).findFirst();
            if (found.isPresent() && ag.getDataFinal() != null && (found.get().getDataMovimentacao() == null || ag.getDataFinal().after(found.get().getDataMovimentacao())) && ToolMethods.isAffirmative((Number)ag.getFinalizado()) && !ToolMethods.isAffirmative((Number)found.get().getForcarUsuario()) && ToolMethods.isEquals((Object)ag.getTipoHoraTouch().getTipoHora(), (Object)EnumConstTipoHoraRelTouch.TIPO_HORA_PRODUTIVA.getValue())) {
                found.get().setDataMovimentacao(ag.getDataFinal());
                found.get().setUsuario(ag.getUsuarioAgendamento());
                continue;
            }
            if (found.isPresent() || !ToolMethods.isAffirmative((Number)ag.getFinalizado()) || !ToolMethods.isEquals((Object)ag.getTipoHoraTouch().getTipoHora(), (Object)EnumConstTipoHoraRelTouch.TIPO_HORA_PRODUTIVA.getValue())) continue;
            RelPessoaContatoResp r = new RelPessoaContatoResp();
            r.setDataMovimentacao(ag.getDataFinal());
            r.setRelPessoaContato(this.relPessoaContato);
            r.setSetorUsuario(ag.getUsuarioAgendamento().getSetorUsuario());
            r.setUsuario(ag.getUsuarioAgendamento());
            added.add(r);
        }
    }

    public HelperRelPessoaContato build(RelPessoaContato relPessoaContato) {
        this.relPessoaContato = relPessoaContato;
        return this;
    }

    private void calcularTemposPrevRealSetores() {
        for (RelPessoaContatoTempo temp : this.relPessoaContato.getTempos()) {
            double soma = this.relPessoaContato.getAgendamentos().stream().mapToDouble(i -> TMethods.isEquals((Object)i.getUsuario().getSetorUsuario(), (Object)temp.getSetorUsuario()) && i.getTipoHoraTouch() != null && TMethods.isAnyEquals((Object[])new Object[]{i.getTipoHoraTouch().getTipoHora(), EnumConstTipoHoraRelTouch.TIPO_HORA_PRODUTIVA.getValue(), EnumConstTipoHoraRelTouch.TIPO_HORA_PARADA.getValue()}) ? i.getTempoDispendiado() : 0.0).sum();
            temp.setTempoTotalEventoAgendamento(Double.valueOf(soma));
        }
    }
}

