/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.requisicao;

import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoAcuracidade;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoAtendimentoPedAlmox;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoConsumoAtivo;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoControleEntregaEquipamento;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoNotaFiscalTerceiros;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoWmsSaidaEstoque;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.itemrequisicao.SCompItemRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperRequisicao
implements AbstractHelper<Requisicao> {
    private Requisicao requisicao;
    private SCompItemRequisicaoImpl sCompItemRequisicaoImpl;
    private CompRequisicaoAcuracidade compRequisicaoAcuracidade;
    private CompRequisicaoControleEntregaEquipamento compRequisicaoControleEntregaEquipamento;
    private CompRequisicaoNotaFiscalTerceiros requisicaoNotaFiscalTerceiros;
    private CompRequisicaoAtendimentoPedAlmox compRequisicaoAtendimentoPedAlmox;
    private CompRequisicaoConsumoAtivo compRequisicaoConsumoAtivo;
    private CompRequisicaoWmsSaidaEstoque compRequisicaoWmsSaidaEstoque;

    public HelperRequisicao() {
    }

    @Autowired
    public HelperRequisicao(SCompItemRequisicaoImpl sCompItemRequisicaoImpl, CompRequisicaoAcuracidade compRequisicaoAcuracidade, CompRequisicaoControleEntregaEquipamento compRequisicaoControleEntregaEquipamento, CompRequisicaoNotaFiscalTerceiros requisicaoNotaFiscalTerceiros, CompRequisicaoAtendimentoPedAlmox compRequisicaoAtendimentoPedAlmox, CompRequisicaoConsumoAtivo compRequisicaoConsumoAtivo, CompRequisicaoWmsSaidaEstoque compRequisicaoWmsSaidaEstoque) {
        this.sCompItemRequisicaoImpl = sCompItemRequisicaoImpl;
        this.compRequisicaoAcuracidade = compRequisicaoAcuracidade;
        this.compRequisicaoControleEntregaEquipamento = compRequisicaoControleEntregaEquipamento;
        this.requisicaoNotaFiscalTerceiros = requisicaoNotaFiscalTerceiros;
        this.compRequisicaoAtendimentoPedAlmox = compRequisicaoAtendimentoPedAlmox;
        this.compRequisicaoConsumoAtivo = compRequisicaoConsumoAtivo;
        this.compRequisicaoWmsSaidaEstoque = compRequisicaoWmsSaidaEstoque;
    }

    public HelperRequisicao build(Requisicao requisicao) {
        this.requisicao = requisicao;
        return this;
    }

    public Requisicao get() {
        return this.requisicao;
    }

    public Double getQtdGradePorRequisicao(Requisicao r, GradeCor gradeCor) {
        double d = 0.0;
        if (ToolMethods.isNull((Object)r).booleanValue() || ToolMethods.isNull((Object)r.getItensRequisicao()).booleanValue()) {
            return d;
        }
        for (ItemRequisicao item : r.getItensRequisicao()) {
            for (GradeItemRequisicao gc : item.getGradeItemRequisicao()) {
                if (!gc.getGradeCor().equals((Object)gradeCor)) continue;
                d += gc.getQuantidade().doubleValue();
            }
        }
        return d;
    }

    public Double getQtdRequisicao(List<ItemRequisicao> itensRequisicao) {
        Double sum = itensRequisicao.stream().mapToDouble(m -> m.getGradeItemRequisicao().stream().mapToDouble(m2 -> m2.getQuantidade()).sum()).sum();
        return sum;
    }

    public Requisicao gerarRequisicao(ApuracidadeEstoque ap) {
        Requisicao r = this.compRequisicaoAcuracidade.gerarRequisicao(ap);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao gerarRequisicaoEntregaEquipamento(ControleEntregaEquipamento eq) {
        Requisicao r = this.compRequisicaoControleEntregaEquipamento.criarRequisicaoEquipamentos(eq);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao gerarRequisicaoNotaFiscalTerceiros(NotaFiscalTerceiros n) {
        Requisicao r = this.requisicaoNotaFiscalTerceiros.criarRequisicaoNotaTerceiros(n);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao gerarRequisicaoAtendPedidoAlmox(AtendPedidoAlmox aten) {
        Requisicao r = this.compRequisicaoAtendimentoPedAlmox.buildRequisicao(aten);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao gerarRequisicaoConsumoAtivo(ConsumoAtivo cons) throws ExceptionParamCtbRequisicao {
        Requisicao r = this.compRequisicaoConsumoAtivo.gerarRequisicao(cons);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao gerarRequisicaoWmsSaidaEstoque(WmsSeparacaoPedido wmsSeparacaoPedido) throws ExceptionParamCtbRequisicao {
        Requisicao r = this.compRequisicaoWmsSaidaEstoque.gerarRequisicao(wmsSeparacaoPedido);
        r = this.beforeSave(r);
        return r;
    }

    public Requisicao beforeSave(Requisicao aux) {
        if (ToolMethods.isNull((Object)aux).booleanValue()) {
            return null;
        }
        aux.getItensRequisicao().forEach(i -> {
            i.setRequisicao(aux);
            i.setQuantidadeTotal(this.sCompItemRequisicaoImpl.calcularQuantidadeItemRequisicao((ItemRequisicao)i));
            i.getGradeItemRequisicao().forEach(gi -> {
                gi.setDataMovimentacao(aux.getDataRequisicao());
                gi.setItemRequisicao(i);
                gi.setEmpresa(aux.getEmpresa());
                gi.setCentroEstoque(i.getCentroEstoque());
            });
        });
        return aux;
    }

    public Requisicao limparItensVazio(Requisicao e) {
        e.getItensRequisicao().forEach(i -> i.getGradeItemRequisicao().removeIf(g -> ToolMethods.isNull((Object)g.getQuantidade()) != false || g.getQuantidade() <= 0.0));
        e.getItensRequisicao().removeIf(i -> ToolMethods.isNull((Object)i.getGradeItemRequisicao()) != false || i.getGradeItemRequisicao().isEmpty());
        return e;
    }
}

