/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.roteiroproducao;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoFuncoesProdutivas;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementor.model.vo.TipoRecursoPCP;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.roteiroproducao.web.DTORoteiroProducao;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperRoteiroProducao
implements AbstractHelper<RoteiroProducao> {
    private RoteiroProducao roteiroProducao;

    public RoteiroProducao get() {
        return this.roteiroProducao;
    }

    public HelperRoteiroProducao build(RoteiroProducao object) {
        this.roteiroProducao = object;
        return this;
    }

    public List<DTORoteiroProducao.DTORoteiroProducaoGrCor> buildGradesRoteiro(List<GradeCor> grades) {
        ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor> ret = new ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor>();
        for (GradeCor g : grades) {
            ret.add(this.buildGradeRoteiro(g));
        }
        return ret;
    }

    public DTORoteiroProducao.DTORoteiroProducaoGrCor buildGradeRoteiro(GradeCor g) {
        DTORoteiroProducao.DTORoteiroProducaoGrCor dto = new DTORoteiroProducao.DTORoteiroProducaoGrCor();
        dto.setGradeCor(g.toString());
        dto.setGradeCorIdentificador(g.getIdentificador());
        dto.setProduto(g.getProdutoGrade().getProduto().getNome());
        dto.setProdutoIdentificador(g.getProdutoGrade().getProduto().getIdentificador());
        dto.setCodigoAuxiliar(g.getProdutoGrade().getProduto().getCodigoAuxiliar());
        return dto;
    }

    public DTORoteiroProducao.DTOFichaTecRoteiroProducao buildFichaTecRotProducao(ModeloFichaTecnica modeloFichaTecnica) {
        DTORoteiroProducao.DTOFichaTecRoteiroProducao dtoMod = new DTORoteiroProducao.DTOFichaTecRoteiroProducao();
        if (modeloFichaTecnica != null) {
            dtoMod.setModeloFichaTecnica(modeloFichaTecnica.toString());
            dtoMod.setModeloFichaTecnicaIdentificador(modeloFichaTecnica.getIdentificador());
            ArrayList<DTORoteiroProducao.DTOValorFichaTecRotProducao> itens = new ArrayList<DTORoteiroProducao.DTOValorFichaTecRotProducao>();
            if (modeloFichaTecnica.getItensModeloFichaTecnica() != null) {
                for (ItemModeloFichaTecnica i : modeloFichaTecnica.getItensModeloFichaTecnica()) {
                    DTORoteiroProducao.DTOValorFichaTecRotProducao dto = new DTORoteiroProducao.DTOValorFichaTecRotProducao();
                    dto.setChave(i.getDescricao());
                    dto.setValorObrigatorio(i.getCampoObrigatorio());
                    if (i.getValorSugerido() != null) {
                        dto.setValor(i.getValorSugerido());
                    }
                    dto.setItemModeloFichaTecnica(i.toString());
                    dto.setItemModeloFichaTecnicaIdentificador(i.getIdentificador());
                    itens.add(dto);
                }
            }
            dtoMod.setValoresFichaTec(itens);
        }
        return dtoMod;
    }

    public DTORoteiroProducao.DTORoteiroProducaoTpProdSped buildRoteiroProducaoTp(TipoProducaoSped vo) {
        if (vo == null) {
            return null;
        }
        DTORoteiroProducao.DTORoteiroProducaoTpProdSped dto = new DTORoteiroProducao.DTORoteiroProducaoTpProdSped();
        dto.setTipoProducaoSped(vo.toString());
        dto.setTipoProducaoSpedIdentificador(vo.getIdentificador());
        return dto;
    }

    public DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes buildGrupoFuncoesProdutivasFormulacoes(GrupoFuncoesProdutivas vo) {
        DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes ret = new DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes();
        if (vo != null) {
            ret.setGrupoFuncoes(vo.toString());
            ret.setGrupoFuncoesIdentificador(vo.getIdentificador());
            ret.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        }
        ret.setQuantidade(Integer.valueOf(0));
        return ret;
    }

    public String verificarProdutosEmOutrosRoteiros(DTORoteiroProducao roteiro, DTORoteiroProducao.DTORoteiroProducaoGrCor gc, List<RoteiroProducao> roteiros) {
        Object msgAux = "";
        if (roteiros != null && !roteiros.isEmpty()) {
            for (RoteiroProducao rt : roteiros) {
                if (ToolMethods.isEquals((Object)rt.getIdentificador(), (Object)roteiro.getIdentificador())) continue;
                if (((String)msgAux).isEmpty()) {
                    msgAux = (String)msgAux + MessagesBaseMentor.getErrorMsg((String)"E.ERP.0129.010", (Object[])new Object[]{gc.getProduto()}) + "\n";
                }
                msgAux = (String)msgAux + "* " + rt.getIdentificador() + " - " + rt.getDescricao() + ";\n";
            }
            if (!((String)msgAux).isEmpty()) {
                msgAux = (String)msgAux + "---------------------------------------------\n";
            }
        }
        return msgAux;
    }

    public String verificarProdutosRepetidos(List<DTORoteiroProducao.DTORoteiroProducaoGrCor> grades) {
        ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor> controle = new ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor>();
        ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor> repetidas = new ArrayList<DTORoteiroProducao.DTORoteiroProducaoGrCor>();
        for (DTORoteiroProducao.DTORoteiroProducaoGrCor gc : grades) {
            if (!controle.contains(gc.getGradeCor())) {
                controle.add(gc);
                continue;
            }
            repetidas.add(gc);
        }
        if (!repetidas.isEmpty()) {
            Object msgProdutosRepetidos = "\nProdutos Repetidos neste Roteiro:\n";
            for (DTORoteiroProducao.DTORoteiroProducaoGrCor r : repetidas) {
                msgProdutosRepetidos = (String)msgProdutosRepetidos + "* " + r.getProduto() + ";\n";
            }
            return msgProdutosRepetidos;
        }
        return null;
    }

    public DTORoteiroProducao.DTOFaseProdutiva buildFaseProdutivaRoteiro(CelulaProdutiva celulaProdutiva) {
        DTORoteiroProducao.DTOFaseProdutiva faseProd = new DTORoteiroProducao.DTOFaseProdutiva();
        if (celulaProdutiva != null) {
            faseProd.setCelulaProdutiva(celulaProdutiva.toString());
            faseProd.setCelulaProdutivaIdentificador(celulaProdutiva.getIdentificador());
            faseProd.setEficienciaEsperada(Double.valueOf(0.0));
            faseProd.setTempoIntervaloDescanso(Double.valueOf(0.0));
            faseProd.setQtdePorHora(Double.valueOf(0.0));
            faseProd.setQtdePorHoraPorUnidade(Double.valueOf(0.0));
            faseProd.setEquipamentos(this.buildEquipFaseProdutivaRoteiro(celulaProdutiva));
        }
        return faseProd;
    }

    private List<DTORoteiroProducao.DTOFaseProdutivaEquip> buildEquipFaseProdutivaRoteiro(CelulaProdutiva celulaProdutiva) {
        ArrayList<DTORoteiroProducao.DTOFaseProdutivaEquip> ret = new ArrayList<DTORoteiroProducao.DTOFaseProdutivaEquip>();
        if (celulaProdutiva.getEquipamentos() != null) {
            for (CelulaProdutivaEquipamento i : celulaProdutiva.getEquipamentos()) {
                DTORoteiroProducao.DTOFaseProdutivaEquip dto = new DTORoteiroProducao.DTOFaseProdutivaEquip();
                dto.setCelProdutivaEquip(i.toString());
                dto.setCelProdutivaEquipIdentificador(i.getIdentificador());
                dto.setCapacidadeProdutiva(Double.valueOf(0.0));
                dto.setAtivo(i.getAtivo());
                if (i.getEquipamento() != null) {
                    dto.setCodigoEquipamento(i.getEquipamento().getCodigo());
                    dto.setEquipamento(i.getEquipamento().toString());
                    dto.setIdentificadorEquipamento(i.getEquipamento().getIdentificador());
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    public DTORoteiroProducao.DTOFaseProdutivaTpRecurso buildFaseProdutivaTpRecurso(TipoRecursoPCP vo) {
        DTORoteiroProducao.DTOFaseProdutivaTpRecurso ret = new DTORoteiroProducao.DTOFaseProdutivaTpRecurso();
        ret.setTipoRecursoPCP(vo.getDescricao());
        ret.setTipoRecursoPCPIdentificador(vo.getIdentificador());
        ret.setQuantidadeHoras(Double.valueOf(0.0));
        ret.setQuantidadeRecursos(Double.valueOf(0.0));
        ret.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        return ret;
    }

    public DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao buildGrupoProdutosRoteiro(GrupoProdutos vo) {
        DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao ret = new DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao();
        ret.setGrupoProdutos(vo.toString());
        ret.setGrupoProdutosIdentificador(vo.getIdentificador());
        return ret;
    }
}

