/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.saldoestoquegeral;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeral;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperSaldoEstoqueGeral {
    public DTOSaldoEstoqueGeral toDto(SaldoEstoqueGeral s) {
        DTOSaldoEstoqueGeral dto = new DTOSaldoEstoqueGeral();
        dto.setIdentificador(s.getIdentificador());
        dto.setGradeCorIdentificador(s.getGradeCor().getIdentificador());
        if (!ToolMethods.isNull((Object)s.getLoteFabricacao()).booleanValue()) {
            dto.setLoteFabricacaoIdentificador(s.getLoteFabricacao().getIdentificador());
            dto.setLoteFabricacao(s.getLoteFabricacao().getLoteFabricacao());
            dto.setDataFabricacao(s.getLoteFabricacao().getDataFabricacao());
            dto.setDataValidade(s.getLoteFabricacao().getDataValidade());
        }
        dto.setEmpresaIdentificador(s.getEmpresa().getIdentificador());
        dto.setEmpresa(s.getEmpresa().getPessoa().getNomeFantasia());
        dto.setDataSaldo(s.getDataSaldo());
        dto.setQuantidade(s.getQuantidade());
        dto.setValor(s.getValor());
        dto.setValorMedio(s.getValorMedio());
        dto.setQuantidadeEntrada(s.getQuantidadeEntrada());
        dto.setQuantidadeSaida(s.getQuantidadeSaida());
        dto.setCentroEstoqueIdentificador(s.getCentroEstoque().getIdentificador());
        dto.setCentroEstoque(s.getCentroEstoque().getDescricao());
        dto.setProdutoIdentificador(s.getProduto().getIdentificador());
        dto.setProduto(s.getProduto().getNome());
        ArrayList subSaldo = new ArrayList();
        s.getSubSaldo().forEach(sub -> subSaldo.add(this.toDto((SaldoEstoqueGeral)sub)));
        dto.setSubSaldo(subSaldo);
        if (!ToolMethods.isNull((Object)s.getLocalizacao()).booleanValue()) {
            dto.setLocalizacaoIdentificador(s.getLocalizacao().getIdentificador());
            dto.setLocalizacao(s.getLocalizacao().getNome());
        } else {
            dto.setLocalizacao(s.getProduto().getLocalizacao().getNome());
        }
        return dto;
    }

    public List<DTOSaldoEstoqueGeral> toDto(List<SaldoEstoqueGeral> saldos) {
        ArrayList<DTOSaldoEstoqueGeral> listSaldosDto = new ArrayList<DTOSaldoEstoqueGeral>();
        if (saldos == null) {
            return listSaldosDto;
        }
        saldos.forEach(s -> listSaldosDto.add(this.toDto((SaldoEstoqueGeral)s)));
        return listSaldosDto;
    }
}

