/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.searchclass;

import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassField;
import com.touchcomp.basementor.model.vo.SearchClassFieldResItem;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import org.springframework.stereotype.Component;

@Component
public class HelperSearchClass
implements AbstractHelper<SearchClass> {
    private SearchClass searchClass;

    public HelperSearchClass build(SearchClass object) {
        this.searchClass = object;
        return this;
    }

    public SearchClass get() {
        return this.searchClass;
    }

    public String gerarSqlRes() {
        if (this.searchClass.getSearchFieldsRes() == null) {
            return "";
        }
        String defaultQueryRes = "UPDATE OR INSERT INTO SEARCH_CLASS_FIELD_RES (ID_SEARCH_CLASS_FIELD_RES, MASCARA,MASCARA_RES) VALUES (@id_search_class@, '@mascara@','@mascara_res@');";
        ArrayList<StringToken> tks = new ArrayList<StringToken>();
        tks.add(new StringToken("id_search_class", this.searchClass.getSearchFieldsRes().getIdentificador().toString()));
        tks.add(new StringToken("mascara", this.searchClass.getSearchFieldsRes().getMascara()));
        tks.add(new StringToken("mascara_res", this.searchClass.getSearchFieldsRes().getMascaraRes()));
        String st1 = ToolString.build((String)defaultQueryRes, tks);
        return st1;
    }

    public String gerarSqlSearch() {
        ArrayList<StringToken> tks = new ArrayList<StringToken>();
        String defaultQuery = "update or INSERT INTO SEARCH_CLASS (ID_SEARCH_CLASS, VO_CLASS, DESCRICAO,ID_SEARCH_CLASS_FIELD_RES, CAMPO_ORDENACAO) VALUES  (@id_search_class@, '@class@', '@descricao@', @id_search_class_res@,'@CAMPO_ORDENACAO@');";
        tks.clear();
        tks.add(new StringToken("id_search_class", TString.onlyNumbers((String)this.searchClass.getIdentificador().toString())));
        tks.add(new StringToken("class", this.searchClass.getVoClass()));
        tks.add(new StringToken("descricao", this.searchClass.getDescricao()));
        tks.add(new StringToken("CAMPO_ORDENACAO", this.searchClass.getCampoOrdenacao()));
        tks.add(new StringToken("id_search_class_res", this.searchClass.getSearchFieldsRes() != null ? TString.onlyNumbers((String)this.searchClass.getSearchFieldsRes().getIdentificador().toString()) : null));
        String st2 = ToolString.build((String)defaultQuery, tks);
        return st2;
    }

    public String gerarSqlSearchFields() {
        ArrayList<StringToken> tks = new ArrayList<StringToken>();
        String defaultQueryFields = "update or INSERT INTO SEARCH_FIELDS (ID_SEARCH_FIELD, DESCRICAO, PATH_FIELD, ID_SEARCH_CLASS, FIELD_CLASS, PERC_SIZE, INDICE, FIELD_TYPE_OPT, DEFAULT_VALUE, DEFAULT_CRITERIA, VISIBLE_OPT, ATIVO,TIPO_SMART_SEARCH, APLICAR_HOME_WEB, NUMERO_CARACTERES) VALUES (@id_field@, '@desc_field@', '@path_field@', @id_search@, '@field_class@', @perc_size@, @indice@, @field_type@,'@default_value@', @default_criteria@, @visible_opt@,@ativo_opt@,@TIPO_SMART_SEARCH@, @APLICAR_HOME_WEB@, @NUMERO_CARACTERES@);";
        Object st2 = "";
        int i = 0;
        for (SearchClassField field : this.searchClass.getSearchFields()) {
            if (field == null) continue;
            tks.clear();
            tks.add(new StringToken("id_field", TString.onlyNumbers((String)field.getIdentificador().toString())));
            tks.add(new StringToken("desc_field", field.getDescricao()));
            tks.add(new StringToken("path_field", field.getPathField()));
            tks.add(new StringToken("id_search", this.searchClass != null ? TString.onlyNumbers((String)this.searchClass.getIdentificador().toString()) : null));
            tks.add(new StringToken("field_class", field.getFieldClass()));
            tks.add(new StringToken("perc_size", field.getPercSize() != null ? TString.onlyNumbers((String)field.getPercSize().toString()) : "0"));
            tks.add(new StringToken("indice", String.valueOf(i)));
            tks.add(new StringToken("field_type", field.getFieldTypeOpt() != null ? TString.onlyNumbers((String)field.getFieldTypeOpt().toString()) : "0"));
            tks.add(new StringToken("default_value", TMethods.isStrWithData((String)field.getDefaultValue()) ? field.getDefaultValue() : "null"));
            tks.add(new StringToken("default_criteria", field.getDefaultCriteria() != null ? TString.onlyNumbers((String)field.getDefaultCriteria().toString()) : "0"));
            tks.add(new StringToken("visible_opt", field.getVisibleOpt() != null ? TString.onlyNumbers((String)field.getVisibleOpt().toString()) : "0"));
            tks.add(new StringToken("ativo_opt", field.getAtivo() != null ? TString.onlyNumbers((String)field.getAtivo().toString()) : "0"));
            tks.add(new StringToken("TIPO_SMART_SEARCH", field.getTipoSmartSearch() != null ? TString.onlyNumbers((String)field.getTipoSmartSearch().toString()) : "null"));
            tks.add(new StringToken("APLICAR_HOME_WEB", TMethods.isAffirmative((Number)field.getAplicarHomeWeb()) ? "1" : "0"));
            tks.add(new StringToken("NUMERO_CARACTERES", ToolMethods.isNotNull((Object)field.getNumeroCaracteres()) != false ? field.getNumeroCaracteres().toString() : "0"));
            st2 = (String)st2 + "\n" + ToolString.build((String)defaultQueryFields, tks);
            ++i;
        }
        return st2;
    }

    public String gerarSqlResField() {
        if (this.searchClass.getSearchFieldsRes() == null) {
            return "";
        }
        ArrayList<StringToken> tks = new ArrayList<StringToken>();
        String defaultQueryResField = "UPDATE OR INSERT INTO SEARCH_CLASS_FIELD_R_ITEM (ID_SEARCH_CLASS_FIELD_R_IT, PATH_FIELD, ATIVO, ID_SEARCH_CLASS_FIELD_RES, INDICE,PATH_FIELD_DESC) VALUES (@id_field@, '@field@', @ativo@, @res_id_search_class@, @indice@,'@PATH_FIELD_DESC@');";
        int i = 0;
        Object st1 = "";
        for (SearchClassFieldResItem field : this.searchClass.getSearchFieldsRes().getFields()) {
            tks.clear();
            if (field == null) continue;
            tks.add(new StringToken("id_field", TString.onlyNumbers((String)field.getIdentificador().toString())));
            tks.add(new StringToken("field", field.getPathField()));
            tks.add(new StringToken("ativo", field.getAtivo() != null ? field.getAtivo().toString() : "0"));
            tks.add(new StringToken("res_id_search_class", this.searchClass.getSearchFieldsRes() != null ? TString.onlyNumbers((String)this.searchClass.getSearchFieldsRes().getIdentificador().toString()) : null));
            tks.add(new StringToken("indice", String.valueOf(i)));
            tks.add(new StringToken("PATH_FIELD_DESC", field.getPathFieldDesc()));
            st1 = (String)st1 + "\n" + ToolString.build((String)defaultQueryResField, tks);
            ++i;
        }
        return st1;
    }

    public String gerarSQL() {
        String st1 = this.gerarSqlRes();
        String st2 = this.gerarSqlResField();
        String st3 = this.gerarSqlSearch();
        String st4 = this.gerarSqlSearchFields();
        return ToolString.build((String)"\n", (String[])new String[]{st1, st2, st3, st4});
    }
}

