/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.smartlink;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementor.model.vo.SmartLink;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import org.springframework.stereotype.Component;

@Component
public class HelperSmartLink {
    public SmartLink buildSmartLink(SmartComponentPref smartComp, EnumConstStatusObjeto status, Nodo nodo, Nodo nodoSmartLink, Pessoa pessoa, ModeloEnvioMensagens modelo, Long registro, Date dataValidade, OpcoesSistema opcoes) throws UnknownHostException, ExceptionValidacaoDados {
        SmartLink vo = new SmartLink();
        vo.setNodo(nodo);
        vo.setRegistro(registro);
        vo.setSmartComponentPref(smartComp);
        vo.setStatus(Short.valueOf(status.getValue()));
        vo.setDataValidade(dataValidade);
        String token = this.getToken();
        vo.setToken(token);
        vo.setLink(this.getUrl(opcoes, pessoa, nodo, nodoSmartLink, registro, token));
        return vo;
    }

    private String getToken() {
        Random rnd = new Random();
        Integer number = rnd.nextInt(999999);
        return String.format("%06d", number);
    }

    private String getUrl(OpcoesSistema opcoes, Pessoa pessoa, Nodo nodo, Nodo smartLink, Long identificadorReg, String token) throws UnknownHostException, ExceptionValidacaoDados {
        Object url = opcoes.getEnderecoAppWebBack();
        if (smartLink != null && TMethods.isStrWithData((String)smartLink.getPathWeb())) {
            if (TMethods.isStrWithData((String)opcoes.getEnderecoAppWebBack())) {
                url = (String)url + "noauth/" + smartLink.getPathWeb();
                url = (String)url + "/redirect?pessoa=" + ToolHexString.encodeToHex((String)pessoa.getIdentificador().toString());
                url = (String)url + "&nodo=" + ToolHexString.encodeToHex((String)nodo.getIdentificador().toString());
                url = (String)url + "&identificador=" + ToolHexString.encodeToHex((String)identificadorReg.toString());
                url = (String)url + "&token=" + token;
                return url;
            }
            throw new ExceptionValidacaoDados("E.ERP.1969.003", new Object[0]);
        }
        throw new ExceptionValidacaoDados("E.ERP.1969.004", new Object[0]);
    }

    public String urlToRedirect(Nodo nodo, Long idRecurso, OpcoesSistema opcoes, SmartLink smartLink, String token) throws ExceptionObjNotFound, UnknownHostException {
        if (!TMethods.isStrWithData((String)nodo.getPathWeb())) {
            throw new ExceptionRuntimeBase("E.ERP.1969.004");
        }
        if (!TMethods.isStrWithData((String)opcoes.getEnderecoAppWebFront())) {
            throw new ExceptionRuntimeBase("E.ERP.1969.005");
        }
        if (!ToolMethods.isEquals((Object)smartLink.getToken(), (Object)token)) {
            throw new ExceptionRuntimeBase("E.ERP.1969.006");
        }
        String url = opcoes.getEnderecoAppWebFront() + this.getPathWeb(nodo) + "/" + idRecurso;
        return url;
    }

    private String getPathWeb(Nodo nodo) {
        String path = nodo.getPathWeb();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

