/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.solicitacaolibusuario;

import com.touchcomp.basementor.constants.enums.solicitacaoliberacaousuario.EnumConstSolLibUsuarioTipo;
import com.touchcomp.basementor.model.vo.SolicitacaoLibUsuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.aleatory.TAleatory;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperSolicitacaoLibUsuario
implements AbstractHelper<SolicitacaoLibUsuario> {
    private SolicitacaoLibUsuario helperSolicitacaoLibUsuario;

    public HelperSolicitacaoLibUsuario build(SolicitacaoLibUsuario object) {
        this.helperSolicitacaoLibUsuario = object;
        return this;
    }

    public SolicitacaoLibUsuario get() {
        return this.helperSolicitacaoLibUsuario;
    }

    public SolicitacaoLibUsuario novaSolLembreteSenha(UsuarioBasico user, String email, double numHoras) {
        SolicitacaoLibUsuario sol = new SolicitacaoLibUsuario();
        sol.setUsuarioSolicitante(user);
        sol.setTipoLiberacao(EnumConstSolLibUsuarioTipo.USUARIO_ESQUECEU_SENHA.getValue());
        sol.setDescricao(EnumConstSolLibUsuarioTipo.USUARIO_ESQUECEU_SENHA.getDescricao());
        sol.setTokenLiberacao(this.getToken());
        sol.setEmail(email);
        sol.setDataSolicitacao(new Date());
        sol.setDataVencimento(ToolDate.nextDays((Date)sol.getDataSolicitacao(), (double)numHoras));
        return sol;
    }

    public SolicitacaoLibUsuario novaAutenticacao2Niveis(UsuarioBasico user, String login, Integer numHoras) {
        SolicitacaoLibUsuario sol = new SolicitacaoLibUsuario();
        sol.setUsuarioSolicitante(user);
        sol.setTipoLiberacao(EnumConstSolLibUsuarioTipo.AUTENTICACAO_DOIS_NIVEIS.getValue());
        sol.setDescricao(EnumConstSolLibUsuarioTipo.AUTENTICACAO_DOIS_NIVEIS.getDescricao());
        sol.setTokenLiberacao(this.getToken());
        sol.setEmail(login);
        sol.setDataSolicitacao(new Date());
        sol.setDataVencimento(ToolDate.nextDays((Date)sol.getDataSolicitacao(), (int)numHoras));
        return sol;
    }

    private String getToken() {
        int maxToken = MessagesBaseMentor.getMax2faTokens();
        int nr = TAleatory.generateRandomNumber((int)0, (int)maxToken);
        return MessagesBaseMentor.getBase2faTokens((int)nr);
    }
}

