/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.solicitacaoservicos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.SolicitacaoServico;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.Date;

public class HelperSolicitacaoServicos
implements AbstractHelper<SolicitacaoServico> {
    SolicitacaoServico solicitacaoServico;

    public SolicitacaoServico get() {
        return this.solicitacaoServico;
    }

    public HelperSolicitacaoServicos build(SolicitacaoServico data) {
        this.solicitacaoServico = data;
        return this;
    }

    public ItemControleSolicitacaoServico buildItemControleSolicitacaoServico(Empresa e) {
        ItemControleSolicitacaoServico itemToAdd = new ItemControleSolicitacaoServico();
        itemToAdd.setDataCadastro(new Date());
        itemToAdd.setEmpresa(e);
        itemToAdd.setOrdemServico(this.buildOrdemServicoSolicitacaoServico());
        itemToAdd.setSolicitacaoServico(this.solicitacaoServico);
        return itemToAdd;
    }

    public OrdemServico buildOrdemServicoSolicitacaoServico() {
        OrdemServico osGerada = new OrdemServico();
        osGerada.setDataCadastro(new Date());
        osGerada.setDataEmissao(new Date());
        osGerada.setDataHoraParada(this.solicitacaoServico.getDataHoraParada());
        osGerada.setDescricaoServico(this.solicitacaoServico.getDescricao());
        osGerada.setEmpresa(this.solicitacaoServico.getEmpresa());
        if (this.solicitacaoServico.getAtivo() != null) {
            osGerada.setEquipamento(this.solicitacaoServico.getAtivo());
            osGerada.setCentroCusto(this.solicitacaoServico.getAtivo().getCentroCusto());
        }
        osGerada.setGerado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        osGerada.setPrioridade(this.solicitacaoServico.getPrioridade());
        osGerada.setSolicitante(this.solicitacaoServico.getUsuario().getUsuarioBasico().getPessoa());
        osGerada.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        osGerada.setTipoServico(this.solicitacaoServico.getTipoServico());
        osGerada.setAtivoParado(this.solicitacaoServico.getAtivoParado());
        return osGerada;
    }
}

