/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRF;
import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo.HelperCalculoInss;
import com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo.HelperCalculoIrrf;
import com.touchcomp.basementorservice.service.impl.tabelairrf.ServiceTabelaIRRFImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.Comparator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperTerminoTrabalhadorSemVinculo
implements AbstractHelper<TerminoTrabalhadorSemVinculo> {
    TerminoTrabalhadorSemVinculo terminoTrabalhadorSemVinculo;
    @Autowired
    HelperCalculoInss helperCalculoInss;
    @Autowired
    HelperCalculoIrrf helperCalculoIrrf;
    @Autowired
    ServiceTabelaIRRFImpl serviceTabelaIRRFImpl;

    public TerminoTrabalhadorSemVinculo get() {
        return this.terminoTrabalhadorSemVinculo;
    }

    public HelperTerminoTrabalhadorSemVinculo build(TerminoTrabalhadorSemVinculo terminoTrabalhadorSemVinculo) {
        this.terminoTrabalhadorSemVinculo = terminoTrabalhadorSemVinculo;
        return this;
    }

    public TerminoTrabalhadorSemVinculo calcularImpostoTerminoContratoTsv(TerminoTrabalhadorSemVinculo vo, EmpresaRh empresaRh) {
        if (ToolMethods.isNull((Object)empresaRh.getPercAutonomo()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.009"));
        }
        Double aliquota = empresaRh.getPercAutonomo();
        Double percentualBcFrete = empresaRh.getPercBcFrete();
        this.calcularInss(vo, aliquota, percentualBcFrete);
        this.calcularInss13(vo, aliquota, percentualBcFrete);
        HelperColaborador helperColaborador = new HelperColaborador();
        Integer dependentesIrrf = helperColaborador.build(vo.getColaborador()).getDependentesIRRF(vo.getDataPagamento()).size();
        TabelaIRRF tabelaIRRF = this.serviceTabelaIRRFImpl.getTabelaIrrfPorDataPagamento(vo.getDataPagamento());
        if (ToolMethods.isNull((Object)tabelaIRRF).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1704.010"));
        }
        this.calcularIrrf(vo, dependentesIrrf, tabelaIRRF);
        this.calcularIrrf13(vo, dependentesIrrf, tabelaIRRF);
        this.calcularTotalizadores(vo);
        return vo;
    }

    private void calcularInss(TerminoTrabalhadorSemVinculo vo, Double aliquotaInss, Double percentualBcFrete) {
        Double bcInssSalarioProvento = vo.getItensTerminoTsv().stream().filter(i -> !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)0)).mapToDouble(m -> m.getValor()).sum();
        Double bcInssSalarioDesconto = vo.getItensTerminoTsv().stream().filter(i -> !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)1)).mapToDouble(m -> m.getValor()).sum();
        Double baseInssSalario = this.calcularBaseCalculoInssArredondada(vo.getColaborador().getTipoColaborador(), bcInssSalarioProvento, bcInssSalarioDesconto, percentualBcFrete);
        Map valores = this.helperCalculoInss.calcularInss(baseInssSalario, aliquotaInss, 0.0);
        vo.setBaseCalculoInss((Double)valores.get("baseInss"));
        vo.setAliquotaInss((Double)valores.get("aliquotaInss"));
        vo.setValorInss((Double)valores.get("valorInss"));
    }

    private void calcularInss13(TerminoTrabalhadorSemVinculo vo, Double aliquotaInss13, Double percentualBcFrete) {
        Double bcInssProvento13 = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)0)).mapToDouble(m -> m.getValor()).sum();
        Double bcInssDesconto13 = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)1)).mapToDouble(m -> m.getValor()).sum();
        Double baseInssDecTerceiro = this.calcularBaseCalculoInssArredondada(vo.getColaborador().getTipoColaborador(), bcInssProvento13, bcInssDesconto13, percentualBcFrete);
        Map valores = this.helperCalculoInss.calcularInss(baseInssDecTerceiro, aliquotaInss13, 0.0);
        vo.setBaseCalculoInssDec((Double)valores.get("baseInss"));
        vo.setAliquotaInssDec((Double)valores.get("aliquotaInss"));
        vo.setValorInssDec((Double)valores.get("valorInss"));
    }

    private void calcularIrrf(TerminoTrabalhadorSemVinculo vo, Integer dependentesIrrf, TabelaIRRF tabelaIRRF) {
        Double bcIrrfProvento = vo.getItensTerminoTsv().stream().filter(i -> !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)0)).mapToDouble(m -> m.getValor()).sum();
        Double bcIrrfDesconto = vo.getItensTerminoTsv().stream().filter(i -> !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)1)).mapToDouble(m -> m.getValor()).sum();
        Double vrDeducaoDependentes = (double)dependentesIrrf.intValue() * tabelaIRRF.getVrDeducaoPorDependente();
        Double bcIrrfSalario = bcIrrfProvento - bcIrrfDesconto - vo.getValorInss() - vrDeducaoDependentes;
        ItemTabelaIRRF itemTabelaIrrf = tabelaIRRF.getItensTabela().stream().filter(i -> i.getValorAte() >= bcIrrfSalario).min(Comparator.comparingDouble(ItemTabelaIRRF::getValorAte)).get();
        Map valores = this.helperCalculoIrrf.calcularIRRF(bcIrrfSalario, itemTabelaIrrf.getAliquota(), itemTabelaIrrf.getVrDeducao(), tabelaIRRF.getVrMinimoADescontar(), 0.0);
        vo.setBaseCalculoIrrf((Double)valores.get("baseIrrf"));
        vo.setAliquotaIrrf((Double)valores.get("aliquotaIrrf"));
        vo.setValorIrrf((Double)valores.get("valorIrrf"));
    }

    private void calcularIrrf13(TerminoTrabalhadorSemVinculo vo, Integer dependentesIrrf, TabelaIRRF tabelaIRRF) {
        Double bcIrrfProventoDec = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)0)).mapToDouble(m -> m.getValor()).sum();
        Double bcIrrfDescontoDec = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getTipoCalculo().getTipoFolha().intValue(), (Object)2) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().intValue(), (Object)1) && ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)1)).mapToDouble(m -> m.getValor()).sum();
        Double vrDeducaoDependentes = (double)dependentesIrrf.intValue() * tabelaIRRF.getVrDeducaoPorDependente();
        Double baseIrrfDecTerceiro = bcIrrfProventoDec - bcIrrfDescontoDec - vo.getValorInssDec() - vrDeducaoDependentes;
        ItemTabelaIRRF itemTabelaIrrfDecTerceiro = tabelaIRRF.getItensTabela().stream().filter(i -> i.getValorAte() >= baseIrrfDecTerceiro).min(Comparator.comparingDouble(ItemTabelaIRRF::getValorAte)).get();
        Map valores = this.helperCalculoIrrf.calcularIRRF(baseIrrfDecTerceiro, itemTabelaIrrfDecTerceiro.getAliquota(), itemTabelaIrrfDecTerceiro.getVrDeducao(), 0.0, 0.0);
        vo.setBaseCalculoIrrfDec((Double)valores.get("baseIrrf"));
        vo.setAliquotaIrrfDec((Double)valores.get("aliquotaIrrf"));
        vo.setValorIrrfDec((Double)valores.get("valorIrrf"));
    }

    private Double calcularBaseCalculoInssArredondada(TipoColaborador tipoColaborador, Double bcInssProvento, Double bcInssDesconto, Double percentualBcFrete) {
        if (ToolMethods.isEquals((Object)tipoColaborador.getIdentificador(), (Object)1L) || ToolMethods.isEquals((Object)tipoColaborador.getIdentificador(), (Object)7L)) {
            return ToolNumber.arredondarNumero((Double)(bcInssProvento - bcInssDesconto), (Integer)2, (Integer)0);
        }
        if (ToolMethods.isEquals((Object)tipoColaborador.getIdentificador(), (Object)2L)) {
            return ToolNumber.arredondarNumero((Double)((bcInssProvento - bcInssDesconto) * (percentualBcFrete / 100.0)), (Integer)2, (Integer)0);
        }
        return 0.0;
    }

    private void calcularTotalizadores(TerminoTrabalhadorSemVinculo vo) {
        Double vrtotalProventos = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)0)).mapToDouble(m -> m.getValor()).sum();
        Double vrtotalDescontos = vo.getItensTerminoTsv().stream().filter(i -> ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().intValue(), (Object)1) && !ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo(), (Object)1019L)).mapToDouble(m -> m.getValor()).sum();
        Double totalDesconto = vrtotalDescontos + vo.getValorInss() + vo.getValorInssDec() + vo.getValorIrrf() + vo.getValorIrrfDec();
        Double totalLiquido = vrtotalProventos - totalDesconto;
        vo.setTotalProventos(vrtotalProventos);
        vo.setTotalDescontos(totalDesconto);
        vo.setTotalLiquido(totalLiquido);
    }
}

