/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.titulo;

import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.titulo.AuxJurosMultaTitulo;
import com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante.HelperTituloRepresentanteNFCe;
import com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante.HelperTituloRepresentanteNotaPropria;
import com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante.HelperTituloRepresentantePedido;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperTitulos
implements AbstractHelper<Titulo> {
    private Titulo titulo;

    public HelperTitulos build(Titulo titulo) {
        this.titulo = titulo;
        return this;
    }

    public Titulo get() {
        return this.titulo;
    }

    public Double calcularVrJuros() {
        return this.calcularVrJuros(new Date());
    }

    public Double calcularVrJuros(Date dataBase) {
        Double percJuros = this.titulo.getPercJurosMes();
        Double vrJurosDia = this.titulo.getVrJurosDia();
        Double valor = this.titulo.getValorSaldo();
        Integer diasTol = 0;
        if (valor == null) {
            valor = 0.0;
        }
        if (vrJurosDia == null) {
            vrJurosDia = 0.0;
        }
        if (percJuros == null) {
            percJuros = 0.0;
        }
        int dias = ToolDate.diferenceDayBetweenDates((Date)this.titulo.getDataVencimento(), (Date)dataBase);
        if (this.titulo.getPessoa().getPessoaDadosFinanceiros() != null) {
            diasTol = this.titulo.getPessoa().getPessoaDadosFinanceiros().getDiasCarenciaJuros();
        }
        if ((dias -= diasTol.intValue()) < 0) {
            dias = 0;
        }
        Double valorJuros = 0.0;
        valorJuros = ToolMethods.isWithData((Number)percJuros) ? ToolFormatter.arrredondarNumero((Double)((double)dias * (percJuros / 30.0) / 100.0 * valor), (int)2) : ToolFormatter.arrredondarNumero((Double)((double)dias * vrJurosDia), (int)2);
        return valorJuros;
    }

    public Double calcularVrMulta() {
        return this.calcularVrMulta(new Date());
    }

    public Double calcularVrMulta(Date dataBase) {
        Double percMulta = this.titulo.getPercMulta();
        Double valor = this.titulo.getValorSaldo();
        Integer diasTol = 0;
        if (valor == null) {
            valor = 0.0;
        }
        if (percMulta == null) {
            percMulta = 0.0;
        }
        int dias = ToolDate.diferenceDayBetweenDates((Date)this.titulo.getDataVencimento(), (Date)dataBase);
        if (this.titulo.getPessoa().getPessoaDadosFinanceiros() != null) {
            diasTol = this.titulo.getPessoa().getPessoaDadosFinanceiros().getDiasCarenciaMulta();
        }
        if ((dias -= diasTol.intValue()) <= 0) {
            return 0.0;
        }
        Double valorMulta = ToolFormatter.arrredondarNumero((Double)(percMulta / 100.0 * valor), (int)2);
        return valorMulta;
    }

    public Double calcularVrDesconto() {
        return this.calcularVrDesconto(new Date());
    }

    public Double calcularVrDesconto(Date dataBase) {
        Double percDesconto = this.titulo.getPercDescontoMes();
        Double valor = this.titulo.getValorSaldo();
        Date dataVencTitulo = this.titulo.getDataVencimento();
        if (valor == null) {
            valor = 0.0;
        }
        if (percDesconto == null) {
            percDesconto = 0.0;
        }
        if (dataBase != null && dataVencTitulo != null && dataBase.before(dataVencTitulo)) {
            int dias = ToolDate.diferenceDayBetweenDates((Date)dataBase, (Date)dataVencTitulo);
            double aux = percDesconto / 100.0 * valor;
            return (double)dias * (aux /= 30.0);
        }
        return 0.0;
    }

    public void atualizaTitulosRep(NotaFiscalPropria notaFiscalPropria, OpcoesFinanceiras opcoesFinanceiras) {
        HelperTituloRepresentanteNotaPropria helperTituloRepresentante = new HelperTituloRepresentanteNotaPropria();
        helperTituloRepresentante.calcTitulosRepresentante(notaFiscalPropria, opcoesFinanceiras);
    }

    public void atualizaTitulosRep(Pedido pedido, OpcoesFinanceiras op) {
        HelperTituloRepresentantePedido helperTituloRepresentante = new HelperTituloRepresentantePedido();
        helperTituloRepresentante.calcTitulosRepresentante(pedido, op);
    }

    public void setarPercJurosMultaDesconto(Titulo titulo, OpcoesFinanceiras opcoes) {
        new AuxJurosMultaTitulo().setarPercJurosMultaDesconto(titulo, opcoes);
    }

    public void atualizaTitulosRep(NFCe nfce, OpcoesFinanceiras opcoesFinanceiras) {
        HelperTituloRepresentanteNFCe helperTituloRepresentante = new HelperTituloRepresentanteNFCe();
        helperTituloRepresentante.calcTitulosRepresentante(nfce, opcoesFinanceiras);
    }

    public Long calcularDiasAtraso(Double valorSaldo, Date dataVencimento) {
        if (TMethods.isNull((Object)valorSaldo).booleanValue() || valorSaldo <= 0.0) {
            return 0L;
        }
        Date dataAtual = new Date();
        if (TMethods.isNull((Object)dataVencimento).booleanValue() || dataAtual.before(dataVencimento)) {
            return 0L;
        }
        return ToolDate.difBetweenDatesInDays((Date)dataAtual, (Date)dataVencimento);
    }

    public Double calcularValorBaixado(Double valorTitulo, Double valorSaldo) {
        if (TMethods.isNotNull((Object)valorTitulo).booleanValue() && TMethods.isNotNull((Object)valorSaldo).booleanValue()) {
            return valorTitulo - valorSaldo;
        }
        return 0.0;
    }
}

