/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante;

import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante.BaseHelperTituloRepresentante;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HelperTituloRepresentanteNFCe
extends BaseHelperTituloRepresentante {
    public void calcTitulosRepresentante(NFCe vo, OpcoesFinanceiras op) {
        if (vo.getPagamentos() == null) {
            vo.setPagamentos(new LinkedList());
        }
        vo.getPagamentos().forEach(i -> {
            if (i.getTitulosGerados() != null) {
                i.getTitulosGerados().forEach(t -> t.getRepresentantes().clear());
            }
        });
        if (vo.getNaturezaOperacao().getGerarComissaoRep() == null || vo.getNaturezaOperacao().getGerarComissaoRep() != 1) {
            return;
        }
        List<BaseHelperTituloRepresentante.BaseCalcComissao> comissoes = this.getPercentualComissaoItensNFCe(vo.getItens(), op);
        for (BaseHelperTituloRepresentante.BaseCalcComissao h : comissoes) {
            NFCePagamento infPag;
            Object infPag22;
            Double vrTotal = h.getValorTotalItens();
            Double percComissao = h.getPercComissao();
            Representante representante = h.getRepresentante();
            Double valorComissao = 0.0;
            for (Object infPag22 : vo.getPagamentos()) {
                valorComissao = valorComissao + infPag22.getValor();
            }
            Double valorAcumulado = 0.0;
            infPag22 = vo.getPagamentos().iterator();
            while (infPag22.hasNext()) {
                infPag = (NFCePagamento)infPag22.next();
                Integer numParcelas = infPag.getTitulos().size();
                Double percentual = this.arrredondarNumero(infPag.getValor() * 100.0 / valorComissao, 6);
                Double valorBCComissao = this.arrredondarNumero(vrTotal * percentual / 100.0, 2);
                Double valorRateioBC = this.arrredondarNumero(valorBCComissao / (double)(numParcelas > 0 ? numParcelas : 1), 2);
                if (representante == null) {
                    return;
                }
                for (Titulo t : infPag.getTitulosGerados()) {
                    valorAcumulado = valorAcumulado + valorRateioBC;
                    valorAcumulado = this.arrredondarNumero(valorAcumulado, 2);
                    t.getRepresentantes().add(this.getTituloRepresentante(representante, t, percComissao, valorRateioBC));
                }
            }
            Integer size = vo.getPagamentos().size();
            if (size <= 0) continue;
            infPag = (NFCePagamento)vo.getPagamentos().get(size - 1);
            block4: for (Titulo t : infPag.getTitulosGerados()) {
                if (t.getRepresentantes() == null || t.getRepresentantes().isEmpty()) continue;
                for (TituloRepresentante tr : t.getRepresentantes()) {
                    if (!tr.getRepresentante().equals((Object)representante)) continue;
                    tr.setVrBCComissao(this.arrredondarNumero(tr.getVrBCComissao() + (vrTotal - valorAcumulado), 2));
                    continue block4;
                }
            }
        }
    }

    private List<BaseHelperTituloRepresentante.BaseCalcComissao> getPercentualComissaoItensNFCe(List<NFCeItem> itensNFCe, OpcoesFinanceiras op) {
        ArrayList<BaseHelperTituloRepresentante.BaseCalcComissao> comissoes = new ArrayList<BaseHelperTituloRepresentante.BaseCalcComissao>();
        for (NFCeItem i : itensNFCe) {
            Representante rep = i.getRepresentante();
            if (rep == null) continue;
            boolean achou = false;
            BaseHelperTituloRepresentante.BaseCalcComissao h = null;
            for (BaseHelperTituloRepresentante.BaseCalcComissao c : comissoes) {
                if (!c.getRepresentante().equals((Object)rep)) continue;
                h = c;
                achou = true;
            }
            if (!achou) {
                h = new BaseHelperTituloRepresentante.BaseCalcComissao();
                h.setRepresentante(rep);
                h.setPercComissao(0.0);
                h.setValorTotalComissao(0.0);
                h.setValorTotalItens(0.0);
                comissoes.add(h);
            }
            Double valor = i.getValorTotalBruto();
            if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirValoresDescontosBCComissaoTitulo())) {
                valor = valor - i.getValorDesconto();
            }
            if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirValoresAcessoriosBCComissaoTitulo())) {
                valor = valor + i.getValorDespesasAcessorias();
            }
            ModeloFiscalIcms modelo = i.getModeloFiscal().getModeloFiscalIcms();
            if (ToolMethods.isAffirmative((Number)op.getDescontarIcmsDesoneradoComissao()) && (i.getNfce().getUnidadeFatCliente() == null || i.getNfce().getUnidadeFatCliente().getPessoa().getComplemento().getHabilitarSuframa() == null || i.getNfce().getUnidadeFatCliente().getPessoa().getComplemento().getHabilitarSuframa() != 1 || modelo.getMotivoDesoneracaoIcms() == null || !modelo.getMotivoDesoneracaoIcms().getCodigo().equals("7") || i.getProduto().getNaoAplicaSuframa() != null && !i.getProduto().getNaoAplicaSuframa().equals((short)0))) {
                valor = valor - i.getIcms().getValorIcmsDesonerado();
            }
            Double valorTotalComissao = this.arrredondarNumero(valor * i.getPercentualComissao() / 100.0, 4);
            Double valorTotalItens = valor;
            h.setValorTotalItens(h.getValorTotalItens() + valorTotalItens);
            h.setValorTotalComissao(h.getValorTotalComissao() + valorTotalComissao);
            h.setPercComissao(this.arrredondarNumero(h.getValorTotalComissao() * 100.0 / h.getValorTotalItens(), 4));
        }
        return comissoes;
    }

    private Double arrredondarNumero(Double value, int casasDec) {
        return ToolFormatter.arrredondarNumero((Double)value, (int)casasDec);
    }
}

