/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante;

import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorservice.helpers.impl.titulo.titulorepresentante.BaseHelperTituloRepresentante;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HelperTituloRepresentantePedido
extends BaseHelperTituloRepresentante {
    public void calcTitulosRepresentante(Pedido vo, OpcoesFinanceiras op) {
        if (vo.getInfPagamentoPedido() == null) {
            vo.setInfPagamentoPedido(new LinkedList());
        }
        vo.getInfPagamentoPedido().forEach(i -> {
            if (i.getTitulos() != null) {
                i.getTitulos().forEach(t -> t.getRepresentantes().clear());
            }
        });
        if (vo.getNaturezaOperacao().getGerarComissaoRep() == null || vo.getNaturezaOperacao().getGerarComissaoRep() != 1) {
            return;
        }
        List<BaseHelperTituloRepresentante.BaseCalcComissao> comissoes = this.getPercentualComissaoItensPedido(vo, op);
        for (BaseHelperTituloRepresentante.BaseCalcComissao h : comissoes) {
            InfPagamentoPedido infPag;
            Object infPag22;
            Double vrTotal = h.getValorTotalItens();
            Double percComissao = h.getPercComissao();
            Representante representante = h.getRepresentante();
            Double valorComissao = 0.0;
            for (Object infPag22 : vo.getInfPagamentoPedido()) {
                if (infPag22.getNaoGerarComissao() != null && !infPag22.getNaoGerarComissao().equals((short)0)) continue;
                valorComissao = valorComissao + infPag22.getValor();
            }
            Double valorAcumulado = 0.0;
            infPag22 = vo.getInfPagamentoPedido().iterator();
            while (infPag22.hasNext()) {
                infPag = (InfPagamentoPedido)infPag22.next();
                if (infPag.getNaoGerarComissao() != null && !infPag.getNaoGerarComissao().equals((short)0)) continue;
                Integer numParcelas = infPag.getTitulos().size();
                Double percentual = this.arrredondarNumero(infPag.getValor() * 100.0 / valorComissao, 6);
                Double valorBCComissao = this.arrredondarNumero(vrTotal * percentual / 100.0, 2);
                Double valorRateioBC = this.arrredondarNumero(valorBCComissao / (double)(numParcelas > 0 ? numParcelas : 1), 2);
                if (representante == null) {
                    return;
                }
                for (Titulo t : infPag.getTitulos()) {
                    valorAcumulado = valorAcumulado + valorRateioBC;
                    valorAcumulado = this.arrredondarNumero(valorAcumulado, 2);
                    t.getRepresentantes().add(this.getTituloRepresentante(representante, t, percComissao, valorRateioBC));
                }
            }
            Integer size = vo.getInfPagamentoPedido().size();
            if (size <= 0 || (infPag = (InfPagamentoPedido)vo.getInfPagamentoPedido().get(size - 1)).getNaoGerarComissao() != null && !infPag.getNaoGerarComissao().equals((short)0)) continue;
            block4: for (Titulo t : infPag.getTitulos()) {
                if (t.getRepresentantes() == null || t.getRepresentantes().isEmpty()) continue;
                for (TituloRepresentante tr : t.getRepresentantes()) {
                    if (!tr.getRepresentante().equals((Object)representante)) continue;
                    tr.setVrBCComissao(this.arrredondarNumero(tr.getVrBCComissao() + (vrTotal - valorAcumulado), 2));
                    continue block4;
                }
            }
        }
    }

    private List<BaseHelperTituloRepresentante.BaseCalcComissao> getPercentualComissaoItensPedido(Pedido vo, OpcoesFinanceiras op) {
        ArrayList<BaseHelperTituloRepresentante.BaseCalcComissao> comissoes = new ArrayList<BaseHelperTituloRepresentante.BaseCalcComissao>();
        Representante rep = vo.getRepresentante();
        BaseHelperTituloRepresentante.BaseCalcComissao h = new BaseHelperTituloRepresentante.BaseCalcComissao();
        h.setRepresentante(rep);
        h.setPercComissao(0.0);
        h.setValorTotalComissao(0.0);
        h.setValorTotalItens(0.0);
        for (ItemPedido i : vo.getItemPedido()) {
            Double valor = i.getValorTotalBruto();
            if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirValoresDescontosBCComissaoTitulo())) {
                valor = valor - (i.getValorDesconto() + i.getValorDescontoTrib());
            }
            if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirValoresAcessoriosBCComissaoTitulo())) {
                valor = valor + i.getValorDespesaAcessoria();
            }
            if (i.getModeloFiscal() != null) {
                ModeloFiscalIcms modelo = i.getModeloFiscal().getModeloFiscalIcms();
                if (i.getItemPedidoFiscal() != null && ToolMethods.isAffirmative((Number)op.getDescontarIcmsDesoneradoComissao()) && i.getPedido().getUnidadeFatCliente().getPessoa().getComplemento().getHabilitarSuframa() != null && i.getPedido().getUnidadeFatCliente().getPessoa().getComplemento().getHabilitarSuframa() == 1 && modelo.getMotivoDesoneracaoIcms() != null && modelo.getMotivoDesoneracaoIcms().getCodigo().equals("7") && (i.getProduto().getNaoAplicaSuframa() == null || i.getProduto().getNaoAplicaSuframa().equals((short)0))) {
                    valor = valor - i.getItemPedidoFiscal().getVrICMSDispensado();
                }
            }
            Double valorTotalComissao = this.arrredondarNumero(valor * i.getPercComissao() / 100.0, 4);
            Double valorTotalItens = valor;
            h.setValorTotalItens(h.getValorTotalItens() + valorTotalItens);
            h.setValorTotalComissao(h.getValorTotalComissao() + valorTotalComissao);
            h.setPercComissao(this.arrredondarNumero(h.getValorTotalComissao() * 100.0 / h.getValorTotalItens(), 4));
        }
        h.setValorTotalComissao(this.arrredondarNumero(h.getValorTotalItens() * h.getPercComissao() / 100.0, 2));
        comissoes.add(h);
        return comissoes;
    }

    private Double arrredondarNumero(Double value, int casasDec) {
        return ToolFormatter.arrredondarNumero((Double)value, (int)casasDec);
    }
}

