/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.tomadorprestadorrps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperTomadorPrestadorRps
implements AbstractHelper<TomadorPrestadorRps> {
    private TomadorPrestadorRps tomadorPrestadorRps;

    public TomadorPrestadorRps get() {
        return this.tomadorPrestadorRps;
    }

    public HelperTomadorPrestadorRps build(TomadorPrestadorRps tomadorPrestadorRps) {
        this.tomadorPrestadorRps = tomadorPrestadorRps;
        return this;
    }

    public TomadorPrestadorRps criarTomadorPrestadorRps(Pessoa pessoa, Empresa empresa, CategoriaPessoa categoriaPessoa, ClassificacaoClientes classificacaoClientes) {
        TomadorPrestadorRps t = new TomadorPrestadorRps();
        t.setPessoa(pessoa);
        t.setDataCadastro(new Date());
        t.setEmpresa(empresa);
        t.setTipoIss(Short.valueOf((short)2));
        t.setCategoriaPessoa(categoriaPessoa);
        t.setClassificacaoPessoa(classificacaoClientes);
        t.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        t.getUnidadesFat().add(this.criarUnidadeFatPadrao(t));
        return t;
    }

    public UnidadeFatTomPrestRPS criarUnidadeFatPadrao(TomadorPrestadorRps tomadorPrestadorRps) {
        UnidadeFatTomPrestRPS u = new UnidadeFatTomPrestRPS();
        u.setTomadorPrestadorRPS(tomadorPrestadorRps);
        u.setInscricaoEstadual(tomadorPrestadorRps.getPessoa().getComplemento().getInscEst());
        u.setDescricao(tomadorPrestadorRps.getPessoa().getNome());
        u.setEndereco(this.criarEndereco(tomadorPrestadorRps.getPessoa().getEndereco()));
        return u;
    }

    private Endereco criarEndereco(Endereco endereco) {
        Endereco e = new Endereco();
        e.setBairro(endereco.getBairro());
        e.setCep(endereco.getCep());
        e.setCidade(endereco.getCidade());
        e.setComplemento(endereco.getComplemento());
        e.setLogradouro(endereco.getLogradouro());
        e.setNumero(endereco.getNumero());
        e.setObservacao(endereco.getObservacao());
        e.setReferencia(endereco.getReferencia());
        return e;
    }
}

