/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.transferenciacentroestoque;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperItemTransferenciaCentroEstoque
implements AbstractHelper<ItemTransfCentroEstoque> {
    private ItemTransfCentroEstoque itemTransfCentroEstoque;
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;

    public ItemTransfCentroEstoque get() {
        return this.itemTransfCentroEstoque;
    }

    public HelperItemTransferenciaCentroEstoque build(ItemTransfCentroEstoque itemTransfCentroEstoque) {
        this.itemTransfCentroEstoque = itemTransfCentroEstoque;
        return this;
    }

    public List<GradeItemTransfCentroEstoque> findGradesItemTransferenciaCentroEstoqueProduto(Produto p, Empresa emp) {
        ArrayList<GradeItemTransfCentroEstoque> res = new ArrayList<GradeItemTransfCentroEstoque>();
        List<GradeCor> listGrades = this.serviceGradeCor.getByIdProduto(p.getIdentificador());
        for (GradeCor g : listGrades) {
            GradeItemTransfCentroEstoque gI = new GradeItemTransfCentroEstoque(g);
            if (ToolMethods.isEquals((Object)g.getProdutoGrade().getProduto().getLoteUnico(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                gI.setLoteFabricacao(this.serviceLoteFabricacao.findLoteUnico(g.getProdutoGrade().getProduto()));
            } else {
                gI.setLoteFabricacao(this.serviceSaldoEstoque.findMelhorLoteFabricacao(null, g, emp, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO));
            }
            if (ToolMethods.isNull((Object)gI.getLoteFabricacao()).booleanValue()) {
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.818.001", new Object[]{p, emp}));
            }
            res.add(gI);
        }
        return res;
    }
}

