/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.transferenciacentroestoque;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.GrupoUsuarioCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import com.touchcomp.basementorexceptions.exceptions.impl.permissao.EnumExcepPermissao;
import com.touchcomp.basementorexceptions.exceptions.impl.permissao.ExceptionNaoPermitido;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperTransferenciaCentroEstoque
implements AbstractHelper<TransferenciaCentroEstoque> {
    private TransferenciaCentroEstoque transferencia;
    @Autowired
    private HelperOpcoesEstoque helperOpcoesEstoque;

    public HelperTransferenciaCentroEstoque build(TransferenciaCentroEstoque object) {
        this.transferencia = object;
        return this;
    }

    public TransferenciaCentroEstoque get() {
        return this.transferencia;
    }

    public void normalizarDadosAntesSalvar() {
        for (ItemTransfCentroEstoque item : this.transferencia.getItemTransfCentroEstoque()) {
            item.setTransfCentroEstoque(this.transferencia);
            double qtd = 0.0;
            for (GradeItemTransfCentroEstoque gi : item.getGradeItemTransCentroEst()) {
                gi.setItemTransfCentroEst(item);
                qtd += gi.getQuantidade().doubleValue();
            }
            item.setQuantidadeTotal(Double.valueOf(qtd));
        }
    }

    public boolean limparItensZerados() {
        for (ItemTransfCentroEstoque transf : this.transferencia.getItemTransfCentroEstoque()) {
            transf.getGradeItemTransCentroEst().removeIf(i -> i.getQuantidade() <= 0.0);
        }
        this.transferencia.getItemTransfCentroEstoque().removeIf(i -> i.getGradeItemTransCentroEst().isEmpty());
        return this.transferencia.getItemTransfCentroEstoque().size() > 0;
    }

    public Boolean verificaPermissaoUsuario(OpcoesEstoque opcoesEstoque, Usuario usuario) throws ExceptionNaoPermitido {
        Boolean allowed;
        if (!ToolMethods.isAffirmative((Number)((Number)CompOpcoes.getOption(this.helperOpcoesEstoque.build(opcoesEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.VALIDAR_PERMISSAO_USUARIO_CENTRO_ESTOQUE_TRANSF, Short.class)))) {
            return true;
        }
        if (this.transferencia.getOrigem() != null && !(allowed = this.verificaPermissaoUsuario(this.transferencia.getOrigem(), usuario)).booleanValue()) {
            throw new ExceptionNaoPermitido(EnumExcepPermissao.NAO_PERMITIDO_TRANSFERENCIA_CENTRO_ESTOQUES, new Object[]{this.transferencia.getOrigem().toString()});
        }
        if (this.transferencia.getDestino() != null && !(allowed = this.verificaPermissaoUsuario(this.transferencia.getDestino(), usuario)).booleanValue()) {
            throw new ExceptionNaoPermitido(EnumExcepPermissao.NAO_PERMITIDO_TRANSFERENCIA_CENTRO_ESTOQUES, new Object[]{this.transferencia.getDestino().toString()});
        }
        if (this.transferencia.getItemTransfCentroEstoque() != null) {
            for (ItemTransfCentroEstoque i : this.transferencia.getItemTransfCentroEstoque()) {
                allowed = this.verificaPermissaoUsuario(i.getOrigem(), usuario);
                if (!allowed.booleanValue()) {
                    throw new ExceptionNaoPermitido(EnumExcepPermissao.NAO_PERMITIDO_TRANSFERENCIA_CENTRO_ESTOQUES, new Object[]{i.getOrigem().toString()});
                }
                allowed = this.verificaPermissaoUsuario(i.getDestino(), usuario);
                if (allowed.booleanValue()) continue;
                throw new ExceptionNaoPermitido(EnumExcepPermissao.NAO_PERMITIDO_TRANSFERENCIA_CENTRO_ESTOQUES, new Object[]{i.getDestino().toString()});
            }
        }
        return true;
    }

    private Boolean verificaPermissaoUsuario(CentroEstoque centroEstoque, Usuario usuario) {
        if (centroEstoque != null && centroEstoque.getUsuarios() != null) {
            for (GrupoUsuarioCentroEstoque user : centroEstoque.getUsuarios()) {
                for (UsuarioEmpresa ue : usuario.getUsuarioBasico().getEmpresas()) {
                    if (!ToolMethods.isEquals((Object)user.getGrupo(), (Object)ue.getGrupo())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

