/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.usuario;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.SituacaoPedidosGrupo;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperUsuario {
    public Grupo getGrupo(UsuarioBasico user, Empresa emp) {
        if (user == null) {
            return null;
        }
        if (emp == null) {
            return null;
        }
        Optional<UsuarioEmpresa> found = user.getEmpresas().stream().filter(i -> i.getEmpresa().equals((Object)emp)).findFirst();
        return found.isPresent() ? found.get().getGrupo() : null;
    }

    public boolean existeGrupo(UsuarioBasico user, Grupo grupo, Empresa empresa) {
        if (user == null) {
            return false;
        }
        if (grupo == null) {
            return false;
        }
        Optional<UsuarioEmpresa> found = user.getEmpresas().stream().filter(i -> i.getGrupo().equals((Object)grupo) && i.getEmpresa().equals((Object)empresa)).findFirst();
        return found.isPresent();
    }

    public boolean existeAoMenosUmGrupo(UsuarioBasico user, List<Grupo> grupo, Empresa empresa) {
        if (user == null) {
            return false;
        }
        if (grupo == null) {
            return false;
        }
        for (Grupo gr : grupo) {
            if (!this.existeGrupo(user, gr, empresa)) continue;
            return true;
        }
        return false;
    }

    public boolean existeAoMenosUmGrupo(UsuarioBasico user, Empresa empresa, List<SituacaoPedidosGrupo> grupo) {
        if (user == null) {
            return false;
        }
        if (grupo == null) {
            return false;
        }
        for (SituacaoPedidosGrupo gr : grupo) {
            if (!this.existeGrupo(user, gr.getGrupo(), empresa)) continue;
            return true;
        }
        return false;
    }
}

