/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.usuariobasico;

import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementortools.tools.criptografia.ToolCriptografia;
import com.touchcomp.basementortools.tools.md5.ToolMD5;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperUsuarioBasico
implements AbstractHelper<UsuarioBasico> {
    private UsuarioBasico usuarioBasico;
    @Autowired
    private HelperPessoa helperPessoa;

    public HelperUsuarioBasico build(UsuarioBasico object) {
        this.usuarioBasico = object;
        this.helperPessoa.build(this.usuarioBasico.getPessoa());
        return this;
    }

    public UsuarioBasico get() {
        return this.usuarioBasico;
    }

    public String encryptPass() {
        return HelperUsuarioBasico.encrypt(this.usuarioBasico.getLogin().getSenha());
    }

    public String encryptPass(String pass) {
        return HelperUsuarioBasico.encrypt(pass);
    }

    public static boolean validadePassword(String plainPassword, String passwordDB) throws NoSuchAlgorithmException {
        if (plainPassword == null || passwordDB == null) {
            return false;
        }
        if (Objects.equals(passwordDB, plainPassword)) {
            return true;
        }
        if (ToolCriptografia.checkBcrypt((String)plainPassword, (String)passwordDB)) {
            return true;
        }
        String passwordMd5 = ToolMD5.md5((String)plainPassword);
        return Objects.equals(passwordDB, passwordMd5);
    }

    public static String encrypt(String string) {
        return ToolCriptografia.hashBcrypt((String)string);
    }
}

