/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.wmscadastroendereco;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.WmsCadastroEndereco;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.cadastroenderecowms.web.DTOWmsCadastroEndereco;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.MaskFormatter;
import org.springframework.stereotype.Component;

@Component
public class HelperWmsCadastroEndereco
implements AbstractHelper<WmsCadastroEndereco> {
    private WmsCadastroEndereco wmsCadastroEndereco;
    private final String CARACTER_SEPARADOR = ".";

    public HelperWmsCadastroEndereco build(WmsCadastroEndereco object) {
        this.wmsCadastroEndereco = object;
        return this;
    }

    public WmsCadastroEndereco get() {
        return this.wmsCadastroEndereco;
    }

    public short getNrNiveis(String mask) {
        Long nrNiveis = mask.chars().filter(ch -> ch == 46).count() + 1L;
        return nrNiveis.shortValue();
    }

    public DTOWmsCadastroEndereco.DTOWmsEndereco proximoFilho(DTOWmsCadastroEndereco.DTOWmsEndereco pai, String mask) throws ExceptionInvalidData {
        try {
            String codigoAnterior;
            if (!TMethods.isStrWithData((String)mask)) {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("Mascara nao informada em WMS Opcoes."));
            }
            short nivel = 0;
            if (pai != null) {
                nivel = pai.getNivel();
                codigoAnterior = pai.getCodigo();
                Optional found = pai.getChildren().stream().max((n1, n2) -> {
                    Long aux1 = Long.valueOf(n1.getCodigo());
                    Long aux2 = Long.valueOf(n2.getCodigo());
                    return aux1.compareTo(aux2);
                });
                if (found.isPresent()) {
                    codigoAnterior = ((DTOWmsCadastroEndereco.DTOWmsEndereco)found.get()).getCodigo();
                }
                codigoAnterior = this.getCodigoComMascara(mask, codigoAnterior);
            } else {
                codigoAnterior = mask;
                codigoAnterior = codigoAnterior.replaceAll("A", "0");
            }
            long nivelFilho = nivel + 1;
            long nrNiveis = this.getNrNiveis(mask);
            if (nivelFilho > nrNiveis) {
                throw new ExceptionInvalidData("E.ERP.1899.001", new Object[]{mask});
            }
            Object begin = "";
            String end = "";
            int subStringPoint = -1;
            String temp = codigoAnterior;
            int i = 0;
            while ((long)i < nivelFilho) {
                subStringPoint = temp.indexOf(".");
                if (subStringPoint >= 0) {
                    begin = (String)begin + String.valueOf(temp.subSequence(0, subStringPoint));
                    temp = temp.substring(++subStringPoint);
                } else {
                    begin = (String)begin + temp;
                    temp = "";
                }
                ++i;
            }
            if (subStringPoint >= 0) {
                end = temp.replaceAll("\\.", "");
            }
            Long novoCodigoL = Long.parseLong((String)begin) + 1L;
            Object novoCodigo = ToolString.completaZeros((String)novoCodigoL.toString(), (int)((String)begin).length(), (boolean)true);
            novoCodigo = (String)novoCodigo + end;
            DTOWmsCadastroEndereco.DTOWmsEndereco filho = new DTOWmsCadastroEndereco.DTOWmsEndereco();
            filho.setCodigo((String)novoCodigo);
            filho.setCodigoMascara(this.getCodigoComMascara(mask, (String)novoCodigo));
            filho.setNivel(Short.valueOf((short)nivelFilho));
            filho.setIndisponivel(Integer.valueOf(0));
            if (pai != null) {
                filho.setWmsCadastroEnderecoIdentificador(pai.getWmsCadastroEnderecoIdentificador());
                filho.setEnderecoPaiIdentificador(pai.getIdentificador());
                pai.getChildren().add(filho);
            }
            this.defineSinteticoAnalitico(filho, nrNiveis);
            return filho;
        }
        catch (ParseException ex) {
            Logger.getLogger(HelperWmsCadastroEndereco.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionInvalidData("E.ERP.1899.002", new Object[]{mask});
        }
    }

    public String getCodigoComMascara(String mask, String codigo) throws ParseException {
        codigo = TString.onlyNumbers((String)codigo);
        MaskFormatter mf = new MaskFormatter(mask);
        mf.setValueContainsLiteralCharacters(false);
        return mf.valueToString(codigo);
    }

    public String getCodigoNivelSuperior(String mask, String codigoFilho) throws ParseException {
        int nivel = this.getNivel(mask, codigoFilho);
        codigoFilho = ToolString.onlyNumbers((String)codigoFilho);
        if (nivel <= 1) {
            return null;
        }
        --nivel;
        StringTokenizer sk = new StringTokenizer(mask, ".");
        int aux = 1;
        Object temp = "";
        while (sk.hasMoreTokens()) {
            String element = sk.nextToken();
            temp = (String)temp + element;
            if (aux == nivel) break;
            aux = (short)(aux + 1);
        }
        int size = codigoFilho.length();
        codigoFilho = codigoFilho.substring(0, ((String)temp).length());
        codigoFilho = ToolString.completaZeros((String)codigoFilho, (int)size);
        codigoFilho = this.getCodigoComMascara(mask, codigoFilho);
        return codigoFilho;
    }

    public short getNivel(String mask, String codigoFilho) throws ParseException {
        String element;
        codigoFilho = ToolString.onlyNumbers((String)codigoFilho);
        codigoFilho = this.getCodigoComMascara(mask, codigoFilho);
        StringTokenizer sk = new StringTokenizer(codigoFilho, ".");
        short nivel = 0;
        while (sk.hasMoreTokens() && Long.parseLong(element = sk.nextToken()) != 0L) {
            nivel = (short)(nivel + 1);
        }
        return nivel;
    }

    public void defineSinteticoAnalitico(WmsEndereco enderecoPrincipal, long nrNiveis) {
        if (ToolMethods.isEqualsNumber((Number)nrNiveis, (Number)enderecoPrincipal.getNivel())) {
            enderecoPrincipal.setSinteticoAnalitico(Short.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValue()));
        } else {
            enderecoPrincipal.setSinteticoAnalitico(Short.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValue()));
        }
    }

    public void defineSinteticoAnalitico(DTOWmsCadastroEndereco.DTOWmsEndereco enderecoPrincipal, long nrNiveis) {
        if (ToolMethods.isEqualsNumber((Number)nrNiveis, (Number)enderecoPrincipal.getNivel())) {
            enderecoPrincipal.setSinteticoAnalitico(Short.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValue()));
        } else {
            enderecoPrincipal.setSinteticoAnalitico(Short.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValue()));
        }
    }

    public WmsCadastroEndereco getCadastroEnderecoDefault(Empresa loggedEmpresa, WmsOpcoes wmsOpcoes) throws ExceptionInvalidData {
        WmsCadastroEndereco entity = new WmsCadastroEndereco();
        entity.setIdentificador(Long.valueOf(0L));
        entity.setDataCadastro(new Date());
        entity.setEmpresa(loggedEmpresa);
        entity.setEnderecoPrincipal(new WmsEndereco());
        entity.getEnderecoPrincipal().setDescricao("Armazem");
        entity.getEnderecoPrincipal().setIdentificador(Long.valueOf(0L));
        DTOWmsCadastroEndereco.DTOWmsEndereco filho = this.proximoFilho(null, wmsOpcoes.getMascara());
        entity.getEnderecoPrincipal().setCodigo(filho.getCodigo());
        entity.getEnderecoPrincipal().setCodigoMascara(filho.getCodigoMascara());
        entity.getEnderecoPrincipal().setNivel(filho.getNivel());
        entity.getEnderecoPrincipal().setEmpresa(loggedEmpresa);
        return entity;
    }
}

