/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos;

import com.google.common.util.concurrent.AtomicDouble;
import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoDisp;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoStatEnd;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.GradeItemImpSaldo;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoqueItem;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.impl.RulesWmsEntradaProdutos;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemDiferencas;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.estoquepeps.multi.EstoqueDisponivelMult;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.EstatisticasWmsParams;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.ServiceWmsSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperWmsEntradaProdutos
implements AbstractHelper<WmsEntradaEstoque> {
    private WmsEntradaEstoque wmsEntrada;
    @Autowired
    private HelperWmsOpcoes helperWmsOpcoes;
    @Autowired
    private ServiceWmsEnderecoImpl serviceWmsEndereco;
    @Autowired
    private ServiceWmsSaldoEstoqueImpl serviceWmsSaldoEstoqueImpl;
    @Autowired
    private RulesWmsEntradaProdutos rulesWmsEntrada;

    public HelperWmsEntradaProdutos build(WmsEntradaEstoque object) {
        this.wmsEntrada = object;
        return this;
    }

    public WmsEntradaEstoque get() {
        return this.wmsEntrada;
    }

    public WmsEntradaEstoque getWmsEntrada(ComunicadoProducao com, WmsOpcoes op) throws ExceptionInvalidState {
        if (com == null) {
            return null;
        }
        if (ToolMethods.isNegative((Number)op.getEfetuarEntradaWmsAuto())) {
            return com.getWmsEntradaEstoque();
        }
        List<WmsEstatisticasEndereco> stats = this.getAndBuildSaldoWMSEstatisticas(com.getEmpresa(), op);
        WmsEntradaEstoque wmsEnt = this.getCheckWmsEntrada(com.getWmsEntradaEstoque());
        wmsEnt.setEfetivarEntrada(op.getEfetivarEntradaWmsAuto());
        for (ItemComunicadoProducao item : com.getItemComunicadoProducao()) {
            if (item.getCentroEstoque() == null || item.getCentroEstoque().getWmsCadastroEndereco() == null) continue;
            WmsEntradaEstoqueItem wmsItem = new WmsEntradaEstoqueItem();
            wmsItem.setProduto(item.getProduto());
            wmsItem.setQuantidadeTotal(item.getQuantidadeTotal());
            wmsItem.setWmsEndereco(this.checkWmsEnd(item.getCentroEstoque().getWmsCadastroEndereco().getEnderecoPrincipal()));
            wmsItem.setWmsEntradaEstoque(wmsEnt);
            for (GradeItemComunicadoProducao grade : item.getGradeItemComunicadoProducao()) {
                this.createGrades(grade.getGradeCor(), grade.getLoteFabricacao(), grade.getCentroEstoque(), wmsItem, wmsEnt.getEfetivarEntrada(), grade.getDataMovimentacao(), grade.getEmpresa(), grade.getQuantidade(), stats);
            }
            wmsEnt.getItens().add(wmsItem);
        }
        if (wmsEnt.getItens().isEmpty()) {
            return null;
        }
        wmsEnt.setDataCadastro(new Date());
        wmsEnt.setDescricao("Com. Prod. " + com.toString());
        wmsEnt.setEmpresa(com.getEmpresa());
        wmsEnt.setDataEntrada(com.getDataEntradaSaida());
        wmsEnt.setComunicadoProducao(com);
        wmsEnt.setObservacao(com.getObservacao());
        this.build(wmsEnt).calcularTotais();
        return wmsEnt;
    }

    private WmsEntradaEstoque getCheckWmsEntrada(WmsEntradaEstoque wmsEntradaEstoque) {
        if (wmsEntradaEstoque == null) {
            wmsEntradaEstoque = new WmsEntradaEstoque();
        }
        wmsEntradaEstoque.getItens().clear();
        return wmsEntradaEstoque;
    }

    public WmsEntradaEstoque getWmsEntrada(NotaFiscalTerceiros nf, WmsOpcoes op) throws ExceptionInvalidState {
        if (nf == null) {
            return null;
        }
        Short gerarEntIndMovFisica = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.CRIAR_ENT_WMS_MESMO_SEM_MOV_ESTOQUE, Short.class);
        List<WmsEstatisticasEndereco> stats = this.getAndBuildSaldoWMSEstatisticas(nf.getEmpresa(), op);
        WmsEntradaEstoque wmsEnt = this.getCheckWmsEntrada(nf.getWmsEntradaEstoque());
        wmsEnt.setEfetivarEntrada(op.getEfetivarEntradaWmsAuto());
        for (ItemNotaTerceiros item : nf.getItemNotaTerceiros()) {
            if (item.getCentroEstoque() == null || item.getCentroEstoque().getWmsCadastroEndereco() == null) continue;
            WmsEntradaEstoqueItem wmsItem = new WmsEntradaEstoqueItem();
            wmsItem.setProduto(item.getProduto());
            wmsItem.setQuantidadeTotal(item.getQuantidadeTotal());
            wmsItem.setWmsEndereco(this.checkWmsEnd(item.getCentroEstoque().getWmsCadastroEndereco().getEnderecoPrincipal()));
            wmsItem.setWmsEntradaEstoque(wmsEnt);
            for (GradeItemNotaTerceiros grade : item.getGrade()) {
                if (!ToolMethods.isAffirmative((Number)gerarEntIndMovFisica) && !ToolMethods.isAffirmative((Number)grade.getMovimentacaoFisica())) continue;
                this.createGrades(grade.getGradeCor(), grade.getLoteFabricacao(), grade.getCentroEstoque(), wmsItem, wmsEnt.getEfetivarEntrada(), grade.getDataEntradaSaida(), grade.getEmpresa(), grade.getQuantidade(), stats);
            }
            if (wmsItem.getGrades().isEmpty()) continue;
            wmsEnt.getItens().add(wmsItem);
        }
        if (wmsEnt.getItens().isEmpty()) {
            return null;
        }
        wmsEnt.setDataCadastro(new Date());
        wmsEnt.setNotaFiscalTerceiros(nf);
        wmsEnt.setDescricao("NFT. " + nf.toString());
        wmsEnt.setEmpresa(nf.getEmpresa());
        wmsEnt.setObservacao(nf.getObservacao());
        wmsEnt.setDataEntrada(nf.getDataEntrada());
        this.build(wmsEnt).calcularTotais();
        return wmsEnt;
    }

    public WmsEntradaEstoque getWmsEntrada(NotaFiscalPropria nf, WmsOpcoes op) throws ExceptionInvalidState {
        if (nf == null) {
            return null;
        }
        if (ToolMethods.isNegative((Number)op.getEfetuarEntradaWmsAuto())) {
            return nf.getWmsEntradaEstoque();
        }
        List<WmsEstatisticasEndereco> stats = this.getAndBuildSaldoWMSEstatisticas(nf.getEmpresa(), op);
        WmsEntradaEstoque wmsEnt = this.getCheckWmsEntrada(nf.getWmsEntradaEstoque());
        wmsEnt.setEfetivarEntrada(op.getEfetivarEntradaWmsAuto());
        for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
            if (item.getCentroEstoque() == null || item.getCentroEstoque().getWmsCadastroEndereco() == null) continue;
            WmsEntradaEstoqueItem wmsItem = new WmsEntradaEstoqueItem();
            wmsItem.setProduto(item.getProduto());
            wmsItem.setQuantidadeTotal(item.getQuantidadeTotal());
            wmsItem.setWmsEndereco(this.checkWmsEnd(item.getCentroEstoque().getWmsCadastroEndereco().getEnderecoPrincipal()));
            wmsItem.setWmsEntradaEstoque(wmsEnt);
            for (GradeItemNotaFiscalPropria grade : item.getGradesNotaFiscalPropria()) {
                if (!ToolMethods.isAffirmative((Number)grade.getMovimentacaoFisica()) || !ToolMethods.isEquals((Object)grade.getEntradaSaida(), (Object)2)) continue;
                this.createGrades(grade.getGradeCor(), grade.getLoteFabricacao(), grade.getCentroEstoque(), wmsItem, wmsEnt.getEfetivarEntrada(), grade.getDataEntradaSaida(), grade.getEmpresa(), grade.getQuantidade(), stats);
            }
            if (wmsItem.getGrades().isEmpty()) continue;
            wmsEnt.getItens().add(wmsItem);
        }
        if (wmsEnt.getItens().isEmpty()) {
            return null;
        }
        wmsEnt.setNotaFiscalPropria(nf);
        wmsEnt.setDataCadastro(new Date());
        wmsEnt.setDescricao("NFP. " + nf.toString());
        wmsEnt.setEmpresa(nf.getEmpresa());
        wmsEnt.setObservacao(nf.getObservacao());
        wmsEnt.setDataEntrada(nf.getDataEmissaoNota());
        this.build(wmsEnt).calcularTotais();
        return wmsEnt;
    }

    public WmsEntradaEstoque getWmsEntrada(ImplantacaoSaldos imp, WmsOpcoes op) throws ExceptionInvalidState {
        if (imp == null) {
            return null;
        }
        if (ToolMethods.isNegative((Number)op.getEfetuarEntradaWmsAuto())) {
            return imp.getWmsEntradaEstoque();
        }
        List<WmsEstatisticasEndereco> stats = this.getAndBuildSaldoWMSEstatisticas(imp.getEmpresa(), op);
        WmsEntradaEstoque wmsEnt = this.getCheckWmsEntrada(imp.getWmsEntradaEstoque());
        wmsEnt.setEfetivarEntrada(op.getEfetivarEntradaWmsAuto());
        for (ItemImplantaSaldo item : imp.getItemImplantaSaldo()) {
            if (item.getCentroEstoque() == null || item.getCentroEstoque().getWmsCadastroEndereco() == null) continue;
            WmsEntradaEstoqueItem wmsItem = new WmsEntradaEstoqueItem();
            wmsItem.setProduto(item.getProduto());
            wmsItem.setQuantidadeTotal(item.getQuantidadeTotal());
            wmsItem.setWmsEndereco(this.checkWmsEnd(item.getCentroEstoque().getWmsCadastroEndereco().getEnderecoPrincipal()));
            wmsItem.setWmsEntradaEstoque(wmsEnt);
            for (GradeItemImpSaldo grade : item.getGradeItem()) {
                this.createGrades(grade.getGradeCor(), grade.getLoteFabricacao(), grade.getCentroEstoque(), wmsItem, wmsEnt.getEfetivarEntrada(), imp.getDataEntradaSaida(), imp.getEmpresa(), grade.getQuantidade(), stats);
            }
            wmsEnt.getItens().add(wmsItem);
        }
        if (wmsEnt.getItens().isEmpty()) {
            return null;
        }
        wmsEnt.setImplantacaoSaldos(imp);
        wmsEnt.setDataCadastro(new Date());
        wmsEnt.setDescricao("Implantacao. " + imp.toString());
        wmsEnt.setEmpresa(imp.getEmpresa());
        wmsEnt.setObservacao(imp.getObservacao());
        wmsEnt.setDataEntrada(imp.getDataEntradaSaida());
        this.build(wmsEnt).calcularTotais();
        return wmsEnt;
    }

    public WmsEntradaEstoque getWmsEntrada(TransferenciaCentroEstoque transf, WmsOpcoes op) throws ExceptionInvalidState {
        if (transf == null) {
            return null;
        }
        if (ToolMethods.isNegative((Number)op.getEfetuarEntradaWmsAuto())) {
            return transf.getWmsEntradaEstoque();
        }
        List<WmsEstatisticasEndereco> stats = this.getAndBuildSaldoWMSEstatisticas(transf.getEmpresa(), op);
        WmsEntradaEstoque wmsEnt = this.getCheckWmsEntrada(transf.getWmsEntradaEstoque());
        wmsEnt.setEfetivarEntrada(op.getEfetivarEntradaWmsAuto());
        LinkedList<ResumoGrades> resumo = new LinkedList<ResumoGrades>();
        for (ItemTransfCentroEstoque item : transf.getItemTransfCentroEstoque()) {
            if (item.getDestino() == null || item.getDestino().getWmsCadastroEndereco() == null) continue;
            for (GradeItemTransfCentroEstoque grade : item.getGradeItemTransCentroEst()) {
                GradeCor gradeCor = grade.getGradeCor();
                LoteFabricacao lote = grade.getLoteFabricacao();
                CentroEstoque centro = grade.getDestino();
                Double qtd = grade.getQuantidade();
                Optional<ResumoGrades> foundRes = resumo.stream().filter(i -> ToolMethods.isEquals((Object)i.grade, (Object)gradeCor) && ToolMethods.isEquals((Object)i.loteFab, (Object)lote) && ToolMethods.isEquals((Object)i.destino, (Object)centro)).findFirst();
                if (foundRes.isPresent()) {
                    foundRes.get().quantidade.addAndGet(qtd.doubleValue());
                    continue;
                }
                resumo.add(new ResumoGrades(gradeCor, lote, centro, new AtomicDouble(qtd.doubleValue())));
            }
        }
        for (ResumoGrades resumoGrades : resumo) {
            WmsEntradaEstoqueItem wmsItem = new WmsEntradaEstoqueItem();
            wmsItem.setProduto(resumoGrades.grade().getProdutoGrade().getProduto());
            wmsItem.setWmsEntradaEstoque(this.wmsEntrada);
            this.createGrades(resumoGrades.grade(), resumoGrades.loteFab(), resumoGrades.destino(), wmsItem, wmsEnt.getEfetivarEntrada(), transf.getDataTransferencia(), transf.getEmpresa(), resumoGrades.quantidade().doubleValue(), stats);
            wmsEnt.getItens().add(wmsItem);
        }
        if (wmsEnt.getItens().isEmpty()) {
            return null;
        }
        wmsEnt.setTransferenciaEstEntrada(transf);
        wmsEnt.setDataCadastro(new Date());
        wmsEnt.setDescricao("Transferencia Centro Estoque " + transf.toString());
        wmsEnt.setEmpresa(transf.getEmpresa());
        wmsEnt.setObservacao(transf.getObservacao());
        wmsEnt.setDataEntrada(transf.getDataTransferencia());
        this.build(wmsEnt).calcularTotais();
        return wmsEnt;
    }

    public void calcularTotais() {
        double qtdTotal = 0.0;
        double pesoTotal = 0.0;
        double volTotal = 0.0;
        for (WmsEntradaEstoqueItem i : this.wmsEntrada.getItens()) {
            double qtdTotalItem = 0.0;
            double pesoTotalItem = 0.0;
            double volTotalItem = 0.0;
            for (WmsEntradaEstoqueGrade grade : i.getGrades()) {
                grade.setWmsEntradaEstoqueItem(i);
                grade.setDataEntrada(this.wmsEntrada.getDataEntrada());
                grade.setEmpresa(this.wmsEntrada.getEmpresa());
                if (i.getProduto() != null) {
                    grade.setPesoTotal(Double.valueOf(i.getProduto().getPesoUnitario() * grade.getQuantidade()));
                    grade.setVolumeTotal(Double.valueOf(i.getProduto().getVolume() * grade.getQuantidade()));
                }
                qtdTotalItem += grade.getQuantidade().doubleValue();
                pesoTotalItem += grade.getPesoTotal().doubleValue();
                volTotalItem += grade.getVolumeTotal().doubleValue();
            }
            i.setQuantidadeTotal(Double.valueOf(qtdTotalItem));
            i.setPesoTotal(Double.valueOf(pesoTotalItem));
            i.setVolumeTotal(Double.valueOf(volTotalItem));
            i.setWmsEntradaEstoque(this.wmsEntrada);
            qtdTotal += qtdTotalItem;
            pesoTotal += pesoTotalItem;
            volTotal += volTotalItem;
        }
        this.wmsEntrada.setPesoTotal(Double.valueOf(pesoTotal));
        this.wmsEntrada.setVolumeTotal(Double.valueOf(volTotal));
        this.wmsEntrada.setQuantidadeTotal(Double.valueOf(qtdTotal));
    }

    private void createGrades(GradeCor grade, LoteFabricacao loteFabricacao, CentroEstoque centroEstoque, WmsEntradaEstoqueItem item, Short efetivarEntrada, Date dataEntrada, Empresa emp, Double quantidade, List<WmsEstatisticasEndereco> stats) throws ExceptionInvalidState {
        List<EstoqueDisponivelMult<WmsEstatisticasEndereco>> endereco = this.serviceWmsSaldoEstoqueImpl.getSugestaoEndereco(stats, emp, grade, quantidade);
        for (EstoqueDisponivelMult<WmsEstatisticasEndereco> stat : endereco) {
            WmsEntradaEstoqueGrade wg = new WmsEntradaEstoqueGrade();
            wg.setEfetivarEntrada(efetivarEntrada);
            wg.setDataEntrada(dataEntrada);
            wg.setEmpresa(emp);
            wg.setGradeCor(grade);
            wg.setLoteFabricacao(loteFabricacao);
            wg.setQuantidade(stat.getQuantidade());
            if (stat.getEstoque().getSource() != null) {
                wg.setWmsEndereco((WmsEndereco)this.serviceWmsEndereco.get(((WmsEstatisticasEndereco)stat.getEstoque().getSource()).getIdWmsEndereco()));
            }
            wg.setWmsEntradaEstoqueItem(item);
            item.getGrades().add(wg);
        }
        this.definirCentroReferencia(item);
    }

    public List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> getResumoItensDiferenca() {
        return this.rulesWmsEntrada.getResumoItensDiferenca(this.wmsEntrada, true);
    }

    private WmsEndereco checkWmsEnd(WmsEndereco wmsEnd) {
        if (TMethods.isEquals((Object)wmsEnd.getSinteticoAnalitico(), (Object)EnumConstSinteticoAnalitico.ANALITICO.getValue())) {
            return wmsEnd;
        }
        return null;
    }

    private void definirCentroReferencia(WmsEntradaEstoqueItem wmsItem) {
        WmsEndereco wEnd = null;
        boolean isallequal = true;
        for (WmsEntradaEstoqueGrade grade : wmsItem.getGrades()) {
            if (wEnd == null) {
                wEnd = grade.getWmsEndereco();
            }
            if (ToolMethods.isEquals((Object)wEnd, (Object)grade.getWmsEndereco())) continue;
            isallequal = false;
        }
        if (isallequal) {
            wmsItem.setWmsEndereco(wEnd);
        }
    }

    private List<WmsEstatisticasEndereco> getAndBuildSaldoWMSEstatisticas(Empresa empresa, WmsOpcoes opcoes) {
        EstatisticasWmsParams params = new EstatisticasWmsParams();
        params.setCarregarCaractVincEndereco(Boolean.TRUE);
        params.setDataSaldo(new Date());
        params.setEmpresa(empresa.getIdentificador());
        params.setTipoStat(EnumConstSaldoWMSTipoStatEnd.AMBOS);
        params.setTipodisp(EnumConstSaldoWMSTipoDisp.DISPONIVEL);
        List<WmsEstatisticasEndereco> stats = this.serviceWmsSaldoEstoqueImpl.findSaldoWMSEstatisticas(params);
        Short sugEndVazios = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(opcoes).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.SUGERIR_END_VAZIOS, Short.class);
        if (ToolMethods.isAffirmative((Number)sugEndVazios)) {
            stats.removeIf(i -> ToolMethods.isWithData((Number)i.getPesoUtilizado()) || ToolMethods.isWithData((Number)i.getVolumeUtilizado()));
        }
        return stats;
    }

    public WmsEntradaEstoque gerarTransfWmsEntrada(WmsEntradaEstoque wmsEntrada, CentroEstoque origem) {
        if (wmsEntrada == null) {
            return null;
        }
        TransferenciaCentroEstoque transf = new TransferenciaCentroEstoque();
        transf.setDataCadastro(wmsEntrada.getDataCadastro());
        transf.setDataTransferencia(wmsEntrada.getDataEntrada());
        transf.setEmpresa(wmsEntrada.getEmpresa());
        for (WmsEntradaEstoqueItem item : wmsEntrada.getItens()) {
            ItemTransfCentroEstoque it = new ItemTransfCentroEstoque();
            it.setTransfCentroEstoque(transf);
            it.setProduto(item.getProduto());
            it.setQuantidadeTotal(item.getQuantidadeTotal());
            transf.getItemTransfCentroEstoque().add(it);
            for (WmsEntradaEstoqueGrade grade : item.getGrades()) {
                GradeItemTransfCentroEstoque gr = new GradeItemTransfCentroEstoque();
                gr.setDataTransferencia(transf.getDataTransferencia());
                gr.setEmpresa(transf.getEmpresa());
                gr.setGradeCor(grade.getGradeCor());
                gr.setItemTransfCentroEst(it);
                gr.setLoteFabricacao(grade.getLoteFabricacao());
                gr.setOrigem(origem);
                gr.setQuantidade(grade.getQuantidade());
                gr.setDestino(grade.getWmsEndereco().getCentroEstoque());
                it.getGradeItemTransCentroEst().add(gr);
                it.setDestino(gr.getDestino());
                it.setOrigem(gr.getOrigem());
            }
        }
        wmsEntrada.setTransferenciaEstEntrada(transf);
        return wmsEntrada;
    }

    public record ResumoGrades(GradeCor grade, LoteFabricacao loteFab, CentroEstoque destino, AtomicDouble quantidade) {
    }
}

