/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.wmspedido;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.constants.enums.saldoestoquewms.EnumConstSaldoWMSTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDisp;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItemReserva;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSep;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSepItem;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.ServiceWmsSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperWmsPedido
implements AbstractHelper<WmsPedido> {
    private WmsPedido wmsPedido;
    @Autowired
    ServiceWmsSaldoEstoqueImpl serviceWmsSaldo;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLote;
    @Autowired
    CompTotaisItemGradesAdp compTotalizadoresItem;
    @Autowired
    ServiceWmsEnderecoImpl serviceWmsEnd;
    @Autowired
    CompEstoqueDisponibilidade compEstoqueDisponibilidade;

    public HelperWmsPedido build(WmsPedido object) {
        this.wmsPedido = object;
        return this;
    }

    public WmsPedido get() {
        return this.wmsPedido;
    }

    public WmsPedidoMapaSep getMapaSeparacao(WmsPedido ped) throws ExceptionInvalidState {
        List grades = this.compTotalizadoresItem.getTotaisGrades(ped);
        WmsPedidoMapaSep sep = new WmsPedidoMapaSep();
        sep.setEmpresa(ped.getEmpresa());
        for (TotalItemGrade t : grades) {
            List<EstoqueDisponivel<WmsSaldoEstoque>> est = this.serviceWmsSaldo.getSaldosEstoque(ped.getEmpresa(), t.getGradeCor(), TDate.dataSemHora((Date)new Date()), t.getQuantidadeTotal(), CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.ESTOQUE_SEM_DADOS, EnumConstSaldoWMSTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0);
            est.forEach(i -> {
                LoteFabricacao lt = null;
                if (i.getEstoque().getSource() != null) {
                    lt = (LoteFabricacao)this.serviceLote.get(((WmsSaldoEstoque)i.getEstoque().getSource()).getIdLoteFabricacao());
                }
                WmsEndereco end = null;
                if (i.getEstoque().getSource() != null) {
                    end = (WmsEndereco)this.serviceWmsEnd.get(((WmsSaldoEstoque)i.getEstoque().getSource()).getIdWmsEndereco());
                }
                WmsPedidoMapaSepItem d = new WmsPedidoMapaSepItem();
                d.setGradeCor(t.getGradeCor());
                d.setLoteFabricacao(lt);
                d.setWmsEndereco(end);
                if (end != null) {
                    d.setDistancia(end.getDistancia());
                }
                d.setQuantidade(i.getQuantidade());
                d.setWmsPedidoMapaSep(sep);
                sep.getItensMapa().add(d);
            });
        }
        return sep;
    }

    public void reservarPedido(WmsPedido ped, WmsOpcoes wmsOpcoes) throws ExceptionInvalidState {
        ped.getItensReserva().clear();
        if (!TMethods.isAffirmative((Number)wmsOpcoes.getReservarEstoqueWmsPed()) && !TMethods.isAffirmative((Number)ped.getReservarEstoque())) {
            return;
        }
        if (ped.getWmsSeparacaoPedido() != null && ped.getWmsSeparacaoPedido().getWmsSaidaEstoque() != null) {
            return;
        }
        if (TMethods.isAffirmative((Number)wmsOpcoes.getReservarEstoqueWmsPed())) {
            ped.setReservarEstoque(Short.valueOf((short)1));
        }
        List grades = this.compTotalizadoresItem.getTotaisGrades(ped);
        Date dataConsulta = TDate.dataSemHora((Date)new Date());
        for (TotalItemGrade gr : grades) {
            List<EstoqueDisponivel<WmsSaldoEstoque>> est = this.serviceWmsSaldo.getSaldosEstoque(ped.getEmpresa(), gr.getGradeCor(), dataConsulta, gr.getQuantidadeTotal(), CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LISTA_EST_VAZIA);
            if (est.isEmpty()) {
                throw new ExceptionInvalidState("E.ERP.1915.002", new Object[]{gr.getGradeCor(), dataConsulta});
            }
            for (EstoqueDisponivel<WmsSaldoEstoque> estD : est) {
                LoteFabricacao lt = (LoteFabricacao)this.serviceLote.get(((WmsSaldoEstoque)estD.getEstoque().getSource()).getIdLoteFabricacao());
                WmsEndereco end = (WmsEndereco)this.serviceWmsEnd.get(((WmsSaldoEstoque)estD.getEstoque().getSource()).getIdWmsEndereco());
                WmsPedidoItemReserva w = new WmsPedidoItemReserva();
                w.setGradeCor(gr.getGradeCor());
                w.setLoteFabricacao(lt);
                w.setWmsPedido(this.wmsPedido);
                w.setDataReserva(dataConsulta);
                w.setEmpresa(ped.getEmpresa());
                w.setWmsEndereco(end);
                w.setQuantidade(estD.getQuantidade());
                ped.getItensReserva().add(w);
            }
        }
    }

    public void calcularTotais() {
        this.compTotalizadoresItem.calcularTotalizadores(this.get());
    }

    public List<EstoqueDisponivel> getSaldosEstoque(WmsPedido ped, Empresa emp, GradeCor gradeCor, Date dataConsulta, Double quantidadeTotal, CompEstoqueDisponibilidade.OpcaoSaldoParcial opcaoSaldoParcial, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo opcaoTotalmenteSemSaldo) throws ExceptionInvalidState {
        if (TMethods.isAffirmative((Number)ped.getReservarEstoque())) {
            LinkedList<TempItemReserva> r = new LinkedList<TempItemReserva>();
            for (WmsPedidoItemReserva it : ped.getItensReserva()) {
                r.add(new TempItemReserva(it));
            }
            return this.compEstoqueDisponibilidade.getDisponibilidades(r, quantidadeTotal, gradeCor, EnumConstOpEstoqueEstrategia.MENOS_VARIACOES, opcaoSaldoParcial, opcaoTotalmenteSemSaldo);
        }
        List<EstoqueDisponivel> r = this.serviceWmsSaldo.getSaldosEstoque(emp, gradeCor, dataConsulta, quantidadeTotal, opcaoSaldoParcial, opcaoTotalmenteSemSaldo);
        return r;
    }

    public static class TempItemReserva
    implements InterfaceEstoqueDisp {
        private WmsPedidoItemReserva item;

        public TempItemReserva(WmsPedidoItemReserva item) {
            this.item = item;
        }

        public Object getSource() {
            return this.item;
        }

        public Double getQuantidadeAvaliacao() {
            return this.item.getQuantidade();
        }

        public Date getDataAvaliacao() {
            return this.item.getDataReserva();
        }

        public void setQuantidadeAvaliacao(Double aValue) {
            this.item.setQuantidade(aValue);
        }
    }
}

