/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.wmssaidaprodutos;

import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedidoItemReserva;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueItem;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementorservice.components.transferenciacentroestoque.CompTransfCentroEstoque;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.helpers.impl.wmspedido.HelperWmsPedido;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoImpl;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.ServiceWmsSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperWmsSaidaProdutos
implements AbstractHelper<WmsSaidaEstoque> {
    private WmsSaidaEstoque wmsSaidaEstoque;
    @Autowired
    ServiceWmsSaldoEstoqueImpl serviceWmsSaldoEstoque;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    @Autowired
    ServiceWmsEnderecoImpl serviceWmsEnderecoImpl;
    @Autowired
    HelperWmsPedido helperWmsPedido;
    @Autowired
    HelperWmsOpcoes helperWmsOpcoes;
    @Autowired
    CompTransfCentroEstoque compTransfCentroEstoque;

    public HelperWmsSaidaProdutos build(WmsSaidaEstoque object) {
        this.wmsSaidaEstoque = object;
        return this;
    }

    public WmsSaidaEstoque get() {
        return this.wmsSaidaEstoque;
    }

    public void buildSaidaProdutos(WmsSeparacaoPedido separacaoWms, WmsOpcoes wmsOpcoes) throws ExceptionInvalidState {
        Short gerarSaidaSemConfReal = (Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(wmsOpcoes).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.GERAR_SAIDA_WMS_SEM_CONFIRMACAO, Short.class);
        if (!ToolMethods.isAffirmative((Number)gerarSaidaSemConfReal)) {
            if (!ToolMethods.isAffirmative((Number)separacaoWms.getConferenciaFinalizada())) {
                return;
            }
            if (separacaoWms.getDataSaida() == null) {
                return;
            }
        }
        if (separacaoWms.getDataSaida() == null) {
            separacaoWms.setDataSaida(new Date());
        }
        HashMap<String, List<EstoqueDisponivel>> saldosCache = new HashMap<String, List<EstoqueDisponivel>>();
        WmsSaidaEstoque saida = separacaoWms.getWmsSaidaEstoque();
        if (saida == null) {
            saida = new WmsSaidaEstoque();
        }
        saida.setDataCadastro(new Date());
        saida.setDataSaida(separacaoWms.getDataSaida());
        saida.setDescricao("Sep.Pedido: " + separacaoWms.toString());
        saida.setEmpresa(separacaoWms.getEmpresa());
        saida.getItens().forEach(item -> {
            item.setQuantidadeTotal(Double.valueOf(0.0));
            item.getGrades().forEach(i -> i.setQuantidade(Double.valueOf(0.0)));
        });
        this.createItens(saida, separacaoWms, wmsOpcoes);
        this.createSetLotesEstoque(saida, separacaoWms, wmsOpcoes, saldosCache);
        this.build(saida).calculaTotalizadores();
        saida.getItens().removeIf(i -> !ToolMethods.isWithData((Number)i.getQuantidadeTotal()));
        separacaoWms.setWmsSaidaEstoque(saida);
        if (ToolMethods.isAffirmative((Number)separacaoWms.getConferenciaFinalizada())) {
            this.compTransfCentroEstoque.gerarTransferencia(this.wmsSaidaEstoque, wmsOpcoes);
        }
        this.wmsSaidaEstoque.setWmsSeparacaoPedido(separacaoWms);
    }

    public void calculaTotalizadores() {
        double qtdTotal = 0.0;
        double volumeTotal = 0.0;
        double pesoTotal = 0.0;
        for (WmsSaidaEstoqueItem i : this.wmsSaidaEstoque.getItens()) {
            double qtdTotalItem = 0.0;
            double volumeTotalItem = 0.0;
            double pesoTotalItem = 0.0;
            for (WmsSaidaEstoqueGrade grade : i.getGrades()) {
                grade.setWmsSaidaEstoqueItem(i);
                grade.setPesoTotal(Double.valueOf(i.getProduto().getPesoUnitario() * grade.getQuantidade()));
                grade.setVolumeTotal(Double.valueOf(i.getProduto().getVolume() * grade.getQuantidade()));
                qtdTotalItem += grade.getQuantidade().doubleValue();
                volumeTotalItem += grade.getVolumeTotal().doubleValue();
                pesoTotalItem += grade.getPesoTotal().doubleValue();
            }
            i.setQuantidadeTotal(Double.valueOf(qtdTotalItem));
            i.setPesoTotal(Double.valueOf(pesoTotalItem));
            i.setVolumeTotal(Double.valueOf(volumeTotalItem));
            qtdTotal += qtdTotalItem;
            volumeTotal += volumeTotalItem;
            pesoTotal += pesoTotalItem;
        }
        this.wmsSaidaEstoque.setQuantidadeTotal(Double.valueOf(qtdTotal));
        this.wmsSaidaEstoque.setVolumeTotal(Double.valueOf(volumeTotal));
        this.wmsSaidaEstoque.setPesoTotal(Double.valueOf(pesoTotal));
    }

    private void createItens(WmsSaidaEstoque saida, WmsSeparacaoPedido separacaoWms, WmsOpcoes wmsOpcoes) {
        for (WmsSeparacaoPedidoEmb emb : separacaoWms.getEmbalagens()) {
            for (WmsSeparacaoPedidoGrConf gr : emb.getGradesConf()) {
                WmsSaidaEstoqueGrade grade;
                WmsSaidaEstoqueItem item;
                if (gr.getWmsEndereco() == null || gr.getLoteFabricacao() == null) continue;
                Produto prod = gr.getGradeCor().getProdutoGrade().getProduto();
                Optional<WmsSaidaEstoqueItem> foundPr = saida.getItens().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto(), (Object)prod) && ToolMethods.isEquals((Object)i.getWmsEndereco(), (Object)gr.getWmsEndereco())).findFirst();
                if (foundPr.isPresent()) {
                    item = foundPr.get();
                } else {
                    item = new WmsSaidaEstoqueItem();
                    item.setWmsEndereco(gr.getWmsEndereco());
                    saida.getItens().add(item);
                }
                item.setProduto(prod);
                item.setWmsSaidaEstoque(saida);
                Optional<WmsSaidaEstoqueGrade> foundGr = item.getGrades().stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor(), (Object)gr.getGradeCor()) && ToolMethods.isEquals((Object)i.getLoteFabricacao(), (Object)gr.getLoteFabricacao())).findFirst();
                if (foundGr.isPresent()) {
                    grade = foundGr.get();
                } else {
                    grade = new WmsSaidaEstoqueGrade();
                    item.getGrades().add(grade);
                }
                grade.setDataSaida(saida.getDataSaida());
                grade.setEmpresa(separacaoWms.getEmpresa());
                grade.setGradeCor(gr.getGradeCor());
                grade.setLoteFabricacao(gr.getLoteFabricacao());
                grade.setWmsEndereco(item.getWmsEndereco());
                grade.setQuantidade(Double.valueOf(gr.getQuantidadeConf() + grade.getQuantidade()));
                grade.setWmsSaidaEstoqueItem(item);
            }
        }
    }

    private void createSetLotesEstoque(WmsSaidaEstoque saida, WmsSeparacaoPedido separacaoWms, WmsOpcoes wmsOpcoes, HashMap<String, List<EstoqueDisponivel>> saldosCache) throws ExceptionInvalidState {
        for (WmsSaidaEstoqueItem item : saida.getItens()) {
            LinkedList aux = new LinkedList(item.getGrades());
            item.getGrades().clear();
            for (WmsSaidaEstoqueGrade grade : aux) {
                if (grade.getLoteFabricacao() != null && grade.getWmsEndereco() != null) {
                    item.getGrades().add(grade);
                } else {
                    this.createGradesConfEstoque(item.getGrades(), saida, separacaoWms, wmsOpcoes, grade, saldosCache);
                }
                for (WmsSaidaEstoqueGrade gr : item.getGrades()) {
                    gr.setWmsSaidaEstoqueItem(item);
                }
            }
        }
    }

    private void createGradesConfEstoque(List<WmsSaidaEstoqueGrade> aux, WmsSaidaEstoque saida, WmsSeparacaoPedido separacaoWms, WmsOpcoes wmsOpcoes, WmsSaidaEstoqueGrade gradeBase, HashMap<String, List<EstoqueDisponivel>> saldosCache) throws ExceptionInvalidState {
        String key = separacaoWms.getEmpresa().getIdentificador() + "|" + gradeBase.getGradeCor().getIdentificador();
        List<EstoqueDisponivel> saldos = saldosCache.get(key);
        if (saldos == null) {
            saldos = this.helperWmsPedido.getSaldosEstoque(separacaoWms.getPedidoWms(), separacaoWms.getEmpresa(), gradeBase.getGradeCor(), saida.getDataSaida(), gradeBase.getQuantidade(), CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE);
            saldosCache.put(key, saldos);
        }
        for (EstoqueDisponivel saldo : saldos) {
            WmsSaidaEstoqueGrade wg = new WmsSaidaEstoqueGrade();
            wg.setDataSaida(gradeBase.getDataSaida());
            wg.setEmpresa(gradeBase.getEmpresa());
            wg.setGradeCor(gradeBase.getGradeCor());
            wg.setQuantidade(saldo.getQuantidade());
            if (saldo.getEstoque() != null && saldo.getEstoque().getSource() != null) {
                LoteFabricacao loteFabricacao = null;
                WmsEndereco wmsEndereco = null;
                if (saldo.getEstoque().getSource() instanceof WmsSaldoEstoque) {
                    loteFabricacao = (LoteFabricacao)this.serviceLoteFabricacaoImpl.get(((WmsSaldoEstoque)saldo.getEstoque().getSource()).getIdLoteFabricacao());
                    wmsEndereco = (WmsEndereco)this.serviceWmsEnderecoImpl.get(((WmsSaldoEstoque)saldo.getEstoque().getSource()).getIdWmsEndereco());
                } else if (saldo.getEstoque().getSource() instanceof WmsPedidoItemReserva) {
                    loteFabricacao = ((WmsPedidoItemReserva)saldo.getEstoque().getSource()).getLoteFabricacao();
                    wmsEndereco = ((WmsPedidoItemReserva)saldo.getEstoque().getSource()).getWmsEndereco();
                }
                wg.setLoteFabricacao(loteFabricacao);
                wg.setWmsEndereco(wmsEndereco);
            }
            aux.add(wg);
        }
    }
}

