/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.wmsseparacaopedido;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstTipoSugestaoEmbWms;
import com.touchcomp.basementor.constants.enums.wmsopcoes.EnumConstWmsOpcoesOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemEmb;
import com.touchcomp.basementor.model.vo.WmsPedidoItemGrade;
import com.touchcomp.basementor.model.vo.WmsPedidoItemReserva;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.wmsopcoes.HelperWmsOpcoes;
import com.touchcomp.basementorservice.helpers.impl.wmspedido.HelperWmsPedido;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.wmsendereco.ServiceWmsEnderecoImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.wmsseparacaopedido.web.DTOWmsSeparacaoPedido;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperWmsSeparacaoPedido
implements AbstractHelper<WmsSeparacaoPedido> {
    private WmsSeparacaoPedido wmsSeparacao;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLote;
    @Autowired
    CompTotaisItemGradesAdp compTotalizadoresItem;
    @Autowired
    ServiceWmsEnderecoImpl serviceWmsEnd;
    @Autowired
    HelperWmsPedido helperPedido;
    @Autowired
    HelperWmsOpcoes helperWmsOpcoes;
    @Autowired
    CompEstoqueDisponibilidade compEstoqueDisponibilidade;

    public HelperWmsSeparacaoPedido build(WmsSeparacaoPedido wmsSaidaEstoque) {
        this.wmsSeparacao = wmsSaidaEstoque;
        return this;
    }

    public WmsSeparacaoPedido get() {
        return this.wmsSeparacao;
    }

    public void calcularTotalizadores() {
        double volumeTotal = 0.0;
        double pesoTotal = 0.0;
        double quantidadeConf = 0.0;
        this.calcularTotalizadores(this.wmsSeparacao.getEmbalagens());
        for (WmsSeparacaoPedidoEmb emb : this.wmsSeparacao.getEmbalagens()) {
            pesoTotal += emb.getPesoUtilizado().doubleValue();
            volumeTotal += emb.getVolumeUtilizado().doubleValue();
            quantidadeConf += emb.getQuantidadeItens().doubleValue();
            emb.setSeparacaoPedido(this.wmsSeparacao);
        }
        this.wmsSeparacao.setPesoTotalConf(Double.valueOf(pesoTotal));
        this.wmsSeparacao.setVolumeTotaConf(Double.valueOf(volumeTotal));
        this.wmsSeparacao.setQuantidadeTotalConf(Double.valueOf(quantidadeConf));
        this.wmsSeparacao.setPesoTotal(this.wmsSeparacao.getPedidoWms().getPesoTotal());
        this.wmsSeparacao.setVolumeTotal(this.wmsSeparacao.getPedidoWms().getVolumeTotal());
        this.wmsSeparacao.setQuantidadeTotal(this.wmsSeparacao.getPedidoWms().getQuantidadeTotal());
        this.wmsSeparacao.setPercConferido(ToolNumber.calcPercentual((Double)this.wmsSeparacao.getQuantidadeTotalConf(), (Double)this.wmsSeparacao.getQuantidadeTotal()));
    }

    public void calcularTotalizadores(List<WmsSeparacaoPedidoEmb> ret) {
        for (WmsSeparacaoPedidoEmb emb : ret) {
            this.calcularTotalizadores(emb);
        }
    }

    public void calcularTotalizadores(WmsSeparacaoPedidoEmb emb) {
        double volumeUtilizado = 0.0;
        double pesoUtilizado = 0.0;
        double qtdItens = 0.0;
        for (WmsSeparacaoPedidoGrConf grade : emb.getGradesConf()) {
            volumeUtilizado += grade.getGradeCor().getProdutoGrade().getProduto().getVolume() * grade.getQuantidadeConf();
            pesoUtilizado += grade.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario() * grade.getQuantidadeConf();
            qtdItens += grade.getQuantidadeConf().doubleValue();
            grade.setSeparacaoPedidoEmb(emb);
        }
        emb.setQuantidadeItens(Double.valueOf(qtdItens));
        emb.setPesoUtilizado(Double.valueOf(pesoUtilizado));
        emb.setVolumeUtilizado(Double.valueOf(volumeUtilizado));
        emb.setPercVolumeUtilizado(ToolNumber.calcPercentual((Double)emb.getVolumeUtilizado(), (Double)emb.getCapacidadeVolume()));
        emb.setPercVolumeUtilizado(ToolNumber.calcPercentual((Double)emb.getPesoUtilizado(), (Double)emb.getCapacidadePeso()));
    }

    public List<WmsSeparacaoPedidoEmb> getSugestaoEmbalagens(WmsPedido ped, WmsOpcoes opcoes) throws ExceptionInvalidState {
        LinkedList<WmsSeparacaoPedidoEmb> ret = new LinkedList<WmsSeparacaoPedidoEmb>();
        EnumConstTipoSugestaoEmbWms tipoSug = EnumConstTipoSugestaoEmbWms.get((Short)((Short)CompOpcoes.getOption(this.helperWmsOpcoes.build(opcoes).getItens(), (EnumOpDinamicasInterface)EnumConstWmsOpcoesOp.SUGERIR_END_VAZIOS, Short.class)));
        if (ToolMethods.isEquals((Object)tipoSug, (Object)EnumConstTipoSugestaoEmbWms.NAO_SUGERIR)) {
            return ret;
        }
        LinkedList<ToolMethods.Pair<WmsSeparacaoPedidoEmb, Double>> temp = new LinkedList<ToolMethods.Pair<WmsSeparacaoPedidoEmb, Double>>();
        List grades = this.compTotalizadoresItem.getTotaisGrades(ped);
        HashMap<GradeCor, List<EstoqueDisponivel>> aux = new HashMap<GradeCor, List<EstoqueDisponivel>>();
        Date dataConsulta = TDate.dataSemHora((Date)new Date());
        if (ToolMethods.isEquals((Object)tipoSug, (Object)EnumConstTipoSugestaoEmbWms.SUGERIR_EMBALAGENS_ESTOQUE)) {
            for (TotalItemGrade grade : grades) {
                List<EstoqueDisponivel> est = this.helperPedido.getSaldosEstoque(ped, ped.getEmpresa(), grade.getGradeCor(), dataConsulta, grade.getQuantidadeTotal(), CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LISTA_EST_VAZIA);
                aux.put(grade.getGradeCor(), est);
            }
        }
        long j = 1L;
        for (WmsPedidoItem item : ped.getItens()) {
            for (WmsPedidoItemEmb ie : item.getItensEmbalagens()) {
                for (int i = 0; i < ie.getNrEmbalagem(); ++i) {
                    WmsSeparacaoPedidoEmb d = new WmsSeparacaoPedidoEmb();
                    this.setEmbalagem(d, ie.getEmbalagem());
                    d.setNumeroCaixa(Long.valueOf(j));
                    ret.add(d);
                    temp.add((ToolMethods.Pair<WmsSeparacaoPedidoEmb, Double>)new ToolMethods.Pair((Object)d, (Object)ie.getQtdePorEmbalagem()));
                    ++j;
                }
            }
            if (temp.isEmpty()) continue;
            for (WmsPedidoItemGrade grade : item.getGrades()) {
                List est = (List)aux.get(grade.getGradeCor());
                if (!ToolMethods.isWithData((Collection)est)) {
                    this.defineItens(temp, grade, grade.getQuantidade(), null, null);
                    continue;
                }
                this.defineItensEstoque(temp, grade, est);
            }
        }
        this.calcularTotalizadores(ret);
        return ret;
    }

    public WmsSeparacaoPedidoEmb getEmbalagem(EmbalagemProducao emb, WmsEndereco wmsEndereco, WmsPedido pedido) throws ExceptionInvalidState {
        LinkedList allGrades = new LinkedList();
        for (WmsPedidoItem item : pedido.getItens()) {
            allGrades.addAll(item.getGrades());
        }
        WmsSeparacaoPedidoEmb ret = new WmsSeparacaoPedidoEmb();
        this.setEmbalagem(ret, emb.getEmbalagem());
        for (ItemEmbalagemProducao iep : emb.getItemEmbalagemProducao()) {
            Optional<WmsPedidoItemGrade> found = allGrades.stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor(), (Object)iep.getGradeCor())).findFirst();
            if (!found.isPresent()) {
                throw new ExceptionInvalidState("E.ERP.1916.002", new Object[]{iep.getGradeCor().getProdutoGrade().getProduto(), iep.getGradeCor()});
            }
            WmsSeparacaoPedidoGrConf item = new WmsSeparacaoPedidoGrConf();
            item.setLoteFabricacao(iep.getLoteFabricacao());
            item.setQuantidadeConf(iep.getQuantidade());
            item.setGradeCor(iep.getGradeCor());
            item.setWmsEndereco(wmsEndereco);
            ret.getGradesConf().add(item);
        }
        this.calcularTotalizadores(ret);
        return ret;
    }

    private void defineItens(List<ToolMethods.Pair<WmsSeparacaoPedidoEmb, Double>> embalagens, WmsPedidoItemGrade gradeItem, Double quantidade, LoteFabricacao lote, WmsEndereco end) {
        double aux = quantidade;
        do {
            Optional<ToolMethods.Pair> a;
            if (!(a = embalagens.stream().filter(i -> ((WmsSeparacaoPedidoEmb)i.getKey()).getQuantidadeItens() < (Double)i.getValue()).findFirst()).isPresent()) {
                return;
            }
            ToolMethods.Pair item = a.get();
            Double capDisp = (Double)item.getValue() - ((WmsSeparacaoPedidoEmb)item.getKey()).getQuantidadeItens();
            WmsSeparacaoPedidoGrConf gr = new WmsSeparacaoPedidoGrConf();
            if (aux < capDisp) {
                gr.setQuantidadeConf(Double.valueOf(aux));
                aux = 0.0;
            } else {
                gr.setQuantidadeConf(capDisp);
                aux -= capDisp.doubleValue();
            }
            ((WmsSeparacaoPedidoEmb)item.getKey()).setQuantidadeItens(Double.valueOf(((WmsSeparacaoPedidoEmb)item.getKey()).getQuantidadeItens() + gr.getQuantidadeConf()));
            gr.setSeparacaoPedidoEmb((WmsSeparacaoPedidoEmb)item.getKey());
            gr.setGradeCor(gradeItem.getGradeCor());
            gr.setWmsEndereco(end);
            gr.setLoteFabricacao(lote);
            ((WmsSeparacaoPedidoEmb)item.getKey()).getGradesConf().add(gr);
        } while (aux > 0.0);
    }

    private void defineItensEstoque(List<ToolMethods.Pair<WmsSeparacaoPedidoEmb, Double>> embalagens, WmsPedidoItemGrade gradeItem, List<EstoqueDisponivel> est) throws ExceptionInvalidState {
        LinkedList temp = new LinkedList();
        for (EstoqueDisponivel estoqueDisponivel : est) {
            temp.add(estoqueDisponivel.getEstoque());
        }
        List estAux = this.compEstoqueDisponibilidade.getDisponibilidades(temp, gradeItem.getQuantidade(), gradeItem.getGradeCor(), EnumConstOpEstoqueEstrategia.MENOS_VARIACOES, CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LISTA_EST_VAZIA);
        for (EstoqueDisponivel saldo : estAux) {
            LoteFabricacao loteFabricacao = null;
            WmsEndereco wmsEndereco = null;
            if (saldo.getEstoque().getSource() instanceof WmsSaldoEstoque) {
                loteFabricacao = (LoteFabricacao)this.serviceLote.get(((WmsSaldoEstoque)saldo.getEstoque().getSource()).getIdLoteFabricacao());
                wmsEndereco = (WmsEndereco)this.serviceWmsEnd.get(((WmsSaldoEstoque)saldo.getEstoque().getSource()).getIdWmsEndereco());
            } else if (saldo.getEstoque().getSource() instanceof WmsPedidoItemReserva) {
                loteFabricacao = ((WmsPedidoItemReserva)saldo.getEstoque().getSource()).getLoteFabricacao();
                wmsEndereco = ((WmsPedidoItemReserva)saldo.getEstoque().getSource()).getWmsEndereco();
            }
            this.defineItens(embalagens, gradeItem, saldo.getQuantidade(), loteFabricacao, wmsEndereco);
        }
    }

    private void setEmbalagem(WmsSeparacaoPedidoEmb d, Embalagem embalagem) {
        d.setCapacidadePeso(embalagem.getCapacidadePeso());
        d.setCapacidadeVolume(embalagem.getCapacidadeVolume());
        d.setEmbalagem(embalagem);
    }

    public void setNumeroCaixasSeNecessario(List<DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb> input) {
        if (!ToolMethods.isWithData(input)) {
            return;
        }
        DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb maxNr = (DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb)input.stream().max((i1, i2) -> i1.getNumeroCaixa().compareTo(i2.getNumeroCaixa())).get();
        Long nr = maxNr.getNumeroCaixa();
        for (DTOWmsSeparacaoPedido.DTOWmsSeparacaoProdutosEmb emb : input) {
            if (ToolMethods.isWithData((Number)emb.getNumeroCaixa())) continue;
            Long l = nr;
            nr = nr + 1L;
            emb.setNumeroCaixa(nr);
        }
        Collections.sort(input, (i1, i2) -> i1.getNumeroCaixa().compareTo(i2.getNumeroCaixa()));
    }

    public void ordenarCaixas(List<WmsSeparacaoPedidoEmb> embalagens) {
        Collections.sort(embalagens, (i1, i2) -> i1.getNumeroCaixa().compareTo(i2.getNumeroCaixa()));
    }
}

