/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.workspacebanco;

import com.touchcomp.basementor.constants.enums.workspacebanco.santander.EnumConstSantanderAuthOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.WorkspaceBanco;
import com.touchcomp.basementor.model.vo.WorkspaceBancoAuthOp;
import com.touchcomp.basementor.model.vo.WorkspaceBancoOp;
import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.workspacebanco.web.DTOWorkspaceBancoRes;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperWorkspaceBanco
implements AbstractHelper<WorkspaceBanco> {
    private WorkspaceBanco workspace;

    public HelperWorkspaceBanco build(WorkspaceBanco opcoes) {
        this.workspace = opcoes;
        return this;
    }

    public WorkspaceBanco get() {
        return this.workspace;
    }

    public List<ModelOpDinamicasInterface> getItens(List<WorkspaceBancoOp> itens) {
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        if (TMethods.isNotNull(itens).booleanValue() && TMethods.isWithData(itens)) {
            for (final WorkspaceBancoOp opcoesOp : itens) {
                ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                    public String getValor() {
                        return opcoesOp.getValor();
                    }

                    public String getChave() {
                        return opcoesOp.getCodigo();
                    }

                    public String getObservacao() {
                        return opcoesOp.getObservacao();
                    }

                    public Long getIdentificador() {
                        return opcoesOp.getIdentificador();
                    }
                };
                options.add(a);
            }
        }
        return options;
    }

    public List<ModelOpDinamicasInterface> getAuthItens(List<WorkspaceBancoAuthOp> itens) {
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        if (TMethods.isNotNull(itens).booleanValue() && TMethods.isWithData(itens)) {
            for (final WorkspaceBancoAuthOp opcoesOp : itens) {
                ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                    public String getValor() {
                        return opcoesOp.getValor();
                    }

                    public String getChave() {
                        return opcoesOp.getCodigo();
                    }

                    public String getObservacao() {
                        return opcoesOp.getObservacao();
                    }

                    public Long getIdentificador() {
                        return opcoesOp.getIdentificador();
                    }
                };
                options.add(a);
            }
        }
        return options;
    }

    public List<ModelOpDinamicasInterface> getAuthItensDTO(List<DTOWorkspaceBancoRes.DTOWorkspaceBancoAuthOp> itens) {
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        if (TMethods.isNotNull(itens).booleanValue() && TMethods.isWithData(itens)) {
            for (final DTOWorkspaceBancoRes.DTOWorkspaceBancoAuthOp opcoesOp : itens) {
                ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                    public String getValor() {
                        return opcoesOp.getValor();
                    }

                    public String getChave() {
                        return opcoesOp.getCodigo();
                    }

                    public String getObservacao() {
                        return opcoesOp.getObservacao();
                    }

                    public Long getIdentificador() {
                        return opcoesOp.getIdentificador();
                    }
                };
                options.add(a);
            }
        }
        return options;
    }

    public BankCredentials getCredentials(InstituicaoValores inst, DTOWorkspaceBancoRes data, ConfiguracaoCertificado conf) {
        BankType bankType = BankType.get((String)inst.getNrBanco());
        BankCredentials credentials = new BankCredentials(bankType, EnvironmentType.PRODUCAO);
        credentials.setCertificate(conf.getArquivoPFX());
        credentials.setCertificatePass(conf.getSenha());
        credentials.setKeystore(conf.getArquivoJKS());
        credentials.setKeystorePass("touchcompKeyStore");
        switch (bankType) {
            case SANTANDER: {
                String clientId = this.getPropertyAuthId(data, EnumConstSantanderAuthOp.CLIENT_ID);
                String clientSecret = this.getPropertyAuthId(data, EnumConstSantanderAuthOp.CLIENT_SECRET);
                credentials.putParams("client_id", clientId);
                credentials.putParams("client_secret", clientSecret);
                break;
            }
        }
        return credentials;
    }

    public String getPropertyAuthId(DTOWorkspaceBancoRes data, EnumConstSantanderAuthOp property) {
        return (String)CompOpcoes.getOption(this.getAuthItensDTO(data.getOpcoesAuthOp()), (EnumOpDinamicasInterface)property, String.class);
    }

    public String getPropertyAuthId(WorkspaceBanco data, EnumConstSantanderAuthOp property) {
        return (String)CompOpcoes.getOption(this.getAuthItens(data.getOpcoesAuthOp()), (EnumOpDinamicasInterface)property, String.class);
    }

    public BankCredentials getCredentials(WorkspaceBanco workspace) {
        BankType bankType = BankType.get((String)workspace.getInstituicaoValores().getNrBanco());
        BankCredentials credentials = new BankCredentials(bankType, EnvironmentType.PRODUCAO);
        credentials.setCertificate(workspace.getConfiguracaoCertificado().getArquivoPFX());
        credentials.setCertificatePass(workspace.getConfiguracaoCertificado().getSenha());
        credentials.setKeystore(workspace.getConfiguracaoCertificado().getArquivoJKS());
        credentials.setKeystorePass("touchcompKeyStore");
        switch (bankType) {
            case SANTANDER: {
                String clientId = this.getPropertyAuthId(workspace, EnumConstSantanderAuthOp.CLIENT_ID);
                String clientSecret = this.getPropertyAuthId(workspace, EnumConstSantanderAuthOp.CLIENT_SECRET);
                credentials.putParams("client_id", clientId);
                credentials.putParams("client_secret", clientSecret);
                break;
            }
        }
        return credentials;
    }

    public String getProperty(List<WorkspaceBancoOp> opcoesOp, EnumOpDinamicasInterface key) {
        return (String)CompOpcoes.getOption(this.getItens(opcoesOp), (EnumOpDinamicasInterface)key, String.class);
    }
}

