/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.agronomo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.tecnicoagricola.EnumConstTipoART;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.TecnicoAgricola;
import com.touchcomp.basementor.model.vo.TecnicoAgricolaART;
import com.touchcomp.basementor.model.vo.TecnicoAgricolaCREA;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.WebReceitaAgronomo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.model.DTOAgronomo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.model.DTOAgronomoResultInsert;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.WebReceitaAgronomoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoARTV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoConsultatV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaUdpateResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoCreaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoResultInsertV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoUpdateResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.WebReceitaOutrosV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOConsultaCidadeResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOConsultaUFResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.tecnicoagricola.ServiceTecnicoAgricolaImpl;
import com.touchcomp.basementorservice.service.impl.tecnicoagricolaart.ServiceTecnicoAgricolaARTImpl;
import com.touchcomp.basementorservice.service.impl.tecnicoagricolacrea.ServiceTecnicoAgricolaCREAImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaAgronomoImpl
extends WebReceitaCliBase {
    @Autowired
    private ServiceTecnicoAgricolaImpl serviceTecnicoAgricola;
    @Autowired
    private ServicePessoaImpl servicePessoa;
    @Autowired
    private ServiceTecnicoAgricolaARTImpl serviceTecnicoAgricolaART;
    @Autowired
    private ServiceTecnicoAgricolaCREAImpl serviceTecnicoAgricolaCrea;

    public TecnicoAgricola registrarAtualizar(TecnicoAgricola tecnicoAgricola) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        switch (webConfig.getVersao()) {
            case "v1": {
                tecnicoAgricola = this.registrarTecAgricola(webConfig, tecnicoAgricola);
                break;
            }
            case "v2": {
                tecnicoAgricola = this.registrarTecAgricolaV2(webConfig, tecnicoAgricola);
                break;
            }
            default: {
                throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
        }
        return this.serviceTecnicoAgricola.saveOrUpdate(tecnicoAgricola);
    }

    private TecnicoAgricola registrarTecAgricolaV2(WebReceitaConfig webConfig, TecnicoAgricola tecnicoAgricola) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaAgronomoV2 web = new WebReceitaAgronomoV2();
        tecnicoAgricola = this.enviarTecAgricolaV2(webConfig, tecnicoAgricola, web);
        tecnicoAgricola = this.enviarEnderecoV2(webConfig, tecnicoAgricola, web);
        this.enviarCREA(webConfig, tecnicoAgricola, web);
        tecnicoAgricola.setDataAtualizacaoSisTerc(new Date());
        tecnicoAgricola = this.serviceTecnicoAgricola.saveOrUpdate(tecnicoAgricola);
        return tecnicoAgricola;
    }

    private TecnicoAgricola registrarTecAgricola(WebReceitaConfig webConfig, TecnicoAgricola tecnicoAgricola) throws ExceptionValidacaoDados, ExceptionIO {
        if (tecnicoAgricola.getDataAtualizacaoSisTerc() != null && (tecnicoAgricola.getDataAtualizacaoSisTerc().equals(tecnicoAgricola.getDataAtualizacao()) || tecnicoAgricola.getDataAtualizacaoSisTerc().after(tecnicoAgricola.getDataAtualizacao()))) {
            return tecnicoAgricola;
        }
        DTOAgronomo agro = new DTOAgronomo();
        agro.setArtPrimaria(tecnicoAgricola.getArtPrimaria());
        agro.setArtSecundaria(tecnicoAgricola.getArtSecundaria());
        if (ToolMethods.isEquals((Object)tecnicoAgricola.getPessoa().getAtivo(), (Object)1)) {
            agro.setAtivo(Boolean.TRUE);
        } else {
            agro.setAtivo(Boolean.FALSE);
        }
        if (ToolMethods.isEquals((Object)tecnicoAgricola.getBuscarArt(), (Object)1)) {
            agro.setBuscaArt(Boolean.TRUE);
        } else {
            agro.setBuscaArt(Boolean.FALSE);
        }
        agro.setComplemento(tecnicoAgricola.getPessoa().getEndereco().getComplemento());
        agro.setCpf(tecnicoAgricola.getPessoa().getComplemento().getCnpj());
        agro.setCrea(tecnicoAgricola.getCrea());
        agro.setDataAtualizacao((Date)tecnicoAgricola.getDataAtualizacao());
        agro.setDataCadastro(tecnicoAgricola.getDataCadastro());
        if (tecnicoAgricola.getFormatoReceita() != null) {
            agro.setFormatoReceita(String.valueOf(tecnicoAgricola.getFormatoReceita()));
        }
        agro.setLogin(tecnicoAgricola.getLogin());
        agro.setSenha(tecnicoAgricola.getSenha());
        agro.setLogradouro(tecnicoAgricola.getPessoa().getEndereco().getLogradouro());
        DTOAgronomo.Municipio mun = new DTOAgronomo.Municipio();
        mun.setIbge(Integer.valueOf(tecnicoAgricola.getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        agro.setMunicipio(mun);
        agro.setNCopias(tecnicoAgricola.getNrCopias());
        agro.setNReceitasArt(tecnicoAgricola.getNrReceitasArt());
        agro.setNReceitasMes(tecnicoAgricola.getNrReceitasMes());
        agro.setNome(tecnicoAgricola.getPessoa().getNome());
        agro.setNumero(tecnicoAgricola.getPessoa().getEndereco().getNumero());
        agro.setProfissao("Agronomo");
        agro.setUltimaReceita(tecnicoAgricola.getNrUltimaReceita());
        agro.setCep(tecnicoAgricola.getPessoa().getEndereco().getCep());
        WebReceitaAgronomo web = new WebReceitaAgronomo();
        DTOAgronomoResultInsert res = web.inserirAgronomo(webConfig, agro);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: ND"});
        }
        tecnicoAgricola.setCodSincronizacao(String.valueOf(res.getSucesso().getIdAgronomo()));
        return tecnicoAgricola;
    }

    private List enviarArt(WebReceitaConfig webConfig, TecnicoAgricolaCREA crea, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        LinkedList<TecnicoAgricolaART> aux = new LinkedList<TecnicoAgricolaART>();
        for (TecnicoAgricolaART art : crea.getTecnicoAgrART()) {
            aux.add(this.enviarART(webConfig, art, crea, web));
        }
        return aux;
    }

    private void enviarCREA(WebReceitaConfig webConfig, TecnicoAgricola tecnicoAgricola, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        LinkedList<TecnicoAgricolaCREA> aux = new LinkedList<TecnicoAgricolaCREA>();
        for (TecnicoAgricolaCREA crea : tecnicoAgricola.getTecnicoAgrCrea()) {
            aux.add(this.enviarCrea(webConfig, crea, tecnicoAgricola, web));
            List temp = this.enviarArt(webConfig, crea, web);
            crea.setTecnicoAgrART(temp);
        }
        tecnicoAgricola.setTecnicoAgrCrea(aux);
    }

    private TecnicoAgricola enviarTecAgricolaV2(WebReceitaConfig webConfig, TecnicoAgricola tecnicoAgricola, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        if (tecnicoAgricola.getDataAtualizacaoSisTerc() != null && (tecnicoAgricola.getDataAtualizacaoSisTerc().equals(tecnicoAgricola.getDataAtualizacao()) || ToolDate.difBetweenDatesInSeconds((Date)tecnicoAgricola.getDataAtualizacaoSisTerc(), (Date)tecnicoAgricola.getDataAtualizacao()) < 10L)) {
            return tecnicoAgricola;
        }
        if (ToolMethods.isStrWithData((String)tecnicoAgricola.getCodSincronizacao())) {
            DTOAgronomoUpdateV2 agro = new DTOAgronomoUpdateV2();
            agro.setAtivo(Boolean.valueOf(ToolMethods.isAffirmative((Number)tecnicoAgricola.getAtivo())));
            agro.setInscricao(tecnicoAgricola.getPessoa().getComplemento().getCnpj());
            agro.setNome(tecnicoAgricola.getPessoa().getNome());
            agro.setTitulo(tecnicoAgricola.getTitulo());
            agro.setId(Long.valueOf(tecnicoAgricola.getCodSincronizacao()));
            if (tecnicoAgricola.getConfiguracaoCertificado() != null) {
                agro.setSenhaCertificado(tecnicoAgricola.getConfiguracaoCertificado().getSenha());
            } else {
                agro.setSenhaCertificado("");
            }
            agro.setObservacoes(ToolMethods.emptyIfNull((String)tecnicoAgricola.getPessoa().getObservacao()));
            DTOAgronomoUpdateResV2 res = web.atualizarAgronomo(webConfig, agro);
            tecnicoAgricola.setCodSincronizacao(String.valueOf(res.getId()));
        } else {
            DTOAgronomoV2 agro = new DTOAgronomoV2();
            agro.setAtivo(Boolean.valueOf(ToolMethods.isAffirmative((Number)tecnicoAgricola.getAtivo())));
            agro.setInscricao(tecnicoAgricola.getPessoa().getComplemento().getCnpj());
            agro.setNome(tecnicoAgricola.getPessoa().getNome());
            agro.setTitulo(tecnicoAgricola.getTitulo());
            if (tecnicoAgricola.getConfiguracaoCertificado() != null) {
                agro.setSenhaCertificado(tecnicoAgricola.getConfiguracaoCertificado().getSenha());
            } else {
                agro.setSenhaCertificado("");
            }
            agro.setObservacoes(ToolMethods.emptyIfNull((String)tecnicoAgricola.getPessoa().getObservacao()));
            DTOAgronomoResultInsertV2 res = web.cadastrarAgronomo(webConfig, agro);
            tecnicoAgricola.setCodSincronizacao(String.valueOf(res.getId()));
        }
        tecnicoAgricola = this.serviceTecnicoAgricola.saveOrUpdate(tecnicoAgricola);
        if (tecnicoAgricola.getConfiguracaoCertificado() != null && tecnicoAgricola.getConfiguracaoCertificado().getTipoCertificado() != 0) {
            throw new ExceptionValidacaoDados("E.ERP.0094.106", new Object[]{tecnicoAgricola});
        }
        return tecnicoAgricola;
    }

    public TecnicoAgricola consultarTecnico(TecnicoAgricola vo) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaAgronomoV2 web = new WebReceitaAgronomoV2();
        WebReceitaConfig webConfig = this.getConf();
        DTOAgronomoConsultatV2 res = web.consultarTecnico(webConfig, vo.getPessoa().getComplemento().getCnpj());
        if (res != null) {
            vo.setCodSincronizacao(String.valueOf(res.getId()));
            for (TecnicoAgricolaCREA crea : vo.getTecnicoAgrCrea()) {
                Optional<DTOAgronomoConsultatV2.CREA> found = res.getCrea().stream().filter(i -> ToolMethods.isEquals((Object)i.getCrea(), (Object)crea.getCrea())).findFirst();
                if (found.isPresent()) {
                    crea.setCodSincronizacao(found.get().getId().toString());
                }
                for (TecnicoAgricolaART art : crea.getTecnicoAgrART()) {
                    Optional<DTOAgronomoConsultatV2.ART> foundAr = res.getArt().stream().filter(i -> ToolMethods.isEquals((Object)i.getNumeroART(), (Object)art.getNumeroART())).findFirst();
                    if (!foundAr.isPresent()) continue;
                    art.setCodSincronizacao(foundAr.get().getId().toString());
                }
            }
        }
        return this.serviceTecnicoAgricola.saveOrUpdate(vo);
    }

    private TecnicoAgricolaCREA enviarCrea(WebReceitaConfig webConfig, TecnicoAgricolaCREA crea, TecnicoAgricola tecnicoAgricola, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        if (crea.getDataAtualizacaoSisTerc() != null && (crea.getDataAtualizacaoSisTerc().equals(crea.getDataAtualizacao()) || ToolDate.difBetweenDatesInSeconds((Date)crea.getDataAtualizacaoSisTerc(), (Date)crea.getDataAtualizacao()) < 10L)) {
            return crea;
        }
        DTOConsultaUFResV2.UF uf = this.getUF(webConfig, crea.getUf());
        if (ToolMethods.isStrWithData((String)crea.getCodSincronizacao())) {
            DTOAgronomoCreaUpdateV2 aux = new DTOAgronomoCreaUpdateV2();
            aux.setCodigoUF(uf.getId());
            aux.setCodTecnicoAgricola(Long.valueOf(tecnicoAgricola.getCodSincronizacao()));
            aux.setCrea(crea.getCrea());
            aux.setId(Long.valueOf(crea.getCodSincronizacao()));
            aux.setEnderecoEntregaEmbalagens(crea.getEnderecoEntregaEmb());
            aux.setNrProdutosReceita(crea.getQtdProdReceita());
            aux.setNrReceitasMes(crea.getNrReceitasMes());
            aux.setObrigatorioEmissaoART(Boolean.valueOf(ToolMethods.isAffirmative((Number)crea.getObrigatorioEmissaoART())));
            DTOAgronomoCreaUdpateResV2 res = web.atualizarCrea(webConfig, aux);
            crea.setCodSincronizacao(res.getId().toString());
        } else {
            DTOAgronomoCreaV2 aux = new DTOAgronomoCreaV2();
            aux.setCodigoUF(uf.getId());
            aux.setCodTecnicoAgricola(Long.valueOf(tecnicoAgricola.getCodSincronizacao()));
            aux.setCrea(crea.getCrea());
            aux.setEnderecoEntregaEmbalagens(crea.getEnderecoEntregaEmb());
            aux.setNrProdutosReceita(crea.getQtdProdReceita());
            aux.setNrReceitasMes(crea.getNrReceitasMes());
            aux.setObrigatorioEmissaoART(Boolean.valueOf(ToolMethods.isAffirmative((Number)crea.getObrigatorioEmissaoART())));
            DTOAgronomoCreaResV2 res = web.cadastrarCrea(webConfig, aux);
            crea.setCodSincronizacao(res.getId().toString());
        }
        crea.setDataAtualizacaoSisTerc(new Date());
        crea = this.serviceTecnicoAgricolaCrea.saveOrUpdate(crea);
        return crea;
    }

    private TecnicoAgricolaART enviarART(WebReceitaConfig webConfig, TecnicoAgricolaART art, TecnicoAgricolaCREA crea, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        if (art.getDataAtualizacaoSisTerc() != null && (art.getDataAtualizacaoSisTerc().equals(art.getDataAtualizacao()) || ToolDate.difBetweenDatesInSeconds((Date)art.getDataAtualizacaoSisTerc(), (Date)art.getDataAtualizacao()) < 10L)) {
            return art;
        }
        DTOConsultaUFResV2.UF uf = this.getUF(webConfig, crea.getUf());
        if (ToolMethods.isStrWithData((String)art.getCodSincronizacao())) {
            DTOAgronomoARTUpdateV2 aux = new DTOAgronomoARTUpdateV2();
            aux.setEstado(uf.getId());
            aux.setDataFinal(art.getDataFim());
            aux.setDataInicial(art.getDataIn());
            aux.setNrReceitaInicial(art.getNrReceitaIn());
            aux.setNrReceitaFinal(art.getNrReceitaFim());
            aux.setNumeroART(art.getNumeroART());
            if (ToolMethods.isStrWithData((String)art.getSerie())) {
                aux.setSerie(Integer.valueOf(art.getSerie()));
            }
            aux.setId(Long.valueOf(art.getCodSincronizacao()));
            aux.setSituacao(Boolean.valueOf(ToolMethods.isAffirmative((Number)art.getAtivo())));
            aux.setUltimaReceita(art.getNrUltimaReceita());
            aux.setCrea(Long.valueOf(crea.getCodSincronizacao()));
            aux.setCodTecAgricola(Long.valueOf(crea.getTecnicoAgricola().getCodSincronizacao()));
            if (ToolMethods.isEquals((Object)art.getTipoArtTrt(), (Object)EnumConstTipoART.NUMERO_SEQUENCIAL.getEnumId())) {
                aux.setTipoArtTrt("S");
            } else if (ToolMethods.isEquals((Object)art.getTipoArtTrt(), (Object)EnumConstTipoART.NUMERO_POR_INTERVALO.getEnumId())) {
                aux.setTipoArtTrt("I");
            }
            DTOAgronomoARTResV2 res = web.atualizarART(webConfig, aux);
            art.setCodSincronizacao(res.getId().toString());
        } else {
            DTOAgronomoARTV2 aux = new DTOAgronomoARTV2();
            aux.setEstado(uf.getId());
            aux.setDataFinal(art.getDataFim());
            aux.setDataInicial(art.getDataIn());
            aux.setNrReceitaInicial(art.getNrReceitaIn());
            aux.setNrReceitaFinal(art.getNrReceitaFim());
            aux.setNumeroART(art.getNumeroART());
            if (ToolMethods.isStrWithData((String)art.getSerie())) {
                aux.setSerie(Integer.valueOf(art.getSerie()));
            }
            aux.setSituacao(Boolean.valueOf(ToolMethods.isAffirmative((Number)art.getAtivo())));
            aux.setUltimaReceita(art.getNrUltimaReceita());
            aux.setCrea(Long.valueOf(crea.getCodSincronizacao()));
            aux.setCodTecAgricola(Long.valueOf(crea.getTecnicoAgricola().getCodSincronizacao()));
            if (ToolMethods.isEquals((Object)art.getTipoArtTrt(), (Object)EnumConstTipoART.NUMERO_SEQUENCIAL.getEnumId())) {
                aux.setTipoArtTrt("S");
            } else if (ToolMethods.isEquals((Object)art.getTipoArtTrt(), (Object)EnumConstTipoART.NUMERO_POR_INTERVALO.getEnumId())) {
                aux.setTipoArtTrt("I");
            }
            DTOAgronomoARTResV2 res = web.cadastrarART(webConfig, aux);
            art.setCodSincronizacao(res.getId().toString());
        }
        art.setDataAtualizacaoSisTerc(new Date());
        return this.serviceTecnicoAgricolaART.saveOrUpdate(art);
    }

    private DTOConsultaUFResV2.UF getUF(WebReceitaConfig webConfig, UnidadeFederativa uf) throws ExceptionIO, ExceptionValidacaoDados {
        DTOConsultaUFResV2 res = new WebReceitaOutrosV2().getUF(webConfig, uf.getCodIbge());
        if (res.getResults().size() > 0) {
            return (DTOConsultaUFResV2.UF)res.getResults().get(0);
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.105", new Object[]{uf});
    }

    private TecnicoAgricola enviarEnderecoV2(WebReceitaConfig webConfig, TecnicoAgricola tecnicoAgricola, WebReceitaAgronomoV2 web) throws ExceptionIO, ExceptionValidacaoDados {
        Endereco e = tecnicoAgricola.getPessoa().getEndereco();
        DTOConsultaCidadeResV2 cid = new WebReceitaOutrosV2().getCidade(webConfig, e.getCidade().getCodIbgeCompleto());
        if (cid == null || cid.getResults() == null || cid.getResults().isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.0094.104", new Object[]{e.getCidade()});
        }
        DTOConsultaCidadeResV2.Cidade c = (DTOConsultaCidadeResV2.Cidade)cid.getResults().get(0);
        if (tecnicoAgricola.getDataAtualizacaoSisTerc() != null && (tecnicoAgricola.getDataAtualizacaoSisTerc().equals(e.getDataAtualizacao()) || ToolDate.difBetweenDatesInSeconds((Date)tecnicoAgricola.getDataAtualizacaoSisTerc(), (Date)tecnicoAgricola.getPessoa().getEndereco().getDataAtualizacao()) < 10L)) {
            return tecnicoAgricola;
        }
        if (ToolMethods.isStrWithData((String)tecnicoAgricola.getCodSincronizacao2())) {
            DTOEnderecoV2 end = new DTOEnderecoV2();
            end.setBairro(ToolMethods.emptyIfNull((String)e.getBairro()));
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdAgentePessoa(Long.valueOf(tecnicoAgricola.getCodSincronizacao()));
            end.setLocalidade(ToolMethods.emptyIfNull((String)e.getObservacao()));
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOEnderecoResV2 res = new WebReceitaOutrosV2().atualizarEndereco(webConfig, tecnicoAgricola.getCodSincronizacao2(), end);
            tecnicoAgricola.setCodSincronizacao2(String.valueOf(res.getId()));
        } else {
            DTOEnderecoV2 end = new DTOEnderecoV2();
            end.setBairro(ToolMethods.emptyIfNull((String)e.getBairro()));
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdAgentePessoa(Long.valueOf(tecnicoAgricola.getCodSincronizacao()));
            end.setLocalidade(ToolMethods.emptyIfNull((String)e.getObservacao()));
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOEnderecoResV2 res = new WebReceitaOutrosV2().cadastrarEndereco(webConfig, end);
            tecnicoAgricola.setCodSincronizacao2(String.valueOf(res.getId()));
        }
        tecnicoAgricola.setPessoa(this.servicePessoa.saveOrUpdate(tecnicoAgricola.getPessoa()));
        return tecnicoAgricola;
    }
}

