/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.consultaarea;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.WebReceitaArea;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.model.DTOAreaResult;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultaarea.WebReceitaAreaV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.stereotype.Component;

@Component
public class CliWebConsultaAreaImpl
extends WebReceitaCliBase {
    public Double consultaArea(Long idUnidadeMedidaDose, Double quantidadeAdquirida, Long nrAplicacoes, Double quantidadeDose, Double volumeCalda) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        switch (webConfig.getVersao()) {
            case "v1": {
                DTOAreaResult res = new WebReceitaArea().getArea(webConfig, idUnidadeMedidaDose, quantidadeAdquirida, nrAplicacoes, quantidadeDose, volumeCalda);
                if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                    throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: ND"});
                }
                return res.getSucesso().getArea();
            }
            case "v2": {
                return new WebReceitaAreaV2().getArea(webConfig, idUnidadeMedidaDose, quantidadeAdquirida, nrAplicacoes, quantidadeDose, volumeCalda).getArea();
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    public Double consultaQuantidade(Long idUnidadeMedidaDose, Double area, Long nrAplicacoes, Double quantidadeDose, Double volumeCalda) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        switch (webConfig.getVersao()) {
            case "v1": {
                throw new ExceptionValidacaoDados("E.ERP.0094.102", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
            case "v2": {
                return new WebReceitaAreaV2().getQuantidade(webConfig, idUnidadeMedidaDose, area, nrAplicacoes, quantidadeDose, volumeCalda).getQuantidade();
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }
}

