/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.culturas;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Cultura;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroCulturasRes;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.WebReceitaCultura;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.model.DTOConsultaCulturaProdResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.model.DTOCulturaResult;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.WebReceitaRelacaoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.model.DTOConsultaRelCulturaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.cultura.WebReceitaCulturasV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperWebReceitaAgronomica;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.auxmodel.TempCulturas;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.cultura.ServiceCulturaImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaCulturasImpl
extends WebReceitaCliBase {
    @Autowired
    private ServiceCulturaImpl serviceCultura;
    @Autowired
    private ServiceConfigServicosTerceirosImpl serviceConfig;

    public List<Cultura> sincronizarCulturas() throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        LinkedList<Cultura> ret = new LinkedList<Cultura>();
        switch (webConfig.getVersao()) {
            case "v1": {
                this.consultaCulturasV1(webConfig, ret);
                break;
            }
            case "v2": {
                this.consultaCulturasV2(webConfig, ret);
                break;
            }
            default: {
                throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
        }
        return ret;
    }

    public List<TempCulturas> consultaCultura(String idProduto) throws ExceptionValidacaoDados, ExceptionIO {
        ConfigServicosTerceiros config = this.serviceConfig.get(EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA);
        if (config == null) {
            throw new ExceptionValidacaoDados("E.ERP.0094.100", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        WebReceitaConfig webConfig = ((HelperWebReceitaAgronomica)Context.get(HelperWebReceitaAgronomica.class)).build(config).getConfigWebReceita();
        LinkedList ret = new LinkedList();
        switch (webConfig.getVersao()) {
            case "v1": {
                return this.consultaRelacaoCultura(((HelperWebReceitaAgronomica)Context.get(HelperWebReceitaAgronomica.class)).build(config).getConfigWebReceita(), idProduto);
            }
            case "v2": {
                return this.consultaRelacaoCulturasV2(webConfig, idProduto);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    private List<TempCulturas> consultaRelacaoCultura(WebReceitaConfig config, String idProduto) throws ExceptionValidacaoDados, ExceptionIO {
        if (!ToolMethods.isStrWithData((String)idProduto)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.108", new Object[]{"Produto informado nao foi sincronizado"});
        }
        WebReceitaCultura webService = new WebReceitaCultura();
        List relacoes = webService.getCulturas(config, idProduto);
        LinkedList<TempCulturas> culturas = new LinkedList<TempCulturas>();
        for (DTOConsultaCulturaProdResult.Cultura r : relacoes) {
            TempCulturas t = new TempCulturas();
            t.setIdCultura(r.getIdCultura());
            t.setNomeCientifico(r.getNomeComum());
            t.setNomeComum(r.getNomeComum());
            culturas.add(t);
        }
        return culturas;
    }

    private List<TempCulturas> consultaRelacaoCulturasV2(WebReceitaConfig config, String idProduto) throws ExceptionValidacaoDados, ExceptionIO {
        if (!ToolMethods.isStrWithData((String)idProduto)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.108", new Object[]{"Produto informado nao foi sincronizado"});
        }
        WebReceitaRelacaoV2 webService = new WebReceitaRelacaoV2();
        DTOConsultaRelCulturaV2 relacoes = webService.getCulturas(config, idProduto);
        LinkedList<TempCulturas> culturas = new LinkedList<TempCulturas>();
        for (DTOConsultaRelCulturaV2.Results r : relacoes.getResults()) {
            TempCulturas t = new TempCulturas();
            t.setIdCultura(r.getId());
            t.setNomeCientifico(r.getCultura().getNomeCientifico());
            t.setNomeComum(r.getCultura().getNome());
            culturas.add(t);
        }
        return culturas;
    }

    private void consultaCulturasV1(WebReceitaConfig webConfig, List<Cultura> ret) throws ExceptionValidacaoDados, ExceptionIO {
        DTOCulturaResult res = new WebReceitaCultura().getCulturas(webConfig);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: ND"});
        }
        List resV1 = res.getCultura();
        for (RecAgroCulturasRes cult : resV1) {
            Cultura cultura = this.serviceCultura.getByCodSincronizacao(cult.getIdCultura().toString(), EnumConstProvedorRecAgro.WEB_RECEITA);
            if (cultura == null) {
                cultura = new Cultura();
                cultura.setDataCadastro(new Date());
                cultura.setCodProvServicoRec(Short.valueOf(EnumConstProvedorRecAgro.WEB_RECEITA.getValue()));
            }
            cultura.setCodSincronizacao(String.valueOf(cult.getIdCultura()));
            cultura.setNome(cult.getNomeComum());
            cultura.setNomeCientifico(cult.getNomeCientifico());
            ret.add(cultura);
        }
    }

    private void consultaCulturasV2(WebReceitaConfig webConfig, List<Cultura> ret) throws ExceptionIO, ExceptionValidacaoDados {
        List resV2 = new WebReceitaCulturasV2().getCulturas(webConfig);
        for (RecAgroCulturasRes cult : resV2) {
            Cultura cultura = this.serviceCultura.getByCodSincronizacao(cult.getIdCultura().toString(), EnumConstProvedorRecAgro.WEB_RECEITA);
            if (cultura == null) {
                cultura = new Cultura();
                cultura.setDataCadastro(new Date());
                cultura.setCodProvServicoRec(Short.valueOf(EnumConstProvedorRecAgro.WEB_RECEITA.getValue()));
            }
            cultura.setCodSincronizacao(String.valueOf(cult.getIdCultura()));
            cultura.setNome(cult.getNomeComum());
            cultura.setNomeCientifico(cult.getNomeCientifico());
            ret.add(cultura);
        }
    }
}

