/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.pragasalvos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.vo.PragaAlvo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.pragasalvos.WebReceitaPragasAlvos;
import com.touchcomp.basementorclientwebservices.webreceita.v1.pragasalvos.model.DTOPragaAlvo;
import com.touchcomp.basementorclientwebservices.webreceita.v2.alvos.WebReceitaPragasAlvosV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.alvos.model.DTOPragaAlvoV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.service.impl.pragaalvo.ServicePragaAlvoImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaPragaAlvosImpl
extends WebReceitaCliBase {
    @Autowired
    private ServicePragaAlvoImpl service;

    public List<PragaAlvo> sincronizarPragasAlvos() throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        LinkedList<PragaAlvo> ret = new LinkedList<PragaAlvo>();
        switch (webConfig.getVersao()) {
            case "v1": {
                this.consultaPragasAlvosV1(webConfig, ret);
                break;
            }
            case "v2": {
                this.consultaPragasAlvosV2(webConfig, ret);
                break;
            }
            default: {
                throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
        }
        return ret;
    }

    public DTOPragaAlvo sincronizarPragasDTO(WebReceitaConfig config) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaPragasAlvos webService = new WebReceitaPragasAlvos();
        DTOPragaAlvo pragas = webService.getPragasAlvos(config);
        return pragas;
    }

    private void consultaPragasAlvosV1(WebReceitaConfig webConfig, List<PragaAlvo> ret) throws ExceptionValidacaoDados, ExceptionIO {
        DTOPragaAlvo res = new WebReceitaPragasAlvos().getPragasAlvos(webConfig);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: ND"});
        }
        for (DTOPragaAlvo.PragaAlvo cult : res.getAlvo()) {
            PragaAlvo pragaAlvo = this.service.getByCodSincronizacao(cult.getIdAlvo().toString(), EnumConstProvedorRecAgro.WEB_RECEITA);
            if (pragaAlvo == null) {
                pragaAlvo = new PragaAlvo();
                pragaAlvo.setDataCadastro(new Date());
                pragaAlvo.setCodProvServicoRec(Short.valueOf(EnumConstProvedorRecAgro.WEB_RECEITA.getValue()));
            }
            pragaAlvo.setCodSincronizacao(String.valueOf(cult.getIdAlvo()));
            pragaAlvo.setNome(cult.getNomeComum());
            pragaAlvo.setNomeCientifico(cult.getNomeCientifico());
            ret.add(pragaAlvo);
        }
    }

    private void consultaPragasAlvosV2(WebReceitaConfig webConfig, List<PragaAlvo> ret) throws ExceptionIO, ExceptionValidacaoDados {
        List pragasAlvos = new WebReceitaPragasAlvosV2().getPragasAlvos(webConfig);
        for (DTOPragaAlvoV2 cult : pragasAlvos) {
            PragaAlvo pragaAlvo = this.service.getByCodSincronizacao(cult.getIdAlvo().toString(), EnumConstProvedorRecAgro.WEB_RECEITA);
            if (pragaAlvo == null) {
                pragaAlvo = new PragaAlvo();
                pragaAlvo.setDataCadastro(new Date());
                pragaAlvo.setCodProvServicoRec(Short.valueOf(EnumConstProvedorRecAgro.WEB_RECEITA.getValue()));
            }
            pragaAlvo.setCodSincronizacao(String.valueOf(cult.getIdAlvo()));
            pragaAlvo.setNome(cult.getNomeComum());
            pragaAlvo.setNomeCientifico(cult.getNomeCientifico());
            ret.add(pragaAlvo);
        }
    }
}

