/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.produtor;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TalhaoPropriedade;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.WebReceitaProdutor;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.model.DTOProdutorRural;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.model.DTOProdutorRuralResult;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.WebReceitaOutrosV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOConsultaCidadeResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.WebReceitaProdutorV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResConsultaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralConsV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralEndResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralEndV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOTalhaoProdRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOTalhaoProdRuralV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperWebReceitaAgronomica;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.talhaopropriedade.ServiceTalhaoPropriedadeImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaProdutorRuralImpl
extends WebReceitaCliBase {
    @Autowired
    private ServiceUnidadeFatClienteImpl service;
    @Autowired
    private ServiceClienteImpl serviceCliente;
    @Autowired
    private ServiceTalhaoPropriedadeImpl serviceTalhaoPropriedade;
    @Autowired
    private ServiceConfigServicosTerceirosImpl serviceConfig;

    public UnidadeFatCliente sincronizarProdutor(UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        switch (webConfig.getVersao()) {
            case "v1": {
                return this.sincronizarProdutorV1(webConfig, unidadeFatCliente, empresa);
            }
            case "v2": {
                return this.sincronizarProdutorV2(webConfig, unidadeFatCliente, empresa);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    private UnidadeFatCliente sincronizarProdutorV1(WebReceitaConfig webConfig, UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionValidacaoDados, ExceptionIO {
        String telefone;
        if (unidadeFatCliente.getDataAtualizacaoSevTerc() != null && (unidadeFatCliente.getDataAtualizacaoSevTerc().equals(unidadeFatCliente.getDataAtualizacao()) || unidadeFatCliente.getDataAtualizacaoSevTerc().after(unidadeFatCliente.getDataAtualizacao()))) {
            return unidadeFatCliente;
        }
        Pessoa pes = unidadeFatCliente.getPessoa();
        DTOProdutorRural prod = new DTOProdutorRural();
        prod.setCpfCnpj(ToolString.onlyNumbers((String)pes.getComplemento().getCnpj()));
        prod.setDataCadastro(pes.getDataCadastro());
        prod.setDataAtualizacao((Date)unidadeFatCliente.getDataAtualizacao());
        prod.setEndereco(pes.getEndereco().getLogradouro());
        if (prod.getEndereco() != null && prod.getEndereco().length() > 60) {
            prod.setEndereco(prod.getEndereco().substring(0, 60));
        }
        prod.setLocalAplicacao(unidadeFatCliente.getIdentificador().toString());
        prod.setNome(pes.getNome());
        if (prod.getNome() != null && prod.getNome().length() > 60) {
            prod.setNome(prod.getNome().substring(0, 60));
        }
        if (!ToolMethods.isStrWithData((String)(telefone = ((HelperPessoa)Context.get(HelperPessoa.class)).build(pes).getTelefonePrincipal()))) {
            telefone = ((HelperPessoa)Context.get(HelperPessoa.class)).build(unidadeFatCliente.getCliente().getPessoa()).getTelefonePrincipal();
        }
        prod.setTelefone(telefone);
        String unidRecebimento = "";
        unidRecebimento = ToolMethods.isStrWithData((String)empresa.getPessoa().getNomeFantasia()) ? empresa.getPessoa().getNomeFantasia() : empresa.getPessoa().getNome();
        prod.setUnidRecebimento(unidRecebimento);
        if (prod.getUnidRecebimento() != null && prod.getUnidRecebimento().length() > 30) {
            prod.setUnidRecebimento(prod.getUnidRecebimento().substring(0, 30));
        }
        DTOProdutorRural.Municipio mun = new DTOProdutorRural.Municipio();
        mun.setIbge(Integer.valueOf(pes.getEndereco().getCidade().getCodIbgeCompleto()));
        prod.setMunicipio(mun);
        DTOProdutorRuralResult res = new WebReceitaProdutor().inserirProdutor(webConfig, prod);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: " + ToolJson.toJson((Object)prod)});
        }
        unidadeFatCliente.setCodigoSincronizacao(String.valueOf(res.getSucesso().getIdProdutorRural()));
        return this.service.saveOrUpdate(unidadeFatCliente);
    }

    private UnidadeFatCliente sincronizarProdutorV2(WebReceitaConfig webConfig, UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        unidadeFatCliente.setCliente(this.cadastrarProdutorV2(webConfig, unidadeFatCliente, empresa));
        unidadeFatCliente = this.cadastrarPropriedadeV2(webConfig, unidadeFatCliente, empresa);
        unidadeFatCliente = this.cadastrarTalhoesV2(webConfig, unidadeFatCliente, empresa);
        unidadeFatCliente.setCliente(this.enviarEnderecoV2(webConfig, unidadeFatCliente.getCliente()));
        return this.service.saveOrUpdate(unidadeFatCliente);
    }

    private Cliente cadastrarProdutorV2(WebReceitaConfig webConfig, UnidadeFatCliente unid, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        Cliente cliente = unid.getCliente();
        if (cliente.getDataAtualizacaoSevTerc() != null && (cliente.getDataAtualizacaoSevTerc().equals(cliente.getDataAtualizacao()) || cliente.getDataAtualizacaoSevTerc().after(cliente.getDataAtualizacao()))) {
            return cliente;
        }
        if (ToolMethods.isStrWithData((String)cliente.getCodigoSincronizacao())) {
            return this.atualizarProdutor(webConfig, unid);
        }
        DTOProdutorRuralV2 dto = new DTOProdutorRuralV2();
        dto.setAtivo(Boolean.valueOf(ToolMethods.isAffirmative((Number)cliente.getPessoa().getAtivo())));
        dto.setInscricao(unid.getPessoa().getComplemento().getCnpj());
        if (ToolMethods.isStrWithData((String)unid.getPessoa().getComplemento().getInscEst())) {
            dto.setInscricaoProdutor(unid.getPessoa().getComplemento().getInscEst());
        } else {
            dto.setInscricaoProdutor(unid.getPessoa().getComplemento().getCnpj());
        }
        dto.setNome(cliente.getPessoa().getNome());
        dto.setObservacoes(ToolMethods.emptyIfNull((String)cliente.getPessoa().getObservacao()));
        DTOProdutorRuralResV2 v2 = new WebReceitaProdutorV2().cadastrarProdutor(webConfig, dto);
        cliente.setCodigoSincronizacao(String.valueOf(v2.getId()));
        cliente.setDataAtualizacaoSevTerc(new Date());
        return this.serviceCliente.saveOrUpdate(cliente);
    }

    private UnidadeFatCliente cadastrarPropriedadeV2(WebReceitaConfig webConfig, UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        if (unidadeFatCliente.getDataAtualizacaoSevTerc() != null && (unidadeFatCliente.getDataAtualizacaoSevTerc().equals(unidadeFatCliente.getDataAtualizacao()) || unidadeFatCliente.getDataAtualizacaoSevTerc().after(unidadeFatCliente.getDataAtualizacao()))) {
            return unidadeFatCliente;
        }
        if (!ToolMethods.isStrWithData((String)unidadeFatCliente.getCodigoSincronizacao())) {
            DTOPropriedadeProdRuralV2 dto = new DTOPropriedadeProdRuralV2();
            dto.setEnderecoEntregaEmbalagens("");
            dto.setIdProdutor(Long.valueOf(unidadeFatCliente.getCliente().getCodigoSincronizacao()));
            dto.setInscricao(unidadeFatCliente.getPessoa().getComplemento().getInscEst());
            if (ToolMethods.isStrWithData((String)unidadeFatCliente.getPessoa().getNomeFantasia())) {
                dto.setNomeFazenda(unidadeFatCliente.getPessoa().getNomeFantasia());
            } else {
                dto.setNomeFazenda(unidadeFatCliente.getPessoa().getNome());
            }
            DTOPropriedadeProdRuralResV2 v2 = new WebReceitaProdutorV2().cadastrarPropriedade(webConfig, dto);
            unidadeFatCliente.setCodigoSincronizacao(v2.getId().toString());
        } else {
            unidadeFatCliente = this.atualizarPropriedadeV2(webConfig, unidadeFatCliente);
        }
        unidadeFatCliente = this.service.saveOrUpdate(unidadeFatCliente);
        this.enviarEnderecoPropriedadeV2(webConfig, unidadeFatCliente);
        unidadeFatCliente.setDataAtualizacaoSevTerc(new Date());
        return this.service.saveOrUpdate(unidadeFatCliente);
    }

    public UnidadeFatCliente consultarProdutor(UnidadeFatCliente unidade) throws ExceptionValidacaoDados, ExceptionIO {
        String inscricao;
        ConfigServicosTerceiros config = this.serviceConfig.get(EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA);
        if (config == null) {
            throw new ExceptionValidacaoDados("E.ERP.0094.100", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        WebReceitaConfig webConfig = ((HelperWebReceitaAgronomica)Context.get(HelperWebReceitaAgronomica.class)).build(config).getConfigWebReceita();
        DTOProdutorRuralResConsultaV2 v2 = new WebReceitaProdutorV2().consultarProdutor(webConfig, inscricao = unidade.getCliente().getPessoa().getComplemento().getCnpj());
        if (v2.getResults() == null || v2.getResults().isEmpty()) {
            return null;
        }
        DTOProdutorRuralResConsultaV2.Cliente found = (DTOProdutorRuralResConsultaV2.Cliente)v2.getResults().get(0);
        unidade.getCliente().setCodigoSincronizacao(String.valueOf(found.getId()));
        Cliente c = this.serviceCliente.saveOrUpdate(unidade.getCliente());
        unidade.setCliente(c);
        unidade = this.consultarPropriedade(webConfig, unidade);
        return unidade;
    }

    private UnidadeFatCliente atualizarPropriedadeV2(WebReceitaConfig webConfig, UnidadeFatCliente unidadeFatCliente) throws ExceptionIO, ExceptionValidacaoDados {
        DTOPropriedadeProdRuralV2 dto = new DTOPropriedadeProdRuralV2();
        dto.setEnderecoEntregaEmbalagens("");
        dto.setIdProdutor(Long.valueOf(unidadeFatCliente.getCliente().getCodigoSincronizacao()));
        dto.setInscricao(unidadeFatCliente.getPessoa().getComplemento().getInscEst());
        if (ToolMethods.isStrWithData((String)unidadeFatCliente.getPessoa().getNomeFantasia())) {
            dto.setNomeFazenda(unidadeFatCliente.getPessoa().getNomeFantasia());
        } else {
            dto.setNomeFazenda(unidadeFatCliente.getPessoa().getNome());
        }
        DTOPropriedadeProdRuralResV2 v2 = new WebReceitaProdutorV2().atualizarPropriedadeProd(webConfig, unidadeFatCliente.getCodigoSincronizacao(), dto);
        unidadeFatCliente.setCodigoSincronizacao(v2.getId().toString());
        return unidadeFatCliente;
    }

    private Cliente atualizarProdutor(WebReceitaConfig webConfig, UnidadeFatCliente unid) throws ExceptionIO, ExceptionValidacaoDados {
        Cliente cliente = unid.getCliente();
        DTOProdutorRuralUpdateV2 dto = new DTOProdutorRuralUpdateV2();
        dto.setAtivo(Boolean.valueOf(ToolMethods.isAffirmative((Number)cliente.getPessoa().getAtivo())));
        dto.setInscricao(unid.getPessoa().getComplemento().getCnpj());
        if (ToolMethods.isStrWithData((String)unid.getPessoa().getComplemento().getInscEst())) {
            dto.setInscricaoProdutor(unid.getPessoa().getComplemento().getInscEst());
        } else {
            dto.setInscricaoProdutor(unid.getPessoa().getComplemento().getCnpj());
        }
        dto.setNome(cliente.getPessoa().getNome());
        dto.setId(Long.valueOf(cliente.getCodigoSincronizacao()));
        dto.setObservacoes(ToolMethods.emptyIfNull((String)cliente.getPessoa().getObservacao()));
        DTOProdutorRuralResUpdateV2 v2 = new WebReceitaProdutorV2().atualizarProdutor(webConfig, dto);
        cliente.setCodigoSincronizacao(String.valueOf(v2.getId()));
        cliente.setDataAtualizacaoSevTerc(new Date());
        return this.serviceCliente.saveOrUpdate(cliente);
    }

    private UnidadeFatCliente cadastrarTalhoesV2(WebReceitaConfig webConfig, UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        if (!unidadeFatCliente.getTalhoes().isEmpty()) {
            LinkedList<TalhaoPropriedade> aux = new LinkedList<TalhaoPropriedade>();
            for (TalhaoPropriedade t : unidadeFatCliente.getTalhoes()) {
                aux.add(this.cadastrarTalhoesV2(webConfig, t, empresa));
            }
            unidadeFatCliente.setTalhoes(aux);
        } else {
            TalhaoPropriedade t = new TalhaoPropriedade();
            t.setDescricao("TALHAO UNICO");
            t.setUnidadeFatCliente(unidadeFatCliente);
            t = this.cadastrarTalhoesV2(webConfig, t, empresa);
            unidadeFatCliente.getTalhoes().add(t);
        }
        return this.service.saveOrUpdate(unidadeFatCliente);
    }

    private TalhaoPropriedade cadastrarTalhoesV2(WebReceitaConfig webConfig, TalhaoPropriedade t, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        if (t.getDataAtualizacaoSevTerc() != null && (t.getDataAtualizacaoSevTerc().equals(t.getDataAtualizacao()) || t.getDataAtualizacaoSevTerc().after(t.getDataAtualizacao()))) {
            return t;
        }
        if (ToolMethods.isStrWithData((String)t.getCodigoSincronizacao())) {
            DTOTalhaoProdRuralV2 dto = new DTOTalhaoProdRuralV2();
            dto.setArea(t.getArea().toString());
            dto.setIdentificacao(t.getDescricao());
            dto.setPropriedade(Long.valueOf(t.getUnidadeFatCliente().getCodigoSincronizacao()));
            DTOTalhaoProdRuralResV2 v2 = new WebReceitaProdutorV2().atualizarTalhao(webConfig, t.getCodigoSincronizacao(), dto);
            t.setCodigoSincronizacao(String.valueOf(v2.getId()));
        } else {
            DTOTalhaoProdRuralV2 dto = new DTOTalhaoProdRuralV2();
            dto.setArea(t.getArea().toString());
            dto.setIdentificacao(t.getDescricao());
            dto.setPropriedade(Long.valueOf(t.getUnidadeFatCliente().getCodigoSincronizacao()));
            DTOTalhaoProdRuralResV2 v2 = new WebReceitaProdutorV2().cadastrarTalhao(webConfig, dto);
            t.setCodigoSincronizacao(String.valueOf(v2.getId()));
        }
        t.setDataAtualizacaoSevTerc(new Date());
        return this.serviceTalhaoPropriedade.saveOrUpdate(t);
    }

    private Cliente enviarEnderecoV2(WebReceitaConfig webConfig, Cliente cliente) throws ExceptionIO, ExceptionValidacaoDados {
        Pessoa pessoa = cliente.getPessoa();
        Endereco e = cliente.getPessoa().getEndereco();
        Date dataAtualizacaoSisTerc = cliente.getDataAtualizacaoSevTerc();
        DTOConsultaCidadeResV2 cid = new WebReceitaOutrosV2().getCidade(webConfig, e.getCidade().getCodIbgeCompleto());
        if (cid == null || cid.getResults() == null || cid.getResults().isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.0094.104", new Object[]{e.getCidade()});
        }
        DTOConsultaCidadeResV2.Cidade c = (DTOConsultaCidadeResV2.Cidade)cid.getResults().get(0);
        if (ToolMethods.isStrWithData((String)cliente.getCodigoSincronizacao2()) && dataAtualizacaoSisTerc != null && (dataAtualizacaoSisTerc.equals(e.getDataAtualizacao()) || dataAtualizacaoSisTerc.after(e.getDataAtualizacao()))) {
            return cliente;
        }
        if (ToolMethods.isStrWithData((String)cliente.getCodigoSincronizacao2())) {
            DTOEnderecoV2 end = new DTOEnderecoV2();
            end.setBairro(ToolMethods.emptyIfNull((String)e.getBairro()));
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdAgentePessoa(Long.valueOf(cliente.getCodigoSincronizacao()));
            end.setLocalidade(ToolMethods.emptyIfNull((String)e.getObservacao()));
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOEnderecoResV2 res = new WebReceitaOutrosV2().atualizarEndereco(webConfig, cliente.getCodigoSincronizacao2(), end);
            cliente.setCodigoSincronizacao2(String.valueOf(res.getId()));
        } else {
            DTOEnderecoV2 end = new DTOEnderecoV2();
            end.setBairro(ToolMethods.emptyIfNull((String)e.getBairro()));
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdAgentePessoa(Long.valueOf(cliente.getCodigoSincronizacao()));
            end.setLocalidade(ToolMethods.emptyIfNull((String)e.getObservacao()));
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOEnderecoResV2 res = new WebReceitaOutrosV2().cadastrarEndereco(webConfig, end);
            cliente.setCodigoSincronizacao2(String.valueOf(res.getId()));
        }
        cliente = this.serviceCliente.saveOrUpdate(cliente);
        return cliente;
    }

    private Pessoa enviarEnderecoPropriedadeV2(WebReceitaConfig webConfig, UnidadeFatCliente unidade) throws ExceptionIO, ExceptionValidacaoDados {
        String codSincronizacaoPessoa = unidade.getCodigoSincronizacao();
        Pessoa pessoa = unidade.getPessoa();
        Endereco e = pessoa.getEndereco();
        DTOConsultaCidadeResV2 cid = new WebReceitaOutrosV2().getCidade(webConfig, e.getCidade().getCodIbgeCompleto());
        if (cid == null || cid.getResults() == null || cid.getResults().isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.0094.104", new Object[]{e.getCidade()});
        }
        DTOConsultaCidadeResV2.Cidade c = (DTOConsultaCidadeResV2.Cidade)cid.getResults().get(0);
        if (ToolMethods.isStrWithData((String)unidade.getCodigoSincronizacao2()) && unidade.getDataAtualizacaoSevTerc() != null && (unidade.getDataAtualizacaoSevTerc().equals(e.getDataAtualizacao()) || unidade.getDataAtualizacaoSevTerc().after(e.getDataAtualizacao()))) {
            return pessoa;
        }
        if (ToolMethods.isStrWithData((String)unidade.getCodigoSincronizacao2())) {
            DTOPropriedadeProdRuralEndV2 end = new DTOPropriedadeProdRuralEndV2();
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdPropriedade(Long.valueOf(codSincronizacaoPessoa));
            end.setTipo("CAD");
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOPropriedadeProdRuralEndResV2 res = new WebReceitaProdutorV2().atualizarEnderecoPropriedade(webConfig, unidade.getCodigoSincronizacao2(), end);
            unidade.setCodigoSincronizacao2(String.valueOf(res.getId()));
        } else {
            DTOPropriedadeProdRuralEndV2 end = new DTOPropriedadeProdRuralEndV2();
            end.setCep(ToolMethods.emptyIfNull((String)e.getCep()));
            end.setCidade(c.getId());
            end.setTipo("CAD");
            end.setComplemento(ToolMethods.emptyIfNull((String)e.getComplemento()));
            end.setEndereco(ToolMethods.emptyIfNull((String)e.getLogradouro()));
            end.setIdPropriedade(Long.valueOf(codSincronizacaoPessoa));
            end.setNumero(ToolMethods.emptyIfNull((String)e.getNumero()));
            end.setLatitude("");
            end.setLongitude("");
            DTOPropriedadeProdRuralEndResV2 res = new WebReceitaProdutorV2().cadastrarEnderecoPropriedade(webConfig, end);
            unidade.setCodigoSincronizacao2(String.valueOf(res.getId()));
        }
        return pessoa;
    }

    private UnidadeFatCliente consultarPropriedade(WebReceitaConfig webConfig, UnidadeFatCliente unidade) throws ExceptionIO {
        DTOPropriedadeProdRuralConsV2 ret = new WebReceitaProdutorV2().consultarPropriedade(webConfig, unidade.getCliente().getCodigoSincronizacao());
        if (ret.getResults() == null || ret.getResults().isEmpty()) {
            return unidade;
        }
        DTOPropriedadeProdRuralConsV2.Propriedade prop = (DTOPropriedadeProdRuralConsV2.Propriedade)ret.getResults().get(0);
        unidade.setCodigoSincronizacao(prop.getId().toString());
        if (prop.getEnderecoPropriedade() != null && prop.getEnderecoPropriedade().size() > 0) {
            DTOPropriedadeProdRuralConsV2.Endereco end = (DTOPropriedadeProdRuralConsV2.Endereco)prop.getEnderecoPropriedade().get(0);
            unidade.setCodigoSincronizacao2(end.getId().toString());
        }
        return this.service.saveOrUpdate(unidade);
    }
}

