/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.produtos;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroProdutoRes;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtos.WebReceitaProdutos;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtos.model.DTOProduto;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produto.WebReceitaProdutosV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.produtos.model.DTOIntegRepoProduto;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaProdutosImpl
extends WebReceitaCliBase {
    @Autowired
    private ServiceProdutoImpl service;

    public List<DTOIntegRepoProduto> sincronizarProdutos() throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig webConfig = this.getConf();
        LinkedList<DTOIntegRepoProduto> ret = new LinkedList<DTOIntegRepoProduto>();
        switch (webConfig.getVersao()) {
            case "v1": {
                this.sincronizarProdutosV1(webConfig, ret);
                break;
            }
            case "v2": {
                this.sincronizarProdutosV2(webConfig, ret);
                break;
            }
            default: {
                throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
        }
        return ret;
    }

    public DTOProduto sincronizarProdutosDTO(WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        WebReceitaProdutos webService = new WebReceitaProdutos();
        DTOProduto produtos = webService.getProdutos(config);
        return produtos;
    }

    private void sincronizarProdutosV1(WebReceitaConfig webConfig, List<DTOIntegRepoProduto> ret) throws ExceptionIO, ExceptionValidacaoDados {
        List dto = new WebReceitaProdutos().getProdutos(webConfig).getProduto();
        for (RecAgroProdutoRes produto : dto) {
            List<Produto> prods = this.service.getByCodSincronizacao(String.valueOf(produto.getIdProduto()), EnumConstProvedorRecAgro.WEB_RECEITA);
            DTOIntegRepoProduto aux = new DTOIntegRepoProduto();
            DTOIntegRepoProduto.DTOProduto prod = new DTOIntegRepoProduto.DTOProduto();
            prod.setAtivo(produto.getAtivo());
            prod.setIdProduto(produto.getIdProduto());
            prod.setProduto(produto.getProduto());
            prod.setRegistroMapa(produto.getRegistroMapa());
            aux.setRecAgroProduto(prod);
            aux.setProdutos(prods);
            ret.add(aux);
        }
    }

    private void sincronizarProdutosV2(WebReceitaConfig webConfig, List<DTOIntegRepoProduto> ret) throws ExceptionIO, ExceptionValidacaoDados {
        List dto = new WebReceitaProdutosV2().getProdutos(webConfig);
        List<Produto> produtos = this.service.getAllCodSincronizacao(EnumConstProvedorRecAgro.WEB_RECEITA);
        for (RecAgroProdutoRes produto : dto) {
            ArrayList<Produto> temp = new ArrayList<Produto>();
            for (Produto produto2 : produtos) {
                if (!ToolMethods.isEquals((Object)String.valueOf(produto.getIdProduto()), (Object)produto2.getCodSincronizacao())) continue;
                temp.add(produto2);
            }
            DTOIntegRepoProduto aux = new DTOIntegRepoProduto();
            DTOIntegRepoProduto.DTOProduto dTOProduto = new DTOIntegRepoProduto.DTOProduto();
            dTOProduto.setAtivo(produto.getAtivo());
            dTOProduto.setIdProduto(produto.getIdProduto());
            dTOProduto.setProduto(produto.getProduto());
            dTOProduto.setRegistroMapa(produto.getRegistroMapa());
            aux.setRecAgroProduto(dTOProduto);
            aux.setProdutos(temp);
            ret.add(aux);
        }
    }
}

