/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.integracoesterceiros.webreceita.receita;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstStatusReceitaAgro;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReceitaAgronomica;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ReceitaAgronomica;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.WebReceitaReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgro;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroEmissao;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroEmissaoResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroItem;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroItemResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroResultDelete;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.WebReceitaReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroItemResultV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroItemV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroResultV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.WebReceitaCliBase;
import com.touchcomp.basementorservice.integracoesterceiros.webreceita.produtor.CliWebReceitaProdutorRuralImpl;
import com.touchcomp.basementorservice.service.impl.receitaagronomica.ServiceItemReceitaAgronomicaImpl;
import com.touchcomp.basementorservice.service.impl.receitaagronomica.ServiceReceitaAgronomicaImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CliWebReceitaAgronomicaImpl
extends WebReceitaCliBase {
    @Autowired
    private ServiceReceitaAgronomicaImpl service;
    @Autowired
    private ServiceItemReceitaAgronomicaImpl serviceItem;
    @Autowired
    private CliWebReceitaProdutorRuralImpl clienteProdutor;

    public ReceitaAgronomica excluirReceita(ReceitaAgronomica vo) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig config = this.getConf();
        if (!ToolMethods.isStrWithData((String)vo.getCodSincronizacao())) {
            return vo;
        }
        switch (config.getVersao()) {
            case "v1": {
                return this.cancelarReceitaV1(config, vo);
            }
            case "v2": {
                return this.cancelarReceitaV2(config, vo);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    public ReceitaAgronomica emitirReceita(ReceitaAgronomica vo) throws ExceptionValidacaoDados, ExceptionIO {
        WebReceitaConfig conf = this.getConf();
        vo = this.gerarReceita(vo, conf);
        vo = this.emitirItens(vo, conf);
        vo = this.emitirFinalizarReceita(vo, conf);
        return vo;
    }

    private UnidadeFatCliente registrarCliente(UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionIO, ExceptionValidacaoDados {
        return this.clienteProdutor.sincronizarProdutor(unidadeFatCliente, empresa);
    }

    private ReceitaAgronomica gerarReceita(ReceitaAgronomica vo, WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        if (ToolMethods.isStrWithData((String)vo.getCodSincronizacao())) {
            return vo;
        }
        switch (config.getVersao()) {
            case "v1": {
                return this.emitirReceitaV1(config, vo);
            }
            case "v2": {
                return this.emitirReceitaV2(config, vo);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    public List<File> imprimirReceita(ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        WebReceitaConfig conf = this.getConf();
        if (!ToolMethods.isStrWithData((String)vo.getCodSincronizacao())) {
            return null;
        }
        switch (conf.getVersao()) {
            case "v1": {
                throw new ExceptionValidacaoDados("E.ERP.0094.102", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
            case "v2": {
                LinkedList<File> r = new LinkedList<File>();
                byte[] ret = new WebReceitaReceitaV2().imprimirReceita(conf, vo.getCodSincronizacao());
                File f = ToolFile.createTempFile((String)"receita", (String)".pdf");
                ToolFile.writeBytesOnFile((File)f, (byte[])ret);
                r.add(f);
                try {
                    byte[] ret2 = new WebReceitaReceitaV2().imprimirAnexos(conf, vo.getCodSincronizacao());
                    if (ret2 != null) {
                        File f2 = ToolFile.createTempFile((String)"anexos_receita", (String)".pdf");
                        ToolFile.writeBytesOnFile((File)f2, (byte[])ret2);
                        r.add(f2);
                    }
                }
                catch (Exception ex) {
                    TLogger.get(this.getClass()).error((Throwable)ex);
                }
                return r;
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    public File imprimirReceitaAssDigital(ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        WebReceitaConfig conf = this.getConf();
        if (!ToolMethods.isStrWithData((String)vo.getCodSincronizacao())) {
            return null;
        }
        switch (conf.getVersao()) {
            case "v1": {
                throw new ExceptionValidacaoDados("E.ERP.0094.102", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
            }
            case "v2": {
                byte[] ret = new WebReceitaReceitaV2().imprimirReceitaAssinada(conf, vo.getCodSincronizacao());
                File f = ToolFile.createTempFile((String)"receita", (String)".pdf");
                ToolFile.writeBytesOnFile((File)f, (byte[])ret);
                return f;
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    private ReceitaAgronomica emitirItens(ReceitaAgronomica vo, WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        LinkedList<ItemReceitaAgronomica> itens = new LinkedList<ItemReceitaAgronomica>();
        block8: for (ItemReceitaAgronomica item : vo.getItemReceitaAgronomica()) {
            if (!ToolMethods.isStrWithData((String)vo.getCodSincronizacao())) {
                return vo;
            }
            switch (config.getVersao()) {
                case "v1": {
                    this.emitirItemReceitaV1(config, vo, item, itens);
                    continue block8;
                }
                case "v2": {
                    this.emitirItemReceitaV2(config, vo, item, itens);
                    continue block8;
                }
            }
            throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        vo.setItemReceitaAgronomica(itens);
        return vo;
    }

    public ReceitaAgronomica consultarReceita(ReceitaAgronomica receita) throws ExceptionIO, ExceptionValidacaoDados {
        WebReceitaConfig conf = this.getConf();
        switch (conf.getVersao()) {
            case "v1": {
                return this.consultarReceitaV1(conf, receita);
            }
            case "v2": {
                return this.consultarReceitaV2(conf, receita);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    private ReceitaAgronomica consultarReceitaV1(WebReceitaConfig conf, ReceitaAgronomica receita) throws ExceptionIO, ExceptionValidacaoDados {
        DTOReceitaAgroEmissaoResult res = new WebReceitaReceita().consultarReceita(conf, receita.getCodSincronizacao());
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.throwError(res, null);
        }
        return this.setAndSaveReceita(receita, res);
    }

    private ReceitaAgronomica consultarReceitaV2(WebReceitaConfig conf, ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        DTOReceitaAgroResultV2 res = new WebReceitaReceitaV2().consultarReceita(conf, vo.getCodSincronizacao());
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.throwError(res, null);
        }
        vo.setCodSincronizacao(String.valueOf(res.getId()));
        return this.service.saveOrUpdate(vo);
    }

    private ReceitaAgronomica emitirFinalizarReceita(ReceitaAgronomica vo, WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        switch (config.getVersao()) {
            case "v1": {
                return this.emitirFinalizarReceitaV1(config, vo);
            }
            case "v2": {
                return this.emitirFinalizarReceitaV2(config, vo);
            }
        }
        throw new ExceptionValidacaoDados("E.ERP.0094.101", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
    }

    private void throwError(Object rec, Object send) throws ExceptionValidacaoDados, ExceptionIO {
        throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{"Retorno: " + ToolJson.toJson((Object)rec) + "Enviado: " + (send != null ? ToolJson.toJson((Object)send) : "ND")});
    }

    private ReceitaAgronomica setAndSaveReceita(ReceitaAgronomica vo, DTOReceitaAgroEmissaoResult res) {
        vo.setNrReceita(res.getUltimaReceitaEmitida());
        vo.setNrARTVinculada(res.getArtVinculada());
        vo.setStatus(Short.valueOf(EnumConstStatusReceitaAgro.EMITIDA.getValue()));
        return this.service.saveOrUpdate(vo);
    }

    private ReceitaAgronomica emitirReceitaV1(WebReceitaConfig config, ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        Pessoa pessoa = vo.getUnidadeFatCliente().getPessoa();
        DTOReceitaAgro rec = new DTOReceitaAgro();
        rec.setDataAtualizacao((Date)vo.getDataAtualizacao());
        rec.setDataCadastro(vo.getDataCadastro());
        if (pessoa.getLatitude() != null && pessoa.getLatitude() > 0.0) {
            rec.setLatitude(String.valueOf(pessoa.getLatitude()));
        }
        if (pessoa.getLongitude() != null && pessoa.getLongitude() > 0.0) {
            rec.setLongitude(String.valueOf(pessoa.getLongitude()));
        }
        DTOReceitaAgro.Agronomo agro = new DTOReceitaAgro.Agronomo();
        agro.setIdAgronomo(Long.valueOf(vo.getTecnicoAgricola().getCodSincronizacao()));
        rec.setAgronomo(agro);
        DTOReceitaAgro.ProdutorRural prod = new DTOReceitaAgro.ProdutorRural();
        prod.setIdProdutorRural(Long.valueOf(vo.getUnidadeFatCliente().getCodigoSincronizacao()));
        rec.setProdutorRural(prod);
        DTOReceitaAgroResult res = new WebReceitaReceita().inserirReceita(config, rec);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.throwError(res, rec);
        }
        vo.setCodSincronizacao(String.valueOf(res.getSucesso().getIdReceita()));
        return this.service.saveOrUpdate(vo);
    }

    private ReceitaAgronomica emitirReceitaV2(WebReceitaConfig config, ReceitaAgronomica vo) throws ExceptionValidacaoDados, ExceptionIO {
        if (!ToolMethods.isStrWithData((String)vo.getTecnicoAgricola().getCodSincronizacao())) {
            throw new ExceptionValidacaoDados("E.ERP.0094.114", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        if (!ToolMethods.isStrWithData((String)vo.getTecnicoAgricART().getCodSincronizacao())) {
            throw new ExceptionValidacaoDados("E.ERP.0094.113", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        if (!ToolMethods.isStrWithData((String)vo.getTecnicoAgricCREA().getCodSincronizacao())) {
            throw new ExceptionValidacaoDados("E.ERP.0094.112", new Object[]{EnumConstConfigServicosTerceiros.WEB_RECEITA_AGRONOMICA.getChave()});
        }
        DTOReceitaAgroV2 rec = new DTOReceitaAgroV2();
        rec.setArt(Long.valueOf(vo.getTecnicoAgricART().getCodSincronizacao()));
        rec.setCrea(Long.valueOf(vo.getTecnicoAgricCREA().getCodSincronizacao()));
        rec.setData(vo.getDataCadastro());
        rec.setEmpresa(Long.valueOf(config.getCodEmpresa()));
        rec.setProdutor(Long.valueOf(vo.getUnidadeFatCliente().getCliente().getCodigoSincronizacao()));
        rec.setProfissional(Long.valueOf(vo.getTecnicoAgricola().getCodSincronizacao()));
        rec.setPropriedade(Long.valueOf(vo.getUnidadeFatCliente().getCodigoSincronizacao()));
        rec.setTalhao(Long.valueOf(vo.getTalhaoPropriedade().getCodigoSincronizacao()));
        if (config.getNumeroNfe() != null && !config.getNumeroNfe().isEmpty()) {
            rec.setNumero_nf(vo.getNotaPropria().getNumeroNota().toString());
            rec.setSerie_nf(vo.getNotaPropria().getSerie());
        }
        DTOReceitaAgroResultV2 res = new WebReceitaReceitaV2().inserirReceita(config, rec);
        vo.setNrReceita(res.getNumero());
        vo.setCodSincronizacao(String.valueOf(res.getId()));
        return this.service.saveOrUpdate(vo);
    }

    private void emitirItemReceitaV1(WebReceitaConfig config, ReceitaAgronomica vo, ItemReceitaAgronomica item, List<ItemReceitaAgronomica> itens) throws ExceptionIO, ExceptionValidacaoDados {
        if (!ToolMethods.isStrWithData((String)item.getCodigoSincronizacao())) {
            DTOReceitaAgroItem it = new DTOReceitaAgroItem();
            it.setAreaAplicacao(item.getAreaAplicacao());
            DTOReceitaAgroItem.Cultura cult = new DTOReceitaAgroItem.Cultura();
            cult.setIdCultura(item.getCultura().getIdentificador());
            it.setCultura(cult);
            it.setDataAtualizacao((Date)vo.getDataAtualizacao());
            it.setDataCadastro(vo.getDataCadastro());
            it.setDescEquipamentoAplicacao(item.getDescEquipamentoAplicacao());
            it.setDescModoAplicacao(item.getDescModoAplicacao());
            it.setDescRecomendacoes(item.getDescRecomendacoes());
            it.setDose(item.getDose());
            it.setNAplicacoes(item.getNrAplicacoes());
            it.setObs(item.getObservacao());
            DTOReceitaAgroItem.LocalAplicacao localAplicacao = new DTOReceitaAgroItem.LocalAplicacao();
            localAplicacao.setIdLocalAplicacao(Long.valueOf(item.getLocalAplicacaoRecAgro().getCodigoSincronizacao()));
            it.setLocalAplicacao(localAplicacao);
            DTOReceitaAgroItem.Praga praga = new DTOReceitaAgroItem.Praga();
            praga.setIdPragas(Long.valueOf(item.getPragaAlvo().getCodSincronizacao()));
            it.setPraga(praga);
            DTOReceitaAgroItem.Produto produto = new DTOReceitaAgroItem.Produto();
            produto.setIdProduto(Long.valueOf(item.getProduto().getCodSincronizacao()));
            it.setProduto(produto);
            it.setQtdeAdquirir(item.getQuantidadeVendida());
            DTOReceitaAgroItem.Receita receita = new DTOReceitaAgroItem.Receita();
            receita.setIdReceita(Long.valueOf(vo.getCodSincronizacao()));
            it.setReceita(receita);
            it.setVolumeCalda(item.getVolumeCalda());
            DTOReceitaAgroItemResult res = new WebReceitaReceita().inserirItemReceita(config, it);
            if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                this.throwError(res, it);
            }
            item.setCodigoSincronizacao(String.valueOf(res.getSucesso().getIdItemReceita()));
            item = this.serviceItem.saveOrUpdate(item);
            itens.add(item);
        } else {
            itens.add(item);
        }
    }

    private void emitirItemReceitaV2(WebReceitaConfig config, ReceitaAgronomica vo, ItemReceitaAgronomica item, List<ItemReceitaAgronomica> itens) throws ExceptionValidacaoDados, ExceptionIO {
        if (!ToolMethods.isStrWithData((String)item.getCodigoSincronizacao())) {
            DTOReceitaAgroItemV2 it = new DTOReceitaAgroItemV2();
            it.setArea(item.getAreaAplicacao());
            it.setCalda(item.getVolumeCalda());
            it.setDosagem(item.getAreaAplicacao());
            it.setEquipamentoAplicacao(item.getDescEquipamentoAplicacao());
            it.setIdReceita(Long.valueOf(vo.getCodSincronizacao()));
            it.setIdRelacao(item.getIdRelacao());
            it.setNumeroAplicacoes(item.getNrAplicacoes());
            it.setQuantidade(item.getQuantidadeVendida());
            it.setRecomendacoes(item.getRecomendacoesAdicionais());
            it.setModoAplicacao(item.getDescModoAplicacao());
            it.setPrecaucoesUso(item.getDescRecomendacoes());
            DTOReceitaAgroItemResultV2 res = new WebReceitaReceitaV2().inserirItemReceita(config, it);
            item.setCodigoSincronizacao(String.valueOf(res.getId()));
            item = this.serviceItem.saveOrUpdate(item);
            itens.add(item);
        } else {
            itens.add(item);
        }
    }

    private ReceitaAgronomica emitirFinalizarReceitaV1(WebReceitaConfig conf, ReceitaAgronomica vo) throws ExceptionValidacaoDados, ExceptionIO {
        DTOReceitaAgroEmissao emissao = new DTOReceitaAgroEmissao();
        emissao.setDataEmissao(vo.getDataEmissao());
        emissao.setIdReceita(vo.getCodSincronizacao());
        DTOReceitaAgroEmissaoResult res = new WebReceitaReceita().emitirReceita(conf, emissao);
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.throwError(res, null);
        }
        return this.setAndSaveReceita(vo, res);
    }

    private ReceitaAgronomica emitirFinalizarReceitaV2(WebReceitaConfig config, ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        new WebReceitaReceitaV2().emitirReceita(config, vo.getCodSincronizacao());
        vo.setStatus(Short.valueOf(EnumConstStatusReceitaAgro.EMITIDA.getValue()));
        return this.service.saveOrUpdate(vo);
    }

    private ReceitaAgronomica cancelarReceitaV1(WebReceitaConfig config, ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        DTOReceitaAgroResultDelete res = new WebReceitaReceita().excluirReceita(config, Long.valueOf(vo.getCodSincronizacao()));
        if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.throwError(res, null);
        }
        vo.setStatus(Short.valueOf(EnumConstStatusReceitaAgro.CANCELADA.getValue()));
        return this.service.saveOrUpdate(vo);
    }

    private ReceitaAgronomica cancelarReceitaV2(WebReceitaConfig config, ReceitaAgronomica vo) throws ExceptionIO, ExceptionValidacaoDados {
        new WebReceitaReceitaV2().cancelarReceita(config, vo.getCodSincronizacao());
        vo.setStatus(Short.valueOf(EnumConstStatusReceitaAgro.CANCELADA.getValue()));
        return this.service.saveOrUpdate(vo);
    }
}

