/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.model.genericmap;

import com.touchcomp.basementorservice.model.genericmap.GenericEnumInterface;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class GenericMapValues<T extends GenericEnumInterface> {
    private final TreeMap<T, Object> values = new TreeMap();

    public void addValue(T key, Object value) {
        this.values.put(key, value);
    }

    public String getString(T key) {
        String ret = (String)this.values.get(key);
        return ret != null ? ret : "";
    }

    public Double getDouble(T key) {
        Double res = (Double)this.values.get(key);
        return res != null ? res : 0.0;
    }

    public Date getDate(T key) {
        return (Date)this.values.get(key);
    }

    public Long getLong(T key) {
        Long ret = (Long)this.values.get(key);
        return ret != null ? ret : 0L;
    }

    public Integer getInteger(T key) {
        Integer ret = (Integer)this.values.get(key);
        return ret != null ? ret : 0;
    }

    public Short getShort(T key) {
        Short ret = (Short)this.values.get(key);
        return ret != null ? ret : (short)0;
    }

    public <S> S getObject(T key, Class<S> beanClass) {
        return (S)this.values.get(key);
    }

    public Object getObject(T key) {
        return this.values.get(key);
    }

    public List getList(T key) {
        List ret = (List)this.values.get(key);
        return ret != null ? ret : new LinkedList();
    }

    public GenericMapValues<T> putString(T key, String value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putDouble(T key, Double value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putDate(T key, Date value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putLong(T key, Long value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putInteger(T key, Integer value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putShort(T key, Short value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putObject(T key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public GenericMapValues<T> putList(T key, List data) {
        this.values.put(key, data);
        return this;
    }
}

