/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.model.task;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.model.task.TaskProcessResultDetalhe;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class TaskProcessResult {
    private String nome;
    private String observacao;
    private String infoTask;
    private List<TaskProcessResultDetalhe> detalhes = new LinkedList<TaskProcessResultDetalhe>();

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public List<TaskProcessResultDetalhe> getDetalhes() {
        return this.detalhes;
    }

    public List<TaskProcessResultDetalhe> getErrors() {
        return this.detalhes.stream().filter(i -> ToolMethods.isEquals((Object)i.getResult(), (Object)EnumConstantsTaskResult.RESULT_ERRO)).collect(Collectors.toList());
    }

    public List<TaskProcessResultDetalhe> getWarnings() {
        return this.detalhes.stream().filter(i -> ToolMethods.isEquals((Object)i.getResult(), (Object)EnumConstantsTaskResult.RESULT_ADVERTENCIA)).collect(Collectors.toList());
    }

    void setDetalhes(List<TaskProcessResultDetalhe> detalhes) {
        this.detalhes = detalhes;
    }

    public void addDet(EnumConstantsTaskResult result, String code, String str) {
        TaskProcessResultDetalhe det = new TaskProcessResultDetalhe(result);
        det.setCodigo(code);
        det.setObservacao(str);
        this.getDetalhes().add(det);
    }

    public void addDet(EnumConstantsTaskResult result, String str) {
        this.addDet(result, null, str);
    }

    public void addDet(EnumConstantsTaskResult result, String message, Object ... params) {
        this.addDet(result, null, ToolBaseMethodsVO.toString((String)message, (Object[])params));
    }

    public void addDetByCode(EnumConstantsTaskResult result, String code, Object ... adicional) {
        this.addDet(result, code, MessagesBaseMentor.getMsg((String)code, (Object[])adicional));
    }

    public void addError(String code, Object ... details) {
        this.addDet(EnumConstantsTaskResult.RESULT_ERRO, code, MessagesBaseMentor.getErrorMsg((String)code, (Object[])details));
    }

    public boolean hasErrorsOrWarnings() {
        return this.hasErrors() || this.hasWarnings();
    }

    public boolean hasErrors() {
        for (TaskProcessResultDetalhe taskProcessResultDetalhe : this.detalhes) {
            if (taskProcessResultDetalhe.getResult() != EnumConstantsTaskResult.RESULT_ERRO) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarnings() {
        for (TaskProcessResultDetalhe taskProcessResultDetalhe : this.detalhes) {
            if (taskProcessResultDetalhe.getResult() != EnumConstantsTaskResult.RESULT_ADVERTENCIA) continue;
            return true;
        }
        return false;
    }

    public String getStrErros() {
        StringBuilder sb = new StringBuilder();
        for (TaskProcessResultDetalhe det : this.getErrors()) {
            if (TMethods.isStrWithData((String)det.getCodigo())) {
                sb.append(det.getCodigo()).append(": ");
            }
            sb.append(det.getObservacao()).append("\n");
        }
        return sb.toString();
    }

    public String getStrDetalhes() {
        StringBuilder sb = new StringBuilder();
        for (TaskProcessResultDetalhe det : this.getDetalhes()) {
            if (TMethods.isStrWithData((String)det.getCodigo())) {
                sb.append(det.getCodigo()).append(": ");
            }
            sb.append(det.getObservacao()).append("\n");
        }
        return sb.toString();
    }

    public String getStrWarnings() {
        StringBuilder sb = new StringBuilder();
        for (TaskProcessResultDetalhe det : this.getWarnings()) {
            if (TMethods.isStrWithData((String)det.getCodigo())) {
                sb.append(det.getCodigo()).append(": ");
            }
            sb.append(det.getObservacao()).append("\n");
        }
        return sb.toString();
    }

    public String getStrAll() {
        String strDets;
        String strWarns;
        StringBuilder sb = new StringBuilder();
        String strErros = this.getStrErros();
        if (TMethods.isStrWithData((String)strErros)) {
            sb.append("Erros:").append("\n");
            sb.append(strErros);
        }
        if (TMethods.isStrWithData((String)(strWarns = this.getStrErros()))) {
            sb.append("Advertencias:").append("\n");
            sb.append(strWarns);
        }
        if (TMethods.isStrWithData((String)(strDets = this.getStrDetalhes()))) {
            sb.append("Detalhes:").append("\n");
            sb.append(strDets);
        }
        return sb.toString();
    }

    public String getInfoTask() {
        return this.infoTask;
    }

    public void setInfoTask(String infoTask) {
        this.infoTask = infoTask;
    }
}

