/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.crud.EnumConstCRUD;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqRascunhoRecurso;
import com.touchcomp.basementorbinary.service.impl.arq_rascunho_recurso.ServiceBinaryArqRascunhoRecurso;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.cache.CacheEntityManager;
import com.touchcomp.basementorservice.clones.InterfaceCloneEntity;
import com.touchcomp.basementorservice.dao.DAOGenericEntity;
import com.touchcomp.basementorservice.dtotransformer.DTOTransformer;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntity;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.converters.EntityDTOConverter;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementorvalidator.crud.ValidGenericCrud;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.DTOObjectInterface;
import com.touchcomp.touchvomodel.web.WebDTORascunho;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.LockMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(transactionManager="transactionManager")
public abstract class ServiceGenericEntityImpl<E extends InterfaceVO, K extends Serializable, DAO extends DAOGenericEntity<E, K>>
extends ServiceGenericImpl
implements ServiceGenericEntity<E, K> {
    protected DAO genericDao;
    private Class entityClass;
    @Autowired
    CacheEntityManager cacheEntityManager;
    @Autowired
    private EntityDTOConverter defaultEntityDTOConverter;
    @Autowired
    private ServiceBinaryArqRascunhoRecurso serviceBinaryArqRascunhoRecurso;

    public ServiceGenericEntityImpl(DAO genericDao) {
        this.genericDao = genericDao;
    }

    public DAO getGenericDao() {
        return this.genericDao;
    }

    public DAO getDao() {
        return this.genericDao;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public E saveOrUpdate(E entity) {
        entity = this.beforeSaveEntity(entity);
        entity = this.saveOrUpdateOnly(entity);
        entity = this.afterSaveEntity(entity);
        return entity;
    }

    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public E saveOrUpdateOnly(E entity) {
        return this.getGenericDao().saveOrUpdate(entity);
    }

    public <S extends InterfaceVO> S reload(S object) {
        this.genericDao.getSession().lock(object, LockMode.NONE);
        return object;
    }

    public void flushData() {
        this.getGenericDao().flushData();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public E saveOrUpdateFlush(E entity) {
        entity = this.beforeSaveEntity(entity);
        entity = this.getGenericDao().saveOrUpdate(entity);
        entity = this.afterSaveEntity(entity);
        return entity;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public TempSaveObj<E> saveOrUpdateValidate(E toSave, ValidGeneric<E> validator) {
        return this.saveOrUpdateValidate(toSave, validator, null);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public TempSaveObj<E> saveOrUpdateValidate(E toSave, ValidGeneric<E> validator, ValidGenericCrud<E> validatorCrud) {
        TempSaveObj<E> temp = this.validate(toSave, validator, validatorCrud);
        if (temp.getStatus().isErro()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
            return temp;
        }
        toSave = this.saveOrUpdate(toSave);
        temp.setResult(toSave);
        return temp;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public TempSaveObj<E> saveOrUpdateValidateFlush(E toSave, ValidGeneric<E> validator) {
        return this.saveOrUpdateValidateFlush(toSave, validator, null);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public TempSaveObj<E> validate(E toSave, ValidGeneric<E> validator) {
        TempSaveObj<E> temp = new TempSaveObj<E>();
        temp.setValidator(validator);
        this.beforeSave(toSave);
        validator.clearContainer();
        validator.isValidData(toSave);
        if (validator.hasErrors()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
        }
        return temp;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public TempSaveObj<E> validate(E toSave, ValidGeneric<E> validator, ValidGenericCrud<E> validatorCrud) {
        TempSaveObj<E> temp = this.validate(toSave, validator);
        if (temp.getStatus().isErro()) {
            return temp;
        }
        temp.setValidatorCrud(validatorCrud);
        if (validatorCrud == null) {
            return temp;
        }
        try {
            Number id = ToolReflections.getIdValueFromVOModel(toSave);
            EnumConstCRUD operation = EnumConstCRUD.INSERT;
            if (id != null && id instanceof Number && TMethods.isWithData((Number)id)) {
                operation = EnumConstCRUD.UPDATE;
            }
            validatorCrud.clearContainer();
            validatorCrud.isValidData(toSave, operation);
            if (validatorCrud.hasErrors()) {
                temp.setStatus(EnumConstantsMentorStatus.ERRO);
                return temp;
            }
        }
        catch (ExceptionReflection ex) {
            throw new ExceptionErroProgramacao("nao foi possivel identificar o ID da entidade/objeto " + String.valueOf(toSave.getClass()));
        }
        return temp;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public TempSaveObj<E> saveOrUpdateValidateFlush(E toSave, ValidGeneric<E> validator, ValidGenericCrud<E> validatorCrud) {
        TempSaveObj<E> temp = this.validate(toSave, validator);
        if (!validator.hasErrors()) {
            toSave = this.saveOrUpdateFlush(toSave);
        }
        temp.setResult(toSave);
        return temp;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public E cloneEntity(E entity, InterfaceCloneEntity<E> interfaceClone) throws ExceptionBase {
        return interfaceClone.cloneEntity(entity);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public E cloneEntity(K id, InterfaceCloneEntity<E> interfaceClone) throws ExceptionBase {
        E entity = this.get(id);
        return this.cloneEntity((K)entity, interfaceClone);
    }

    @Override
    public E getOrThrow(K id) throws ExceptionObjNotFound {
        if (id == null) {
            this.throwIfNull(null, (Serializable)id);
        }
        E e = this.get(id);
        this.throwIfNull(e, (Serializable)id);
        return e;
    }

    @Override
    public E getOrThrowWithCache(K id) throws ExceptionObjNotFound {
        E e = this.getWithCache(id);
        this.throwIfNull(e, (Serializable)id);
        return e;
    }

    @Override
    public E getOrThrow(String id) throws ExceptionObjNotFound {
        E e = this.get(id);
        if (e == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.GEN.000032", new String[]{MessagesBaseMentor.getMsg((String)this.getEntityClass().getSimpleName(), (Object[])new Object[0]), id}));
        }
        return e;
    }

    @Override
    public E getOrThrowWithCache(String id) throws ExceptionObjNotFound {
        E e = this.getWithCache((K)id);
        if (e == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.GEN.000032", new String[]{MessagesBaseMentor.getMsg((String)this.getEntityClass().getSimpleName(), (Object[])new Object[0]), id}));
        }
        return e;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public <S> S cloneEntity(E entity, Class<S> dtoClass, InterfaceCloneEntity<E> interfaceClone) throws ExceptionBase {
        return this.buildToDTO(this.cloneEntity((K)entity, interfaceClone), dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public <S> S cloneEntity(K id, Class<S> dtoClass, InterfaceCloneEntity<E> interfaceClone) throws ExceptionBase {
        E entity = this.get(id);
        return this.cloneEntity((K)entity, dtoClass, interfaceClone);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRES_NEW)
    public List<E> saveOrUpdateFlush(Collection<E> entities) {
        LinkedList<InterfaceVO> aux = new LinkedList<InterfaceVO>();
        for (InterfaceVO entity : entities) {
            aux.add(this.beforeSaveEntity(entity));
        }
        entities = this.getGenericDao().saveOrUpdate(aux);
        aux = new LinkedList();
        for (InterfaceVO entity : entities) {
            aux.add(this.afterSaveEntity(entity));
        }
        return aux;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> E saveDTO(S entity, Class<S> dtoClass) {
        E toSave = this.buildToEntity(entity);
        this.beforeSave(toSave);
        return this.saveOrUpdate(toSave);
    }

    @Override
    public <S extends DTOObjectInterface> TempSaveObj<E> validateDTO(S entity, Class<S> dtoClass, ValidGeneric<E> validator) {
        TempSaveObj<E> temp = new TempSaveObj<E>();
        temp.setValidator(validator);
        E toSave = this.buildToEntity(entity);
        this.beforeSave(toSave);
        validator.clearContainer();
        validator.isValidData(toSave);
        if (validator.hasErrors()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
        }
        temp.setResult(toSave);
        return temp;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S extends DTOObjectInterface> TempSaveObj<E> saveDTO(S entity, Class<S> dtoClass, ValidGeneric<E> validator, ValidGenericCrud<E> validatorCrud) {
        E toSave = this.buildToEntity(entity);
        TempSaveObj<E> res = this.saveOrUpdateValidate(toSave, validator, validatorCrud);
        if (res.getResult() != null && dtoClass != null) {
            res.setDtoResult((DTOObjectInterface)this.buildToDTOGeneric(res.getResult(), dtoClass));
        }
        return res;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public List<E> saveOrUpdate(List<E> entities) {
        LinkedList<InterfaceVO> aux = new LinkedList<InterfaceVO>();
        for (Object e : entities) {
            aux.add(this.beforeSaveEntity(e));
        }
        LinkedList<InterfaceVO> aux1 = new LinkedList<InterfaceVO>();
        for (InterfaceVO e : aux) {
            aux1.add(this.saveOrUpdate(e));
        }
        LinkedList<InterfaceVO> aux2 = new LinkedList<InterfaceVO>();
        for (InterfaceVO e : aux1) {
            aux2.add(this.afterSaveEntity(e));
        }
        return aux2;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> List<E> saveAllDTO(List<S> entity, Class<S> dtoClass) {
        Object toSave = this.buildToEntity((S)entity);
        this.beforeSave(toSave);
        toSave = this.saveOrUpdate((List<E>)toSave);
        return toSave;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> List<E> saveAll(String jsonData, Class<S> dtoClass) {
        try {
            List temp = ToolJson.readJsonList((String)jsonData, dtoClass);
            Object toSave = this.buildToEntity((S)temp);
            this.beforeSave(toSave);
            toSave = this.saveOrUpdate((List<E>)toSave);
            return toSave;
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<E> beforeSave(List<E> aux) {
        if (aux == null) {
            return null;
        }
        for (InterfaceVO a : aux) {
            this.beforeSave(a);
        }
        return aux;
    }

    public E beforeSave(E aux) {
        return aux;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public Long countOf() {
        return this.getGenericDao().countOf();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> findAll() {
        return this.getGenericDao().getAll();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> getAllByStatus(EnumConstStatusObjeto status) {
        return this.getGenericDao().getAllByStatus(status);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> findAllAtivos() {
        return this.getGenericDao().findAllAtivos();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getAtivo(K id) {
        return this.getGenericDao().getAtivo(id);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getAtivoOrThrow(K id) throws ExceptionObjNotFound {
        Object vo = this.getGenericDao().getAtivo(id);
        if (vo == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.GEN.000034", new Object[]{MessagesBaseMentor.getMsg((String)this.getEntityClass().getSimpleName(), (Object[])new Object[0]), id}));
        }
        return vo;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> List<S> getAllDTO(Class<S> dtoClass) {
        List<E> found = this.findAll();
        return this.buildToDTO(found, dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> List<S> getAllByStatusDTO(EnumConstStatusObjeto status, Class<S> dtoClass) {
        List<E> found = this.getAllByStatus(status);
        return this.buildToDTO(found, dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> List<S> findAllDTO(Class<S> dtoClass) {
        return this.buildToDTO(this.findAll(), dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> getAll(Long firstResult, Long numberOF) {
        List found = this.getGenericDao().getAll(firstResult, numberOF);
        return found;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> List<S> getAllDTO(Long firstResult, Long numberOF, Class<S> dtoClass) {
        List<E> found = this.getAll(firstResult, numberOF);
        return this.buildToDTO(found, dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E get(K id) {
        return this.getGenericDao().get(id);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E get(String id) {
        return this.getDao().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getWithCache(String id) {
        String key;
        if (id == null) {
            return null;
        }
        String string = key = String.valueOf(this.getEntityClass()) + "_" + id;
        synchronized (string) {
            Object value = (InterfaceVO)this.cacheEntityManager.getObject((Serializable)((Object)key), this.getEntityClass());
            if (value != null) {
                value = this.getDao().attachSession((InterfaceVO)value);
                return (E)value;
            }
            value = this.get(id);
            if (value != null) {
                this.cacheEntityManager.putObject((Serializable)((Object)key), value);
            }
            return (E)value;
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getWithCache(K id) {
        if (id == null) {
            return null;
        }
        E value = this.getWithCache((K)String.valueOf(id));
        return value;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getWithCacheOrThrow(K id) throws ExceptionObjNotFound {
        E value = this.getWithCache(id);
        this.throwIfNull(value, (Serializable)id);
        return value;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> S get(K id, Class<S> dtoClass) {
        Object e = this.getGenericDao().get(id);
        if (e == null) {
            return null;
        }
        return this.buildToDTO(e, dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> S getDTO(K id, Class<S> dtoClass) {
        if (id == null) {
            return null;
        }
        return this.buildToDTO(this.getGenericDao().get(id), dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> List<S> getsDTO(K[] ids, Class<S> dtoClass) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        return this.buildToDTO(this.getGenericDao().gets(ids), dtoClass);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public boolean delete(E entity) {
        this.beforeDeleteEntity(entity);
        boolean ret = this.deleteOnly(entity);
        this.afterDeleteEntity(entity);
        return ret;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public boolean deleteOnly(E entity) {
        boolean ret = this.getGenericDao().delete(entity);
        return ret;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public <S> Boolean deleteDTO(S entity) {
        return this.delete(this.buildToEntity(entity));
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public boolean deleteCollection(List<E> entity) {
        for (InterfaceVO e : entity) {
            boolean ret = this.delete(e);
            if (ret) continue;
            throw new ExceptionErroProgramacao("nao foi possivel deletar");
        }
        return true;
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public <S> void deleteAllDTO(Iterable<S> entities) {
        this.getGenericDao().deleteCollection(this.buildToEntity((S)entities));
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteById(K ... ids) {
        for (K id : ids) {
            Object ent = this.getDao().get(id);
            this.delete(ent);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteById(String ... ids) {
        for (String id : ids) {
            Object ent = this.getDao().get(id);
            this.delete(ent);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> gets(K ... ids) {
        return this.getDao().gets(ids);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public List<E> gets(Collection<K> ids) {
        return this.getDao().gets(ids);
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getFirst() {
        return this.getGenericDao().getFirst();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E getLast() {
        return this.getGenericDao().getLast();
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public E refresh(E entity) {
        return this.getGenericDao().refresh(entity);
    }

    @Override
    public <S> S buildToDTO(E aux, Class<S> classTo) {
        if (aux == null) {
            return null;
        }
        try {
            List clazz = ToolReflections.getClassesFromInterface((String)DTOTransformer.class.getPackage().getName(), DTOTransformer.class);
            for (Class c : clazz) {
                Type entity = ((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0];
                Type dto = ((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[1];
                if (!ToolMethods.isEquals((Object)entity, (Object)aux.getClass()) || !ToolMethods.isEquals((Object)dto, classTo)) continue;
                DTOTransformer builder = (DTOTransformer)c.newInstance();
                return builder.buildDTO(aux);
            }
            Object ret = this.getDtoBuilder(this.getEntityClass(), classTo).toDTO(aux);
            return (S)ret;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED, readOnly=true)
    public <S> S getSimpleDTO(K id, Class<S> classTo) {
        return this.getGenericDao().getSimpleDTO((Long)id, classTo);
    }

    @Override
    public Class<E> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = ToolReflections.getGenericTypeClass(this.getClass(), (int)0);
        }
        return this.entityClass;
    }

    @Override
    public <S> List<S> buildToDTO(List<E> aux, Class<S> classTo) {
        try {
            LinkedList<Object> ret = new LinkedList<Object>();
            for (InterfaceVO temp : aux) {
                ret.add(this.getDtoBuilder(this.getEntityClass(), classTo).toDTO((Object)temp));
            }
            return ret;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public <S> List<E> buildToEntity(Collection<S> data) {
        return this.buildToEntity((S)data);
    }

    @Override
    public <S> List<E> buildToEntity(Iterable<S> data) {
        LinkedList<E> ret = new LinkedList<E>();
        for (S aux : data) {
            E temp = this.buildToEntity(aux);
            if (temp == null) continue;
            ret.add(temp);
        }
        return ret;
    }

    @Override
    public <S> E buildToEntity(S data) {
        if (data == null) {
            return null;
        }
        E obj = this.getObjectIfExists(data);
        return this.buildToEntity(data, obj);
    }

    @Override
    public <S> E buildToEntity(S data, E obj) {
        if (data == null) {
            return null;
        }
        Class<?> dtoClass = data.getClass();
        try {
            obj = obj != null ? (InterfaceVO)this.getDefaultDtoBuilder(dtoClass).toEntity(data, obj) : (InterfaceVO)this.getDefaultDtoBuilder(dtoClass).toEntity(data);
            return obj;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public <S> List<E> buildToObject(String str, Class<S> dtoClass) {
        try {
            LinkedList<E> ret = new LinkedList<E>();
            List data = ToolJson.readJsonList((String)str, dtoClass);
            ToolDTOBuilder<E, S> builder = this.newDtoBuilder(this.getEntityClass(), dtoClass);
            for (Object aux : data) {
                Object obj = this.getObjectIfExists(aux);
                if (obj != null) {
                    builder.toEntity(aux, obj);
                    ret.add(obj);
                    continue;
                }
                obj = (InterfaceVO)builder.toEntity(aux);
                ret.add(obj);
            }
            return ret;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    protected <S> ToolDTOBuilder<E, S> getDefaultDtoBuilder(Class<S> dtoClass) {
        try {
            ToolDTOBuilder<E, S> dtoBuilder = this.newDtoBuilder(this.getEntityClass(), dtoClass);
            this.addConverters(dtoBuilder);
            return dtoBuilder;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public <R> ToolDTOBuilder<E, R> getDtoBuilder(Class<E> entityClass, Class<R> dtoClass) {
        try {
            ToolDTOBuilder builder = new ToolDTOBuilder(entityClass, dtoClass);
            this.addConverters(builder);
            return builder;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    private <S> ToolDTOBuilder<E, S> newDtoBuilder(Class<E> entityClass, Class<S> dtoClass) {
        try {
            return new ToolDTOBuilder(entityClass, dtoClass);
        }
        catch (ExceptionReflection ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void addCustomConverters(ToolDTOBuilder dtoBuilder) {
    }

    private void addConverters(ToolDTOBuilder dtoBuilder) {
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.getDefaultEntityDTOConverter());
        this.addCustomConverters(dtoBuilder);
    }

    public E getObjectIfExists(Object aux) {
        return null;
    }

    public EntityDTOConverter getDefaultEntityDTOConverter() {
        return this.defaultEntityDTOConverter;
    }

    @Override
    public E beforeSaveEntity(E entity) {
        return entity;
    }

    @Override
    public E afterSaveEntity(E entity) {
        return entity;
    }

    @Override
    public E beforeDeleteEntity(E entity) {
        return entity;
    }

    @Override
    public void afterDeleteEntity(E entity) {
    }

    protected void throwIfNull(E e, Serializable id) throws ExceptionObjNotFound {
        if (e == null && id != null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.GEN.000032", new Object[]{MessagesBaseMentor.getMsg((String)this.getEntityClass().getSimpleName(), (Object[])new Object[0]), id}));
        }
    }

    protected void throwIfNull(Object e, String codMessage, Object ... params) throws ExceptionObjNotFound {
        if (e == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail(codMessage, params));
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> S saveOrUpdateDTO(S dto) {
        try {
            E toSave = this.buildToEntity(dto);
            this.beforeSave(toSave);
            toSave = this.saveOrUpdate(toSave);
            Class<?> aClass = dto.getClass();
            return (S)this.buildToDTO(toSave, aClass);
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> List<S> saveOrUpdateDTO(List<S> dto) {
        try {
            if (TMethods.isWithData(dto)) {
                return new LinkedList();
            }
            Object toSave = this.buildToEntity((S)dto);
            this.beforeSave(toSave);
            toSave = this.saveOrUpdate((List<E>)toSave);
            Class<?> aClass = dto.get(0).getClass();
            return this.buildToDTO((List<E>)toSave, (Class<S>)aClass);
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public void saveDraft(String dto, Usuario user, Empresa empresa, String descricao, Short geradoAutomatico, String controllerNodo) {
        try {
            if (!TMethods.isStrWithData((String)descricao)) {
                descricao = MessagesBaseMentor.getMsg((String)"rascunhoGeradoEm", (Object[])new Object[]{TDate.dateToStr((Date)new Date())});
            }
            if (geradoAutomatico == null) {
                geradoAutomatico = EnumConstantsMentorSimNao.SIM.getValue();
            }
            if (user != null && empresa != null) {
                this.serviceBinaryArqRascunhoRecurso.save(controllerNodo, user.getIdentificador(), empresa.getIdentificador(), descricao, geradoAutomatico, dto);
            } else {
                this.serviceBinaryArqRascunhoRecurso.save(controllerNodo, null, null, descricao, geradoAutomatico, dto);
            }
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public boolean deleteDraft(K id) {
        try {
            if (!TMethods.isNull(id).booleanValue()) {
                return this.serviceBinaryArqRascunhoRecurso.delete((Serializable)((Long)id));
            }
            return false;
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public <S> List<WebDTORascunho<S>> getDrafts(String controllerNodo, Usuario user, Empresa empresa, Class<S> dtoClass) {
        try {
            List rascunhos = user != null && empresa != null ? this.serviceBinaryArqRascunhoRecurso.getRascunhos(controllerNodo, user.getIdentificador(), empresa.getIdentificador()) : this.serviceBinaryArqRascunhoRecurso.getRascunhos(controllerNodo, null, null);
            ArrayList<WebDTORascunho<S>> ret = new ArrayList<WebDTORascunho<S>>();
            for (ArqRascunhoRecurso rasc : rascunhos) {
                WebDTORascunho w = new WebDTORascunho();
                w.setIdentificador(rasc.getIdentificador());
                w.setData(ToolJson.readJson((String)rasc.getConteudo(), dtoClass));
                w.setDescricao(rasc.getDescricao());
                w.setGeradoAutomatico(rasc.getGeradoAutomatico());
                ret.add(w);
            }
            return ret;
        }
        catch (ExceptionErroProgramacao ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }
}

