/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.inativo.ExceptionInativoRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.ServiceGeneric;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="transactionManager")
public abstract class ServiceGenericImpl
extends BaseMethods
implements ServiceGeneric {
    @Autowired
    private InterfaceStaticObjects sharedData;

    public void checkAndThrownInactive(Number value, Class key) {
        this.checkAndThrownInactive(value, key.getName());
    }

    public void checkAndThrownInactive(Number value, String key) {
        if (value == null) {
            throw new ExceptionInativoRuntime(new ExcepCodeDetail("E.GEN.000004", new String[]{this.getMessage(key, new Object[0])}));
        }
        if (value.shortValue() == EnumConstStatusObjeto.AGUARDANDO_REVISAO.value) {
            throw new ExceptionInativoRuntime(new ExcepCodeDetail("E.GEN.000005", new String[]{this.getMessage(key, new Object[0])}));
        }
        if (value.shortValue() != EnumConstStatusObjeto.ATIVO.value) {
            throw new ExceptionInativoRuntime(new ExcepCodeDetail("E.GEN.000006", new String[]{this.getMessage(key, new Object[0])}));
        }
    }

    public void checkAndThrownNotExists(Object object, String key) {
        if (object == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.GEN.000007", new String[]{this.getMessage(key, new Object[0])}));
        }
    }

    public void checkAndThrownNotExists(Object object, Class key) {
        this.checkAndThrownNotExists(object, key.getName());
    }

    public void checkAndThrownInvalidObj(Object object, Number status, String key) {
        this.checkAndThrownNotExists(object, key);
        this.checkAndThrownInactive(status, key);
    }

    public void checkAndThrownInvalidObj(Object object, Number status, Class key) {
        this.checkAndThrownInvalidObj(object, status, key.getName());
    }

    public InterfaceStaticObjects getSharedData() {
        return this.sharedData;
    }

    protected <T, Z> Z builderToDTO(Class<T> entityClass, Class<Z> dtoClass, T preCad) throws ExceptionReflection {
        ToolDTOBuilder t = new ToolDTOBuilder(entityClass, dtoClass);
        return (Z)t.toDTO(preCad);
    }

    public <S> List<S> buildToDTOGeneric(List<?> aux, Class<S> classTo) {
        try {
            LinkedList<Object> ret = new LinkedList<Object>();
            ToolDTOBuilder builder = null;
            for (Object temp : aux) {
                if (builder == null) {
                    builder = new ToolDTOBuilder(temp.getClass(), classTo);
                }
                ret.add(builder.toDTO(temp));
            }
            return ret;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public <S> S buildToDTOGeneric(Object temp, Class<S> classTo) {
        try {
            ToolDTOBuilder builder = null;
            if (builder == null) {
                builder = new ToolDTOBuilder(temp.getClass(), classTo);
            }
            return (S)builder.toDTO(temp);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setSharedData(InterfaceStaticObjects sharedData) {
        this.sharedData = sharedData;
    }
}

