/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.components.banksapi;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificadoItem;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.BankFactory;
import com.touchcomp.basementorbanks.services.impl.accounts.BankAccounts;
import com.touchcomp.basementorbanks.services.impl.accounts.model.Accounts;
import com.touchcomp.basementorbanks.services.impl.accounts.model.AccountsParams;
import com.touchcomp.basementorbanks.services.impl.statements.BankStatements;
import com.touchcomp.basementorbanks.services.impl.statements.model.StatementParams;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.ServiceConciliacaoBancariaImpl;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompProcessarExtratoBancario;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompBanksSincConciliacao
extends ServiceGenericImpl {
    @Autowired
    private ServiceContaValoresImpl serviceContaValores;
    @Autowired
    private ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl;
    @Autowired
    private ServiceConciliacaoBancariaImpl serviceConciliacaoBancaria;
    @Autowired
    private SCompProcessarExtratoBancario compProcessarExtrato;
    @Autowired
    HelperConfigServicos helperConfigServicos;
    private ConfigServicos configServicos;
    private ConfiguracaoCertificado configuracaoCertificado;

    public ConciliacaoBancaria conciliar(ContaValores contaValores, ConfigServicos config, Date dataInicial, Date dataFinal) throws BankException, ExceptionBase, BankNotSupportedException {
        this.helperConfigServicos.build(config);
        this.configuracaoCertificado = this.serviceConfiguracaoCertificadoImpl.getByEmpresaOrThrow(contaValores.getAgenciaValor().getEmpresa());
        Accounts.Account account = this.findAccounts(contaValores);
        if (account == null) {
            return null;
        }
        Statements statements = this.findStatements(contaValores, account, dataInicial, dataFinal);
        ConciliacaoBancaria conciliacao = this.build(statements, contaValores, dataInicial, dataFinal, (short)0);
        Double saldoAnteriorExtrato = this.serviceConciliacaoBancaria.getSaldoAnterior(dataInicial, conciliacao.getContaValores());
        this.compProcessarExtrato.processar(EnumConstantsMentorSimNao.SIM.getValue(), conciliacao, saldoAnteriorExtrato, statements.getStatements());
        return conciliacao;
    }

    private ConciliacaoBancaria build(Statements statement, ContaValores contaValores, Date dataInicial, Date dataFinal, Short gerarBloqueio) throws ExceptionObjNotFound {
        ConciliacaoBancaria vo = new ConciliacaoBancaria();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(contaValores.getAgenciaValor().getEmpresa());
        vo.setContaValores(contaValores);
        vo.setDataInicial(dataInicial);
        vo.setDataFinal(dataFinal);
        vo.setGerarBloqueioMovBancario(gerarBloqueio);
        vo.setStatusConciliacaoBancaria(Short.valueOf(EnumConstStatusObjeto.AGUARDANDO_REVISAO.getValue()));
        return vo;
    }

    public ConfiguracaoCertificado getConfiguracaoCertificado() {
        return this.configuracaoCertificado;
    }

    public HelperConfigServicos getHelperConfigServicos() {
        return this.helperConfigServicos;
    }

    public ConfigServicos getConfigServicos() {
        return this.configServicos;
    }

    protected Accounts.Account findAccounts(ContaValores contaValores) throws BankException, ExceptionBase, BankNotSupportedException {
        BankAccounts bank = BankFactory.get().getBankAccounts();
        ProcessResult token = bank.getToken(this.getCredentials(contaValores, this.configuracaoCertificado));
        if (!token.isOk()) {
            throw new ExceptionInvalidData("E.ERP.1671.004", new Object[]{token.getResponse().getErrorsAsString()});
        }
        AccountsParams params = new AccountsParams((BankToken)token.getResult());
        params.setRequestAll(Boolean.valueOf(true));
        params.setBankNumber(((BankToken)token.getResult()).getBankCredentials().getBankType());
        ProcessResult processResult = bank.getAccounts(params);
        if (!processResult.isOk()) {
            throw new ExceptionInvalidData("E.ERP.1671.004", new Object[]{processResult.getResponse().getErrorsAsString()});
        }
        String nrContaS = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)contaValores.getNrConta()));
        String nrAgenciaS = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)contaValores.getAgenciaValor().getNrAgencia()));
        String nrBancoS = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)contaValores.getAgenciaValor().getInstituicaoValor().getNrBanco()));
        Optional<Accounts.Account> found = ((Accounts)processResult.getResult()).getAccounts().stream().filter(i -> {
            String nrConta = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)i.getAccountNumber()));
            String nrAgencia = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)i.getBranchCode()));
            String nrBanco = ToolString.removerZerosAEsquerda((String)ToolString.onlyNumbers((String)i.getBankCode()));
            return ToolMethods.isEquals((Object)nrContaS, (Object)nrConta) && ToolMethods.isEquals((Object)nrAgenciaS, (Object)nrAgencia) && ToolMethods.isEquals((Object)nrBancoS, (Object)nrBanco);
        }).findFirst();
        if (!found.isPresent()) {
            throw new ExceptionInvalidData("E.ERP.1671.011", new Object[]{contaValores, ToolString.asString((List)((Accounts)processResult.getResult()).getAccounts(), (String)";")});
        }
        found.get().setMyID(String.valueOf(contaValores.getIdentificador()));
        return found.get();
    }

    protected Statements findStatements(ContaValores contaValores, Accounts.Account account, Date dataInicial, Date dataFinal) throws BankException, ExceptionBase, BankNotSupportedException {
        BankStatements bank = BankFactory.get().getBankStatements();
        ProcessResult token = bank.getToken(this.getCredentials(contaValores, this.configuracaoCertificado));
        if (!token.isOk()) {
            throw new ExceptionInvalidData("E.ERP.1671.004", new Object[]{token.getResponse().getErrorsAsString()});
        }
        StatementParams params = new StatementParams((BankToken)token.getResult());
        params.setAccountNumber(account.getAccountNumber());
        params.setBranchCode(account.getBranchCode());
        params.setFinalDate(dataFinal);
        params.setInitialDate(dataInicial);
        ProcessResult processResult = bank.getStatements(params);
        return (Statements)processResult.getResult();
    }

    protected BankCredentials getCredentials(ContaValores contaValores, ConfiguracaoCertificado certificado) {
        BankCredentials credentials = new BankCredentials(BankType.get((String)contaValores.getAgenciaValor().getInstituicaoValor().getNrBanco()), EnvironmentType.PRODUCAO);
        credentials.setCertificate(certificado.getArquivoPFX());
        credentials.setKeystore(certificado.getArquivoJKS());
        credentials.setCertificatePass(certificado.getSenha());
        credentials.setKeystorePass("touchcompKeyStore");
        if (SCompBanksSincConciliacao.isWithData(certificado.getItensConfCertificado())) {
            for (ConfiguracaoCertificadoItem item : certificado.getItensConfCertificado()) {
                if (!this.isNotNull(item.getPropCertificadoConexao()).booleanValue()) continue;
                credentials.putParams(item.getPropCertificadoConexao().getPropriedade(), item.getPropCertificadoConexao().getValorPropriedade());
            }
        }
        return credentials;
    }
}

