/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.components.banksapi;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.EnumConstSantanderAuthOp;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.pagamento.EnumConstWorkspaceSantanderPagOp;
import com.touchcomp.basementor.constants.enums.workspacebanco.santander.recebimento.EnumConstWorkspaceSantanderRecOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.WorkspaceBanco;
import com.touchcomp.basementor.model.vo.WorkspaceBancoAuthOp;
import com.touchcomp.basementor.model.vo.WorkspaceBancoOp;
import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResultItem;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.BankWorkspaceBilling;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.Workspace;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceDeleteParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAll;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.BankWorkspacePayments;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePay;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayDeleteParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.workspace.model.WorkspacePayParams;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.workspacebanco.HelperWorkspaceBanco;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.workspacebanco.ServiceWorkspaceBancoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.workspacebanco.web.DTOWorkspaceBancoRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class SCompBanksSincWorkspaces {
    private ServiceWorkspaceBancoImpl serviceWorkspaceBanco;
    private ServiceCarteiraCobrancaImpl serviceCarteiraCobranca;
    private HelperWorkspaceBanco helperWorkspace;
    private BankWorkspacePayments facPag;
    private BankWorkspaceBilling facRec;
    private WebDTOResult dadosTarefa;

    public SCompBanksSincWorkspaces(ServiceWorkspaceBancoImpl serviceWorkspaceBanco, ServiceCarteiraCobrancaImpl serviceCarteiraCobranca, HelperWorkspaceBanco helperWorkspace, WebDTOResult result) {
        this.serviceWorkspaceBanco = serviceWorkspaceBanco;
        this.serviceCarteiraCobranca = serviceCarteiraCobranca;
        this.helperWorkspace = helperWorkspace;
        this.dadosTarefa = result;
        this.facPag = new BankWorkspacePayments();
        this.facRec = new BankWorkspaceBilling();
    }

    public WorkspaceBanco sincronizarWorkspaces(WorkspaceBanco workspace, Empresa empresa) throws BankException, BankNotSupportedException {
        if (ToolMethods.isEquals((Object)workspace.getPagRec(), (Object)EnumConstTipoTitulo.RECEBIMENTO.getValue())) {
            BankCredentials credentials = this.getCredentials(workspace);
            ProcessResult token = this.facRec.getToken(credentials);
            if (!token.isOk()) {
                this.buildErrors(token, this.dadosTarefa);
                return workspace;
            }
            WorkspaceParams params = this.createWorkspaceParams(workspace, (BankToken)token.getResult());
            if (!ToolMethods.isStrWithData((String)workspace.getWorkspaceBancoId())) {
                ProcessResult processResult = this.facRec.create(params);
                if (!processResult.isOk()) {
                    this.buildErrors(processResult, this.dadosTarefa);
                    return workspace;
                }
                workspace.setWorkspaceBancoId(((Workspace)processResult.getResult()).getWorkspaceId());
                workspace.setAtivo(Short.valueOf((short)1));
            } else {
                ProcessResult processResult = this.facRec.update(params);
                if (!processResult.isOk()) {
                    this.buildErrors(processResult, this.dadosTarefa);
                    return workspace;
                }
                workspace.setWorkspaceBancoId(((Workspace)processResult.getResult()).getWorkspaceId());
                workspace.setAtivo(Short.valueOf((short)1));
            }
            return this.serviceWorkspaceBanco.saveOrUpdate(workspace);
        }
        BankCredentials credentials = this.getCredentials(workspace);
        ProcessResult token = this.facRec.getToken(credentials);
        if (!token.isOk()) {
            this.buildErrors(token, this.dadosTarefa);
            return workspace;
        }
        WorkspacePayParams params = this.createWorkspacePayParams(workspace, (BankToken)token.getResult());
        if (!ToolMethods.isStrWithData((String)workspace.getWorkspaceBancoId())) {
            ProcessResult processResult = this.facPag.create(params);
            if (!processResult.isOk()) {
                this.buildErrors(processResult, this.dadosTarefa);
                return workspace;
            }
            workspace.setWorkspaceBancoId(((WorkspacePay)processResult.getResult()).getWorkspaceId());
            workspace.setAtivo(Short.valueOf((short)1));
        } else {
            ProcessResult processResult = this.facPag.update(params);
            if (!processResult.isOk()) {
                this.buildErrors(processResult, this.dadosTarefa);
                return workspace;
            }
            workspace.setAtivo(Short.valueOf((short)1));
        }
        return this.serviceWorkspaceBanco.saveOrUpdate(workspace);
    }

    public WorkspaceBanco deleteWorkspace(WorkspaceBanco workspace, Empresa empresa) throws BankException, BankNotSupportedException {
        BankCredentials credentials = this.getCredentials(workspace);
        if (ToolMethods.isEquals((Object)workspace.getPagRec(), (Object)EnumConstTipoTitulo.RECEBIMENTO.getValue())) {
            ProcessResult token = this.facRec.getToken(credentials);
            if (!token.isOk()) {
                this.buildErrors(token, this.dadosTarefa);
                return workspace;
            }
            WorkspaceDeleteParams params = new WorkspaceDeleteParams((BankToken)token.getResult());
            params.setWorkspaceId(workspace.getWorkspaceBancoId());
            ProcessBooleanResult processResult = this.facRec.delete(params);
            if (processResult.getResult().booleanValue()) {
                workspace.setAtivo(Short.valueOf((short)0));
                workspace.setWorkspaceBancoId(null);
                this.serviceWorkspaceBanco.saveOrUpdate(workspace);
            }
        } else {
            ProcessResult token = this.facPag.getToken(credentials);
            if (!token.isOk()) {
                this.buildErrors(token, this.dadosTarefa);
                return workspace;
            }
            WorkspacePayDeleteParams params = new WorkspacePayDeleteParams((BankToken)token.getResult());
            params.setWorkspaceId(workspace.getWorkspaceBancoId());
            ProcessBooleanResult processResult = this.facPag.delete(params);
            if (processResult.getResult().booleanValue()) {
                workspace.setAtivo(Short.valueOf((short)0));
                workspace.setWorkspaceBancoId(null);
                this.serviceWorkspaceBanco.saveOrUpdate(workspace);
            }
        }
        return workspace;
    }

    public List<WorkspaceBanco> sincronizarWorkspaces(DTOWorkspaceBancoRes data, ConfiguracaoCertificado conf, InstituicaoValores instituicaoValores, Empresa emp) throws BankException, BankNotSupportedException {
        BankCredentials credentials = this.getCredentials(instituicaoValores, data, conf);
        LinkedList<WorkspaceBanco> sincronized = new LinkedList<WorkspaceBanco>();
        if (ToolMethods.isEquals((Object)data.getPagRec(), (Object)EnumConstTipoTitulo.RECEBIMENTO.getValue())) {
            ProcessResult token = this.facRec.getToken(credentials);
            if (!token.isOk()) {
                this.buildErrors(token, this.dadosTarefa);
                return sincronized;
            }
            WorkspaceListAllParams params = new WorkspaceListAllParams((BankToken)token.getResult());
            ProcessResult processResult = this.facRec.listAll(params);
            if (!token.isOk()) {
                this.buildErrors(processResult, this.dadosTarefa);
                return sincronized;
            }
            for (Workspace workspace : ((WorkspaceListAll)processResult.getResult()).getWorkspaces()) {
                WorkspaceBanco wb = this.getWorkspace(data, workspace, instituicaoValores, emp, (BankToken)token.getResult(), conf);
                sincronized.add(this.serviceWorkspaceBanco.saveOrUpdate(wb));
            }
        } else {
            ProcessResult token = this.facPag.getToken(credentials);
            if (!token.isOk()) {
                this.buildErrors(token, this.dadosTarefa);
                return sincronized;
            }
            WorkspacePayListAllParams params = new WorkspacePayListAllParams((BankToken)token.getResult());
            ProcessResult processResult = this.facPag.listAll(params);
            if (!token.isOk()) {
                this.buildErrors(processResult, this.dadosTarefa);
                return sincronized;
            }
            for (WorkspacePay workspace : ((WorkspacePayListAll)processResult.getResult()).getWorkspaces()) {
                WorkspaceBanco wb = this.getWorkspacePay(data, workspace, instituicaoValores, emp, (BankToken)token.getResult(), conf);
                sincronized.add(this.serviceWorkspaceBanco.saveOrUpdate(wb));
            }
        }
        return sincronized;
    }

    private BankCredentials getCredentials(InstituicaoValores inst, DTOWorkspaceBancoRes data, ConfiguracaoCertificado conf) {
        return this.helperWorkspace.getCredentials(inst, data, conf);
    }

    private BankCredentials getCredentials(WorkspaceBanco workspace) {
        return this.helperWorkspace.getCredentials(workspace);
    }

    private void setAuthOptions(WorkspaceBanco wb, DTOWorkspaceBancoRes data, BankType bankType) {
        switch (bankType) {
            case SANTANDER: {
                WorkspaceBancoAuthOp op = new WorkspaceBancoAuthOp();
                op.setCodigo(EnumConstSantanderAuthOp.CLIENT_ID.getCodigo());
                op.setValor(this.helperWorkspace.getPropertyAuthId(data, EnumConstSantanderAuthOp.CLIENT_ID));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesAuthOp().add(op);
                op = new WorkspaceBancoAuthOp();
                op.setCodigo(EnumConstSantanderAuthOp.CLIENT_SECRET.getCodigo());
                op.setValor(this.helperWorkspace.getPropertyAuthId(data, EnumConstSantanderAuthOp.CLIENT_SECRET));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesAuthOp().add(op);
            }
        }
    }

    protected WorkspaceBanco getWorkspacePay(DTOWorkspaceBancoRes data, WorkspacePay workspace, InstituicaoValores instituicaoValores, Empresa emp, BankToken token, ConfiguracaoCertificado conf) {
        BankType bankType = BankType.get((String)instituicaoValores.getNrBanco());
        WorkspaceBanco wb = new WorkspaceBanco();
        wb.setAtivo(Short.valueOf(workspace.getStatusType().isActive() ? (short)1 : 0));
        wb.setConfiguracaoCertificado(conf);
        wb.setDataCadastro(new Date());
        wb.setDescricao(workspace.getWorkspaceId());
        wb.setEmpresa(emp);
        wb.setGrupoEmpresa(emp.getEmpresaDados().getGrupoEmpresa());
        wb.setInstituicaoValores(instituicaoValores);
        this.setAuthOptions(wb, data, bankType);
        wb.setPagRec(Short.valueOf(EnumConstTipoTitulo.PAGAMENTO.getValue()));
        wb.setWebhookURL(workspace.getWebhookURL());
        wb.setWorkspaceBancoId(workspace.getWorkspaceId());
        wb.setCarteiraPrincipal(this.getCarteiraCobranca(instituicaoValores, workspace));
        switch (bankType) {
            case SANTANDER: {
                WorkspaceBancoOp op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_BARCODE_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isBarCodePaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_SLIP_AVAILABLE_PAYMENTS_DDA_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isBankSlipAvailableDDAActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_PIX_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isPixPaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_SLIP_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isBankSlipPaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_TAXES_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isTaxesByFieldPaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_TRANSFERS_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isBankTransferPaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_VEHICLE_PAYMENTS_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isVehicleTaxesPaymentsActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.BANK_SLIP_WEBHOOK_PAYMENTS_DDA_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.isBankSlipAvailableDDAWebhookActive() ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderPagOp.WORKSPACE_TYPE.getCodigo());
                op.setValor(workspace.getWorkspaceType());
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
            }
        }
        return wb;
    }

    protected WorkspaceBanco getWorkspace(DTOWorkspaceBancoRes data, Workspace workspace, InstituicaoValores instituicaoValores, Empresa emp, BankToken token, ConfiguracaoCertificado conf) {
        WorkspaceBanco wb = this.serviceWorkspaceBanco.getByWorkspaceId(workspace.getWorkspaceId());
        if (wb == null) {
            wb = new WorkspaceBanco();
        }
        BankType bankType = BankType.get((String)instituicaoValores.getNrBanco());
        wb.setAtivo(Short.valueOf(workspace.getStatusType().isActive() ? (short)1 : 0));
        wb.setConfiguracaoCertificado(conf);
        wb.setDataCadastro(new Date());
        wb.setDescricao(workspace.getWorkspaceId());
        wb.setEmpresa(emp);
        wb.setGrupoEmpresa(emp.getEmpresaDados().getGrupoEmpresa());
        wb.setInstituicaoValores(instituicaoValores);
        this.setAuthOptions(wb, data, bankType);
        wb.setPagRec(Short.valueOf(EnumConstTipoTitulo.RECEBIMENTO.getValue()));
        wb.setWebhookURL(workspace.getWebhookURL());
        wb.setWorkspaceBancoId(workspace.getWorkspaceId());
        wb.setCarteiraPrincipal(this.getCarteiraCobranca(workspace, instituicaoValores));
        switch (bankType) {
            case SANTANDER: {
                WorkspaceBancoOp op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderRecOp.BANK_SLIP_WEBHOOK_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.getBankSlipBillingWebhookActive() != false ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderRecOp.BANK_PIX_WEBHOOK_ACTIVE.getCodigo());
                op.setValor(String.valueOf(workspace.getPixBillingWebhookActive() != false ? 1 : 0));
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
                op = new WorkspaceBancoOp();
                op.setCodigo(EnumConstWorkspaceSantanderRecOp.BANK_WORKSPACE_TYPE.getCodigo());
                op.setValor(workspace.getWorkspaceType());
                op.setWorkspaceBanco(wb);
                wb.getOpcoesOp().add(op);
            }
        }
        return wb;
    }

    private CarteiraCobranca getCarteiraCobranca(InstituicaoValores inst, WorkspacePay workspace) {
        if (workspace.getMainDebitAccount() == null) {
            return null;
        }
        return this.serviceCarteiraCobranca.get(workspace.getMainDebitAccount().getBranchNumber(), workspace.getMainDebitAccount().getAccountNumber(), inst, EnumConstSituacaoCobranca.SIMPLES);
    }

    private CarteiraCobranca getCarteiraCobranca(Workspace workspace, InstituicaoValores instituicaoValores) {
        LinkedList<String> convenios = new LinkedList<String>();
        workspace.getCovenants().forEach(i -> convenios.add((String)i));
        return this.serviceCarteiraCobranca.getByConvenio(convenios, instituicaoValores, EnumConstSituacaoCobranca.SIMPLES);
    }

    protected WorkspaceParams createWorkspaceParams(WorkspaceBanco workspace, BankToken token) throws BankException, BankNotSupportedException {
        WorkspaceParams params = new WorkspaceParams(token);
        params.setDescription(workspace.getDescricao());
        params.setWebhookURL(workspace.getWebhookURL());
        params.setWorkspaceId(workspace.getWorkspaceBancoId());
        params.setCovenants(ToolMethods.toList((Object[])new Object[]{workspace.getCarteiraPrincipal().getContaValor().getNumeroConvenio()}));
        BankType bankType = BankType.get((String)workspace.getInstituicaoValores().getNrBanco());
        switch (bankType) {
            case SANTANDER: {
                String value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderRecOp.BANK_PIX_WEBHOOK_ACTIVE);
                params.setPixBillingWebhookActive(Boolean.valueOf(ToolMethods.isAffirmative((String)value)));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderRecOp.BANK_SLIP_WEBHOOK_ACTIVE);
                params.setBankSlipBillingWebhookActive(Boolean.valueOf(ToolMethods.isAffirmative((String)value)));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderRecOp.BANK_WORKSPACE_TYPE);
                params.setWorkspaceType(value);
            }
        }
        return params;
    }

    protected WorkspacePayParams createWorkspacePayParams(WorkspaceBanco workspace, BankToken token) throws BankException, BankNotSupportedException {
        WorkspacePayParams params = new WorkspacePayParams(token);
        params.setDescription(workspace.getDescricao());
        params.setMainDebitAccount(new WorkspacePayParams.Account());
        params.getMainDebitAccount().setAccountNumber(workspace.getCarteiraPrincipal().getContaValor().getNrConta());
        params.getMainDebitAccount().setBranchNumber(workspace.getCarteiraPrincipal().getContaValor().getAgenciaValor().getNrAgencia());
        params.setWebhookURL(workspace.getWebhookURL());
        params.setWorkspaceId(workspace.getWorkspaceBancoId());
        BankType bankType = BankType.get((String)workspace.getInstituicaoValores().getNrBanco());
        switch (bankType) {
            case SANTANDER: {
                String value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_SLIP_AVAILABLE_PAYMENTS_DDA_ACTIVE);
                params.setBankSlipAvailableActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_SLIP_WEBHOOK_PAYMENTS_DDA_ACTIVE);
                params.setBankSlipAvailableWebhookActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_SLIP_PAYMENTS_ACTIVE);
                params.setBankSlipPaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_TRANSFERS_PAYMENTS_ACTIVE);
                params.setBankTransferPaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_BARCODE_PAYMENTS_ACTIVE);
                params.setBarCodePaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_PIX_PAYMENTS_ACTIVE);
                params.setPixPaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_TAXES_PAYMENTS_ACTIVE);
                params.setTaxesByFieldPaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.BANK_VEHICLE_PAYMENTS_ACTIVE);
                params.setVehicleTaxesPaymentsActive(ToolMethods.isAffirmative((String)value));
                value = this.helperWorkspace.getProperty(workspace.getOpcoesOp(), (EnumOpDinamicasInterface)EnumConstWorkspaceSantanderPagOp.WORKSPACE_TYPE);
                params.setWorkspaceType(value);
            }
        }
        return params;
    }

    private void buildErrors(ProcessResult processResult, WebDTOResult dadosTarefa) {
        dadosTarefa.setStatus(EnumConstantsMentorStatus.ERRO);
        dadosTarefa.setMessage(MessagesBaseMentor.getErrorMsg((String)"E.ERP.2013.001", (Object[])new Object[0]));
        for (ResultItem error : processResult.getResponse().getErrors()) {
            dadosTarefa.addErroMessage(error.getCode(), error.getDescription());
        }
    }
}

