/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.adiantamentoviagem;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.BloqueioAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.ParametrizacaoAdiantamentoViagem;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.bloqueioadiantamentoviagem.ServiceBloqueioAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesgerenciais.ServiceOpcoesGerenciaisImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoadiantamentoviagem.ServiceParametrizacaoAdiantamentoViagemImpl;
import com.touchcomp.touchvomodel.vo.adiantamentoviagem.web.DTOAdiantamentoViagem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceAdiantamentoViagemImpl
extends ServiceGenericEntityImpl<AdiantamentoViagem, Long, DaoAdiantamentoViagemImpl> {
    @Autowired
    ServiceParametrizacaoAdiantamentoViagemImpl serviceParametrizacaoAdiantamentoViagemImpl;
    @Autowired
    ServiceBloqueioAdiantamentoViagemImpl serviceBloqueioAdiantamentoViagemImpl;
    @Autowired
    ServiceOpcoesContabeisImpl serviceOpcoesContabeisImpl;
    @Autowired
    ServiceOpcoesGerenciaisImpl serviceOpcoesGerenciaisImpl;
    @Autowired
    CompGeracaoTitulos compGeracaoTitulos;
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    @Autowired
    public ServiceAdiantamentoViagemImpl(DaoAdiantamentoViagemImpl dao) {
        super(dao);
    }

    @Override
    public AdiantamentoViagem beforeSaveEntity(AdiantamentoViagem vo) {
        List<BloqueioAdiantamentoViagem> bloqueioAdiantamentoViagem = this.serviceBloqueioAdiantamentoViagemImpl.verificaBloqueio(vo.getDataEmissao(), vo.getEmpresa());
        if (ServiceAdiantamentoViagemImpl.isWithData(bloqueioAdiantamentoViagem)) {
            String idBloqueios = bloqueioAdiantamentoViagem.stream().map(i -> i.getIdentificador().toString()).collect(Collectors.joining(", "));
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0478.004", new String[]{idBloqueios}));
        }
        this.createAndUpdateTitulo(vo);
        return vo;
    }

    private void createAndUpdateTitulo(AdiantamentoViagem vo) {
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.findByEmpresa(vo.getEmpresa());
        if (this.isNotNull(opcoesContabeis).booleanValue() && this.isNull(opcoesContabeis.getPlanoContaAdViagem()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0478.001"));
        }
        if (this.isNotNull(opcoesContabeis).booleanValue() && this.isNull(opcoesContabeis.getPlanoContaGerAdViagem()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0478.002"));
        }
        OpcoesGerenciais opcoesGerenciais = this.serviceOpcoesGerenciaisImpl.findByEmpresa(vo.getEmpresa());
        if (this.isNotNull(opcoesContabeis).booleanValue() && this.isNotNull(opcoesGerenciais).booleanValue()) {
            if (this.isNull(vo.getTitulo()).booleanValue()) {
                OpcoesFinanceiras opcoesFinanceiras = this.getSharedData().getOpcoesFinanceiras(vo.getEmpresa());
                this.compGeracaoTitulos.gerarTitulosAdiantamentoViagem(vo, opcoesContabeis.getPlanoContaAdViagem(), opcoesContabeis.getPlanoContaGerAdViagem(), opcoesGerenciais, opcoesFinanceiras);
            } else {
                vo.getTitulo().setDataEmissao(vo.getDataEmissao());
                vo.getTitulo().setDataCompetencia(vo.getDataEmissao());
                vo.getTitulo().setDataVencimento(vo.getDataEmissao());
                vo.getTitulo().setDataVencimentoBase(vo.getDataEmissao());
                vo.getTitulo().setDataEntradaSaida(vo.getDataEmissao());
                vo.getTitulo().setValor(vo.getValorAdiantamento());
                vo.getTitulo().setPessoa(vo.getPessoa());
                vo.getTitulo().getLancCtbGerencial().clear();
                ArrayList<LancamentoCtbGerencial> listLancCtbGerencial = new ArrayList<LancamentoCtbGerencial>();
                LancamentoCtbGerencial lancCtbGerencial = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, vo.getTitulo().getDataCadastro(), vo.getTitulo().getDataVencimento(), EnumLancamentoCTBGerencial.DEBITO.getValue(), vo.getTitulo().getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.0478.002", (Object[])new Object[]{vo.getPessoa().getNome()}), opcoesContabeis.getPlanoContaGerAdViagem(), vo.getTitulo().getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), opcoesGerenciais.getCentroCustoAdiantViagem(), vo.getTitulo().getValor(), null);
                listLancCtbGerencial.add(lancCtbGerencial);
                vo.getTitulo().setLancCtbGerencial(listLancCtbGerencial);
            }
        }
    }

    public List<AdiantamentoViagem> adiantamentosPorPeriodo(Date dataInicial, Date dataFinal) {
        return ((DaoAdiantamentoViagemImpl)this.getGenericDao()).buscarAdiantamentos(dataInicial, dataFinal);
    }

    @Async
    public CompletableFuture adiantamentosPorPeriodoAsync(Date dataInicial, Date dataFinal) {
        List<AdiantamentoViagem> adiantamentos = this.adiantamentosPorPeriodo(dataInicial, dataFinal);
        return CompletableFuture.completedFuture(adiantamentos);
    }

    public DTOAdiantamentoViagem calcularValorAdiantamento(DTOAdiantamentoViagem input, Long parametrizacao) throws ExceptionObjNotFound {
        ParametrizacaoAdiantamentoViagem parametrizacaoAdiantamentoViagem = (ParametrizacaoAdiantamentoViagem)this.serviceParametrizacaoAdiantamentoViagemImpl.getOrThrow(parametrizacao);
        Double valorAdiantamentoViagem = parametrizacaoAdiantamentoViagem.getDespesas().stream().mapToDouble(i -> i.getValorPrevisto()).sum();
        input.setValorAdiantamento(valorAdiantamentoViagem);
        return input;
    }
}

