/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.agenciavalores;

import com.touchcomp.basementor.model.impl.SaldoValorConta;
import com.touchcomp.basementor.model.vo.AgenciaValores;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorservice.dao.impl.DaoAgenciaValoresImpl;
import com.touchcomp.basementorservice.helpers.impl.agenciavalores.HelperAgenciaValores;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.agenciavalores.web.DTOSaldoContaValores;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAgenciaValoresImpl
extends ServiceGenericEntityImpl<AgenciaValores, Long, DaoAgenciaValoresImpl> {
    @Autowired
    private HelperAgenciaValores helper;

    @Autowired
    public ServiceAgenciaValoresImpl(DaoAgenciaValoresImpl dao) {
        super(dao);
    }

    @Override
    public AgenciaValores beforeSave(AgenciaValores entity) {
        for (ContaValores c : entity.getContaValores()) {
            c.setAgenciaValor(entity);
            for (CarteiraCobranca ca : c.getCarteiras()) {
                ca.setContaValor(c);
            }
        }
        return entity;
    }

    public List<DTOSaldoContaValores> findSaldoEmissao(Date dataInicial, Date dataFinal, ContaValores conta) {
        List<SaldoValorConta> vo = ((DaoAgenciaValoresImpl)this.getDao()).findSaldoEmissao(dataInicial, dataFinal, conta);
        return this.helper.toDto(vo);
    }

    public List<DTOSaldoContaValores> findSaldoCompensacao(Date dataInicial, Date dataFinal, ContaValores conta) {
        List<SaldoValorConta> vo = ((DaoAgenciaValoresImpl)this.getDao()).findSaldoCompensacao(dataInicial, dataFinal, conta);
        return this.helper.toDto(vo);
    }
}

