/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.aliquotast;

import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.aliquota.ExceptionAliquotaNaoEncontrada;
import com.touchcomp.basementorservice.dao.impl.DaoAliquotaStImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.categoriast.ServiceCategoriaStImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAliquotaStImpl
extends ServiceGenericEntityImpl<AliquotaSt, Long, DaoAliquotaStImpl> {
    @Autowired
    ServiceUnidadeFederativaImpl serviceUnidadeFederativa;
    @Autowired
    ServiceCategoriaStImpl serviceCategoriaSt;

    @Autowired
    public ServiceAliquotaStImpl(DaoAliquotaStImpl genericDao) {
        super(genericDao);
    }

    public AliquotaSt get(CategoriaSt cat, UnidadeFederativa ufDestino) {
        return ((DaoAliquotaStImpl)this.getGenericDao()).get(cat, ufDestino);
    }

    public AliquotaSt findByUF(UnidadeFederativa ufDestino) {
        return ((DaoAliquotaStImpl)this.getGenericDao()).findByUF(ufDestino);
    }

    public AliquotaSt get(Long cat, Long ufDestino) throws ExceptionAliquotaNaoEncontrada {
        UnidadeFederativa uf;
        CategoriaSt categoriaSt = (CategoriaSt)this.serviceCategoriaSt.get(cat);
        AliquotaSt aliquotaSt = this.get(categoriaSt, uf = (UnidadeFederativa)this.serviceUnidadeFederativa.get(ufDestino));
        if (aliquotaSt == null) {
            throw new ExceptionAliquotaNaoEncontrada("E.ERP.1066.016", new Object[]{categoriaSt != null ? categoriaSt.getNome() : "", uf.getSigla()});
        }
        return aliquotaSt;
    }
}

