/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analisecustoprod;

import com.touchcomp.basementor.constants.enums.analisecustoprod.EnumAnaCustoTipoProcDevolucoes;
import com.touchcomp.basementor.model.vo.AnaliseCustoProd;
import com.touchcomp.basementor.model.vo.AnaliseCustoProdLog;
import com.touchcomp.basementor.model.vo.BloqueioOSLinhaProd;
import com.touchcomp.basementor.model.vo.BloqueioOSSobEncomenda;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorservice.dao.impl.DaoAnaliseCustoProdImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.analisecustoprodlog.ServiceAnaliseCustoProdLogImpl;
import com.touchcomp.basementorservice.service.impl.devolucaovendas.ServiceProcCustoDevolucaoVendasImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ServiceAnaliseCustoProdImpl
extends ServiceGenericEntityImpl<AnaliseCustoProd, Long, DaoAnaliseCustoProdImpl> {
    private final ServiceAnaliseCustoProdLogImpl serviceAnaliseCustoProdLogImpl;
    private final ServiceProcCustoDevolucaoVendasImpl serviceProcCustoDevolucaoVendasImpl;

    public ServiceAnaliseCustoProdImpl(DaoAnaliseCustoProdImpl genericDao, ServiceAnaliseCustoProdLogImpl serviceAnaliseCustoProdLogImpl, ServiceProcCustoDevolucaoVendasImpl serviceProcCustoDevolucaoVendasImpl) {
        super(genericDao);
        this.serviceAnaliseCustoProdLogImpl = serviceAnaliseCustoProdLogImpl;
        this.serviceProcCustoDevolucaoVendasImpl = serviceProcCustoDevolucaoVendasImpl;
    }

    public List<Map<String, Object>> getValorHoraCelulasProd(Long idAnaliseCusto) {
        return ((DaoAnaliseCustoProdImpl)this.getGenericDao()).getValorHoraCelulasProd(idAnaliseCusto);
    }

    public AnaliseCustoProd processarAnaliseCustoProducao(AnaliseCustoProd analiseCustoProd, Usuario usuario) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        ((DaoAnaliseCustoProdImpl)this.getDao()).processarAnaliseProducao(analiseCustoProd);
        this.reprocessarNotasDevolucao(analiseCustoProd);
        return this.salvarLog(analiseCustoProd, usuario);
    }

    private AnaliseCustoProd salvarLog(AnaliseCustoProd analiseCustoProd, Usuario usuario) {
        AnaliseCustoProdLog l = analiseCustoProd.getAnaliseCustoProdLog();
        if (l == null) {
            l = new AnaliseCustoProdLog();
        }
        l.setAnaliseCustoProd(analiseCustoProd);
        l.setDataAplicacao(new Date());
        l.setUsuario(usuario);
        if (l.getBloqueioOSLinhaProd() == null) {
            BloqueioOSLinhaProd os = new BloqueioOSLinhaProd();
            os.setDataCadastro(new Date());
            os.setDescricao("Analise Custo Producao");
            os.setEmpresa(l.getAnaliseCustoProd().getEmpresa());
            l.setBloqueioOSLinhaProd(os);
        }
        if (l.getBloqueioOSSobEncomenda() == null) {
            BloqueioOSSobEncomenda enc = new BloqueioOSSobEncomenda();
            enc.setDataCadastro(new Date());
            enc.setDescricao("Analise Custo Producao");
            enc.setEmpresa(l.getAnaliseCustoProd().getEmpresa());
            l.setBloqueioOSSobEncomenda(enc);
        }
        l.getBloqueioOSLinhaProd().setDataBloqueio(l.getAnaliseCustoProd().getDataFinal());
        l.getBloqueioOSSobEncomenda().setDataBloqueio(l.getAnaliseCustoProd().getDataFinal());
        l = this.serviceAnaliseCustoProdLogImpl.saveOrUpdate(l);
        analiseCustoProd.setAnaliseCustoProdLog(l);
        return analiseCustoProd;
    }

    private void reprocessarNotasDevolucao(AnaliseCustoProd analiseCustoProd) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        if (TMethods.isEquals((Object)analiseCustoProd.getTipoProcDevolucoes(), (Object)EnumAnaCustoTipoProcDevolucoes.NAO_REPROCESSAR.getValue())) {
            return;
        }
        this.serviceProcCustoDevolucaoVendasImpl.reprocessarValorCustoNotasDevolucao(analiseCustoProd.getDataInicial(), analiseCustoProd.getDataFinal(), analiseCustoProd.getEmpresa(), EnumAnaCustoTipoProcDevolucoes.get((Object)analiseCustoProd.getTipoProcDevolucoes()));
    }
}

