/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseorcamentaria;

import com.touchcomp.basementor.constants.enums.filtroanaliseorcamentaria.EnumConstFiltroAnaliseOrcamentaria;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencialTipoData;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.impl.SaldoContaGerencial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentaria;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPer;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPerLinha;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentario;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItem;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItemPer;
import com.touchcomp.basementorexceptions.exceptions.impl.indicegerencial.ExceptionIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.estruturaorcamentaria.ServiceEstruturaOrcamentariaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.ServiceBuildIndiceGerencialImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.analiseorcamentaria.DTOAnaliseOrcamentariaEstrutura;
import com.touchcomp.touchvomodel.vo.analiseorcamentaria.DTOAnaliseOrcamentariaPlanejamento;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAnaliseOrcamentaria
extends ServiceGenericImpl {
    @Autowired
    ServiceBuildIndiceGerencialImpl serviceBuildGerencial;
    @Autowired
    ServiceEstruturaOrcamentariaImpl serviceEstruturaOrc;
    @Autowired
    ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl;
    @Autowired
    ServiceSaldoContaGerencialImpl serviceSaldoContaGerencialImpl;
    @Autowired
    ServiceGrupoEmpresaImpl serviceGrupoEmpresa;

    public DTOAnaliseOrcamentariaEstrutura buildEstruturaRealizada(EnumConstFiltroAnaliseOrcamentaria filtroEmpresa, Empresa loggedEmpresa, Long idEstrutura) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        EstruturaOrcamentaria est = (EstruturaOrcamentaria)this.serviceEstruturaOrc.get(idEstrutura);
        if (est == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1823.001", new Object[]{idEstrutura}));
        }
        DTOAnaliseOrcamentariaEstrutura analise = new DTOAnaliseOrcamentariaEstrutura();
        analise.setEstrutura(est.getDescricao());
        analise.setIdEstrutura(est.getIdentificador());
        analise.setIdIndiceGerencial(est.getIndiceGerencial().getIdentificador());
        analise.setEstrutura(est.getIndiceGerencial().getDescricao());
        EnumTipoLancamentoCTBGerencial tipoLancamentoCTBGerencial = EnumTipoLancamentoCTBGerencial.get((Object)this.getSharedData().getOpcoesGerenciais(loggedEmpresa).getGerarLancamentosGerenciaisAnaliseOrcamentaria());
        short index = 1;
        for (EstruturaOrcamentariaPer estPer : est.getEstruturaOrcamentariaPeriodos()) {
            IndiceGerencialParams params = new IndiceGerencialParams(est.getIndiceGerencial(), estPer.getIntervaloControleGerPer(), loggedEmpresa.getIdentificador(), loggedEmpresa.getIdentificador(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), tipoLancamentoCTBGerencial, Short.valueOf(EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue()), filtroEmpresa);
            params.setCalcularMeta(false);
            params.setCalcularProvisionado(false);
            System.out.println("\n\nCalculando " + estPer.getIntervaloControleGerPer().getDescricao() + "\n\n");
            IndiceGerencialCalculado calc = this.serviceBuildGerencial.calcularIndiceGerencial(params);
            DTOAnaliseOrcamentariaEstrutura.DTOAnaliseOrcamentariaEstrutPer per = new DTOAnaliseOrcamentariaEstrutura.DTOAnaliseOrcamentariaEstrutPer();
            per.setIdIntervaloControleGerPer(estPer.getIntervaloControleGerPer().getIdentificador());
            per.setIntervaloControleGerPer(estPer.getIntervaloControleGerPer().getDescricao());
            per.setDataIntervalo(estPer.getIntervaloControleGerPer().getDataFinal());
            analise.getValores().add(per);
            for (IndiceGerencialCalculado.LinhaIndice linha : calc.getLinhas()) {
                DTOAnaliseOrcamentariaEstrutura.DTOLinhaAnaliseEstrutura l = new DTOAnaliseOrcamentariaEstrutura.DTOLinhaAnaliseEstrutura();
                l.setDescricao(linha.getLinhaIndiceGerencial().getDescricao());
                l.setIdLinha(linha.getLinhaIndiceGerencial().getIdentificador());
                l.setNrLinha(linha.getLinhaIndiceGerencial().getIndice());
                l.setNegrito(linha.getLinhaIndiceGerencial().getNegrito());
                l.setIndice(Short.valueOf(index));
                Optional<EstruturaOrcamentariaPerLinha> optPerLinha = estPer.getEstruturaOrcamentariaPeriodos().stream().filter(i -> ToolMethods.isEquals((Object)i.getLinhaIndiceGerencial(), (Object)linha.getLinhaIndiceGerencial())).findFirst();
                if (!optPerLinha.isPresent()) {
                    throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1825.001", new Object[]{linha}));
                }
                EstruturaOrcamentariaPerLinha perLinha = optPerLinha.get();
                l.setValorOrcado(linha.getValorOrcado());
                l.setValorOrcadoCalcAtual(linha.getValorOrcado());
                l.setValorOrcado(perLinha.getValorCalculado());
                l.setValorRealizado(linha.getValor());
                l.setPercOrcadoRealizado(ToolNumber.calcDifPercentual((Double)l.getValorOrcado(), (Double)l.getValorRealizado()));
                per.getLinhas().add(l);
                index = (short)(index + 1);
            }
        }
        this.validarChegarInconsistencias(analise, est);
        return analise;
    }

    public DTOAnaliseOrcamentariaPlanejamento buildPlanejamento(Empresa loggedEmpresa, Long idPlanejamentoOrcamentario, EnumConstFiltroAnaliseOrcamentaria filtro) {
        PlanejamentoOrcamentario planejamento = (PlanejamentoOrcamentario)this.servicePlanejamentoOrcamentarioImpl.get(idPlanejamentoOrcamentario);
        if (planejamento == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1824.007", new Object[]{idPlanejamentoOrcamentario}));
        }
        LinkedList<PlanejamentoOrcamentarioItemPer> temp = new LinkedList<PlanejamentoOrcamentarioItemPer>();
        for (PlanejamentoOrcamentarioItem item : planejamento.getItens()) {
            for (PlanejamentoOrcamentarioItemPer perItem : item.getPeriodos()) {
                Optional<PlanejamentoOrcamentarioItemPer> found = temp.stream().filter(i -> ToolMethods.isEquals((Object)i.getIntervaloControleGerPer(), (Object)perItem.getIntervaloControleGerPer())).findFirst();
                if (found.isPresent()) continue;
                temp.add(perItem);
            }
        }
        DTOAnaliseOrcamentariaPlanejamento ret = new DTOAnaliseOrcamentariaPlanejamento();
        for (PlanejamentoOrcamentarioItemPer perItem : temp) {
            DTOAnaliseOrcamentariaPlanejamento.DTOPerAnalisePlanejamento p = new DTOAnaliseOrcamentariaPlanejamento.DTOPerAnalisePlanejamento();
            p.setDataIntervalo(perItem.getIntervaloControleGerPer().getDataFinal());
            p.setDescricaoIntervalo(perItem.getIntervaloControleGerPer().getDescricao());
            ret.getPeriodos().add(p);
            short index = 1;
            for (PlanejamentoOrcamentarioItem item : planejamento.getItens()) {
                Optional<PlanejamentoOrcamentarioItemPer> op;
                DTOAnaliseOrcamentariaPlanejamento.DTOLinhaAnalisePlanejamento linha = new DTOAnaliseOrcamentariaPlanejamento.DTOLinhaAnalisePlanejamento();
                linha.setIdLinha(item.getIdentificador());
                linha.setIndice(Short.valueOf(index));
                linha.setPlanoConta(item.getPlanoContaGerencial().getCodigo() + " - " + item.getPlanoContaGerencial().getDescricao());
                if (item.getCentroCusto() != null) {
                    linha.setCentroCusto(item.getCentroCusto().getCodigo() + " - " + item.getCentroCusto().getNome());
                }
                Double valorOrcado = (op = item.getPeriodos().stream().filter(x -> ToolMethods.isEquals((Object)x.getIntervaloControleGerPer(), (Object)perItem.getIntervaloControleGerPer())).findFirst()).isPresent() ? Math.abs(op.get().getValorOrcado()) : 0.0;
                linha.setValorOrcado(valorOrcado);
                Double valorRealizado = 0.0;
                if (ToolMethods.isEquals((Object)filtro, (Object)EnumConstFiltroAnaliseOrcamentaria.GRUPO_EMPRESA)) {
                    List<Empresa> empresas = this.serviceGrupoEmpresa.importarEmpresasGrupo(loggedEmpresa.getEmpresaDados().getGrupoEmpresa());
                    for (Empresa empresa : empresas) {
                        valorRealizado = valorRealizado + (op.isPresent() ? Math.abs(this.getSaldo(loggedEmpresa, op.get())) : 0.0);
                    }
                } else {
                    valorRealizado = op.isPresent() ? Math.abs(this.getSaldo(loggedEmpresa, op.get())) : 0.0;
                }
                linha.setValorRealizado(valorRealizado);
                linha.setPercOrcadoRealizado(ToolNumber.calcDifPercentual((Number)valorOrcado, (Number)valorRealizado, (int)2));
                p.getLinhas().add(linha);
                index = (short)(index + 1);
            }
        }
        ret.setDescricaoPlanejamento(planejamento.getDescricao());
        ret.setIdPlanejamento(planejamento.getIdentificador());
        return ret;
    }

    private Double getSaldo(Empresa loggedEmpresa, PlanejamentoOrcamentarioItemPer perItem) {
        SaldoContaGerencial saldo = this.serviceSaldoContaGerencialImpl.findSaldoGerencial(perItem.getIntervaloControleGerPer().getDataInicial(), perItem.getIntervaloControleGerPer().getDataFinal(), perItem.getPlanejamentoGerencialItem().getPlanoContaGerencial(), loggedEmpresa, EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA, EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue(), perItem.getPlanejamentoGerencialItem().getCentroCusto());
        return saldo.getSaldoAtual();
    }

    private void validarChegarInconsistencias(DTOAnaliseOrcamentariaEstrutura analise, EstruturaOrcamentaria est) {
        boolean aux;
        Long count = this.servicePlanejamentoOrcamentarioImpl.validarInconsistenciasAltIntervalo(est.getIntervaloControleGer());
        if (count > 0L) {
            analise.addOBS(MessagesBaseMentor.getErrorMsg((String)"", (Object[])new Object[0]));
        }
        if ((count = this.servicePlanejamentoOrcamentarioImpl.validarInconsistenciasAltPacote(est.getIntervaloControleGer())) > 0L) {
            analise.addOBS(MessagesBaseMentor.getErrorMsg((String)"", (Object[])new Object[0]));
        }
        if (aux = est.getDataAtualizacao().before(est.getIndiceGerencial().getDataAtualizacao())) {
            analise.addOBS(MessagesBaseMentor.getErrorMsg((String)"", (Object[])new Object[0]));
        }
        if (aux = est.getDataAtualizacao().before(est.getIntervaloControleGer().getDataAtualizacao())) {
            analise.addOBS(MessagesBaseMentor.getErrorMsg((String)"", (Object[])new Object[0]));
        }
    }
}

