/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseprecovenda;

import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelFunEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEncCaract;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelOutrosEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdEnc;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Optional;

public class AuxAnalisePrVendaProdSynchronizer
extends BaseMethods {
    public void replicarInformacoesAnaliseMaster(AnalisePrVendaProd master, AnalisePrVendaProd sub) throws ExceptionReflection {
        this.replicarDadosCelulas(master.getAnalisePrVendaPCPEnc(), sub.getAnalisePrVendaPCPEnc());
        this.replicarDadosCenarios(master, sub);
    }

    private void replicarDadosCenarios(AnalisePrVendaProd master, AnalisePrVendaProd sub) throws ExceptionReflection {
        if (AuxAnalisePrVendaProdSynchronizer.isWithData(master.getCenarios())) {
            for (AnalisePrVendaProdCen cenario : master.getCenarios()) {
                Optional<AnalisePrVendaProdCen> opt = sub.getCenarios().stream().filter(i -> this.isEquals(i.getTipoAnalise(), cenario.getTipoAnalise()) && this.isEquals(i.getAvaliadorExpressoes(), cenario.getAvaliadorExpressoes()) && this.isEquals(i.getDescricao(), cenario.getDescricao()) && this.isEquals(i.getAnalisePrVendaProdTab(), cenario.getAnalisePrVendaProdTab())).findAny();
                if (!opt.isEmpty()) continue;
                sub.getCenarios().add((AnalisePrVendaProdCen)ToolClone.cloneEntity((Object)cenario));
            }
        }
    }

    private void replicarDadosCelulas(AnalisePrVendaProdEnc master, AnalisePrVendaProdEnc sub) {
        if (AuxAnalisePrVendaProdSynchronizer.isWithData(master.getItensCelulaAnalPreco())) {
            for (AnalisePrVendaProdCelEnc m_cel : master.getItensCelulaAnalPreco()) {
                Optional<AnalisePrVendaProdCelEnc> opt = sub.getItensCelulaAnalPreco().stream().filter(i -> this.isEquals(i.getCelulaProdutiva(), m_cel.getCelulaProdutiva())).findFirst();
                AnalisePrVendaProdCelEnc s_cel = opt.isEmpty() ? new AnalisePrVendaProdCelEnc() : opt.get();
                this.putDataCelulas(m_cel, s_cel);
                this.replicarDadosMateriais(m_cel, s_cel);
                this.replicarDadosFuncoes(m_cel, s_cel);
                this.replicarDadosOutros(m_cel, s_cel);
                if (!opt.isEmpty()) continue;
                sub.getItensCelulaAnalPreco().add(s_cel);
            }
        } else {
            sub.getItensCelulaAnalPreco().clear();
        }
    }

    private void replicarDadosOutros(AnalisePrVendaProdCelEnc m_cel, AnalisePrVendaProdCelEnc s_cel) {
        if (AuxAnalisePrVendaProdSynchronizer.isWithData(m_cel.getItemOutros())) {
            for (AnalisePrVendaProdCelOutrosEnc m_out : m_cel.getItemOutros()) {
                AnalisePrVendaProdCelOutrosEnc s_out;
                Optional<AnalisePrVendaProdCelOutrosEnc> optOut = s_cel.getItemOutros().stream().filter(i -> TMethods.isEqualsIgnoreCase((String)i.getDescricao(), (String)m_out.getDescricao())).findFirst();
                if (optOut.isEmpty()) {
                    s_out = new AnalisePrVendaProdCelOutrosEnc();
                    this.putDataOutros(m_out, s_out);
                    s_cel.getItemOutros().add(s_out);
                    continue;
                }
                s_out = optOut.get();
                this.putDataOutros(m_out, s_out);
            }
        } else {
            s_cel.getItemOutros().clear();
        }
    }

    private void putDataOutros(AnalisePrVendaProdCelOutrosEnc m_out, AnalisePrVendaProdCelOutrosEnc s_out) {
        s_out.setAplicarQuantidadeAnalisada(m_out.getAplicarQuantidadeAnalisada());
        s_out.setDescricao(m_out.getDescricao());
        s_out.setObservacao(m_out.getObservacao());
        s_out.setQuantidade(m_out.getQuantidade());
        s_out.setValor(m_out.getValor());
        s_out.setValorTotal(m_out.getValorTotal());
        s_out.setValorUnitario(m_out.getValorUnitario());
    }

    private void replicarDadosFuncoes(AnalisePrVendaProdCelEnc m_cel, AnalisePrVendaProdCelEnc s_cel) {
        if (AuxAnalisePrVendaProdSynchronizer.isWithData(m_cel.getItemFunCelulas())) {
            for (AnalisePrVendaProdCelFunEnc m_fun : m_cel.getItemFunCelulas()) {
                AnalisePrVendaProdCelFunEnc s_fun;
                Optional<AnalisePrVendaProdCelFunEnc> optFun = s_cel.getItemFunCelulas().stream().filter(i -> this.isEquals(i.getFuncao(), m_fun.getFuncao())).findFirst();
                if (optFun.isEmpty()) {
                    s_fun = new AnalisePrVendaProdCelFunEnc();
                    this.putDataFuncao(m_fun, s_fun);
                    s_cel.getItemFunCelulas().add(s_fun);
                    continue;
                }
                s_fun = optFun.get();
                this.putDataFuncao(m_fun, s_fun);
            }
        } else {
            s_cel.getItemFunCelulas().clear();
        }
    }

    private void putDataFuncao(AnalisePrVendaProdCelFunEnc m_fun, AnalisePrVendaProdCelFunEnc s_fun) {
        s_fun.setConsiderarQtdAnalisada(m_fun.getConsiderarQtdAnalisada());
        s_fun.setFuncao(m_fun.getFuncao());
        s_fun.setNomeFuncao(m_fun.getNomeFuncao());
        s_fun.setObservacao(m_fun.getObservacao());
        s_fun.setQuantidade(m_fun.getQuantidade());
        s_fun.setTipoInfFuncao(m_fun.getTipoInfFuncao());
        s_fun.setValor(m_fun.getValor());
        s_fun.setValorTotal(m_fun.getValorTotal());
        s_fun.setValorUnitario(m_fun.getValorUnitario());
    }

    private void replicarDadosMateriais(AnalisePrVendaProdCelEnc m_cel, AnalisePrVendaProdCelEnc s_cel) {
        if (AuxAnalisePrVendaProdSynchronizer.isWithData(m_cel.getItemMatCelulas())) {
            for (AnalisePrVendaProdCelMatEnc m_mat : m_cel.getItemMatCelulas()) {
                Optional<AnalisePrVendaProdCelMatEnc> optMat = s_cel.getItemMatCelulas().stream().filter(i -> this.isEquals(i.getGradeCor(), m_mat.getGradeCor())).findFirst();
                AnalisePrVendaProdCelMatEnc s_mat = optMat.isEmpty() ? new AnalisePrVendaProdCelMatEnc() : optMat.get();
                this.putDataMaterial(m_mat, s_mat);
                if (optMat.isEmpty()) {
                    for (AnalisePrVendaProdCelMatEncCaract caracteristica : m_mat.getCaracteristicas()) {
                        AnalisePrVendaProdCelMatEncCaract aux = new AnalisePrVendaProdCelMatEncCaract();
                        this.putDataCaracteristicasMaterial(aux, caracteristica);
                        s_mat.getCaracteristicas().add(aux);
                    }
                    s_cel.getItemMatCelulas().add(s_mat);
                    continue;
                }
                for (AnalisePrVendaProdCelMatEncCaract caracteristica : m_mat.getCaracteristicas()) {
                    AnalisePrVendaProdCelMatEncCaract aux;
                    Optional<AnalisePrVendaProdCelMatEncCaract> optCaracMat = s_mat.getCaracteristicas().stream().filter(i -> this.isEquals(i.getChave(), caracteristica.getChave())).findFirst();
                    if (optCaracMat.isEmpty()) {
                        aux = new AnalisePrVendaProdCelMatEncCaract();
                        this.putDataCaracteristicasMaterial(aux, caracteristica);
                        s_mat.getCaracteristicas().add(aux);
                        continue;
                    }
                    aux = optCaracMat.get();
                    this.putDataCaracteristicasMaterial(aux, caracteristica);
                }
            }
        } else {
            s_cel.getItemMatCelulas().clear();
        }
    }

    private void putDataCelulas(AnalisePrVendaProdCelEnc m_cel, AnalisePrVendaProdCelEnc s_cel) {
        s_cel.setCelulaProdutiva(m_cel.getCelulaProdutiva());
        s_cel.setFormulacaoProduto(m_cel.getFormulacaoProduto());
        s_cel.setHorasExecucao(m_cel.getHorasExecucao());
        s_cel.setHorasSetup(m_cel.getHorasSetup());
        s_cel.setHorasTotais(m_cel.getHorasTotais());
        s_cel.setIndice(m_cel.getIndice());
        s_cel.setProdutoIntermediario(m_cel.getProdutoIntermediario());
        s_cel.setRoteiroProducao(m_cel.getRoteiroProducao());
        s_cel.setValorPrevisto(m_cel.getValorPrevisto());
        s_cel.setValorTotal(m_cel.getValorTotal());
    }

    private void putDataMaterial(AnalisePrVendaProdCelMatEnc m_mat, AnalisePrVendaProdCelMatEnc s_mat) {
        s_mat.setCodAuxiliarGrade(m_mat.getCodAuxiliarGrade());
        s_mat.setConsiderarQtdAnalisada(m_mat.getConsiderarQtdAnalisada());
        s_mat.setDescricaoGrade(m_mat.getDescricaoGrade());
        s_mat.setGradeCor(m_mat.getGradeCor());
        s_mat.setObservacao(m_mat.getObservacao());
        s_mat.setPesoBruto(m_mat.getPesoBruto());
        s_mat.setPesoLiquido(m_mat.getPesoLiquido());
        s_mat.setProducaoPropria(m_mat.getProducaoPropria());
        s_mat.setQuantidade(m_mat.getQuantidade());
        s_mat.setQuantidadeRef(m_mat.getQuantidadeRef());
        s_mat.setTipoGradeInf(m_mat.getTipoGradeInf());
        s_mat.setUnidMedidaGrade(m_mat.getUnidMedidaGrade());
        s_mat.setValor(m_mat.getValor());
        s_mat.setValorTotal(m_mat.getValorTotal());
        s_mat.setValorUnitario(m_mat.getValorUnitario());
        s_mat.setComprimento(m_mat.getComprimento());
        s_mat.setAltura(m_mat.getAltura());
        s_mat.setLargura(m_mat.getLargura());
        s_mat.setVolume(m_mat.getVolume());
    }

    private void putDataCaracteristicasMaterial(AnalisePrVendaProdCelMatEncCaract vo, AnalisePrVendaProdCelMatEncCaract source) {
        vo.setChave(source.getChave());
        vo.setValor(source.getValor());
    }
}

