/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseprecovenda;

import com.touchcomp.basementor.constants.enums.analisecusto.EnumConstTipoCusto;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabelaPrecosImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompAnalisePrVendaProd
extends ServiceGenericImpl {
    private final ServiceCalcTabelaPrecosImpl serviceCalcTabelaPrecos;
    private final CompEstoque compEstoque;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;

    @Autowired
    public SCompAnalisePrVendaProd(ServiceCalcTabelaPrecosImpl serviceCalcTabelaPrecos, CompEstoque compEstoque, ServiceSaldoEstoqueImpl serviceSaldoEstoque) {
        this.serviceCalcTabelaPrecos = serviceCalcTabelaPrecos;
        this.compEstoque = compEstoque;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
    }

    public void buscarValorUnitarioMaterial(AnalisePrVendaProdCelMatEnc itemMaterial, Empresa empresa, OpcoesFaturamento opcoesFaturamento, EnumConstTipoCusto tipoCusto) {
        switch (tipoCusto) {
            case PRECO_MEDIO: {
                Double b = this.serviceSaldoEstoque.findPrecoMedioProduto(itemMaterial.getGradeCor().getProdutoGrade().getProduto(), empresa, new Date(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
                itemMaterial.setValorUnitario(b);
                itemMaterial.setValor(Double.valueOf(itemMaterial.getValorUnitario() * itemMaterial.getQuantidade()));
                break;
            }
            case ULTIMO_CUSTO: {
                Double b = this.compEstoque.getUltimoCusto(itemMaterial.getGradeCor().getProdutoGrade().getProduto(), empresa);
                itemMaterial.setValorUnitario(b);
                itemMaterial.setValor(Double.valueOf(itemMaterial.getValorUnitario() * itemMaterial.getQuantidade()));
                break;
            }
            case VALOR_VENDA_TABELA_BASE: {
                Double b = this.serviceCalcTabelaPrecos.getValorVendaTabBaseUsoInterno(itemMaterial.getGradeCor().getProdutoGrade().getProduto(), new Date(), empresa, opcoesFaturamento.getMoeda());
                itemMaterial.setValorUnitario(b);
                itemMaterial.setValor(Double.valueOf(itemMaterial.getValorUnitario() * itemMaterial.getQuantidade()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

