/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseprecovenda;

import com.touchcomp.basementor.constants.enums.analisecusto.EnumConstTipoCusto;
import com.touchcomp.basementor.constants.enums.analiseprecovendaproduto.EnumConstAnalisePrecoVendaProduto;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.produto.EnumConstIdentificacaoProduto;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdEnc;
import com.touchcomp.basementor.model.vo.AvaliadorExpressoes;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.ConversorExpressoesDinamico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemKitProd;
import com.touchcomp.basementor.model.vo.KitProdutos;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.engenhariaprodutos.ExceptionEngProdutos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.dao.impl.DaoAnalisePrVendaProdImpl;
import com.touchcomp.basementorservice.helpers.impl.analiseprecovenda.HelperAnalisePrecoVenda;
import com.touchcomp.basementorservice.helpers.impl.gradecor.HelperGradeCor;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.AuxAnalisePrVendaProdSynchronizer;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.SCompAnalisePrVendaProd;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.ServiceAnalisePrecoVendaImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.UtilAnalisePrVendaImpMateriaisPlanilha;
import com.touchcomp.basementorservice.service.impl.analiseprvendaprodcelmatenc.ServiceAnalisePrVendaProdCelMatEncImpl;
import com.touchcomp.basementorservice.service.impl.analiseprvendaprodcen.ServiceAnalisePrVendaProdCenImpl;
import com.touchcomp.basementorservice.service.impl.analiseprvendaprodenc.ServiceAnalisePrVendaProdEncImpl;
import com.touchcomp.basementorservice.service.impl.analiseprvendaprodtab.ServiceAnalisePrVendaProdTabImpl;
import com.touchcomp.basementorservice.service.impl.avaliadorexpressoes.ServiceAvaliadorExpressoesImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.conversorexpressoesdinamico.ServiceConversorExpressoesDinamicoImpl;
import com.touchcomp.basementorservice.service.impl.formulacaofases.ServiceFormulacaoFasesImpl;
import com.touchcomp.basementorservice.service.impl.funcao.ServiceFuncaoImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.kitprodutos.ServiceKitProdutosImpl;
import com.touchcomp.basementorservice.service.impl.pretabelaprecobaseproduto.ServicePreTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProducaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.excel.ToolExcel;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.analiseprvendaprod.web.DTOAnalisePrVendaProd;
import com.touchcomp.touchvomodel.vo.analiseprvendaprod.web.DTOAnalisePrVendaProdSub;
import com.touchcomp.touchvomodel.vo.analiseprvendaprodtab.web.DTOAnalisePrVendaProdTab;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAnalisePrVendaProdImpl
extends ServiceGenericEntityImpl<AnalisePrVendaProd, Long, DaoAnalisePrVendaProdImpl> {
    private final ServiceProdutoImpl serviceProduto;
    private final ServiceTabelaPrecoBaseProdutoImpl serviceTabPrecoBaseProduto;
    private final ServicePreTabelaPrecoBaseProdutoImpl servicePreTabelaPrecoBaseProd;
    private final ServiceAnalisePrVendaProdCenImpl serviceAnalisePrVendaProdCen;
    private final ServiceAnalisePrecoVendaImpl serviceAnalisePreco;
    private final ServiceCelulaProdutivaImpl serviceCelulaProdutiva;
    private final ServiceGradeCorImpl serviceGradeCor;
    private final ServiceKitProdutosImpl serviceKitProdutos;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    private final ServiceFuncaoImpl serviceFuncao;
    private final ServiceAnalisePrVendaProdEncImpl serviceAnalisePrVendaProdEnc;
    private final ServiceAnalisePrVendaProdTabImpl serviceAnalisePrVendaProdTab;
    private final ServiceAvaliadorExpressoesImpl serviceAvaliadorExpressoes;
    private final ServiceConversorExpressoesDinamicoImpl serviceConversorExpressoesDinamico;
    private final ServiceAnalisePrVendaProdCelMatEncImpl serviceAnalisePrVendaProdCelMatEnc;
    private final HelperGradeCor helperGradeCor;
    private final HelperAnalisePrecoVenda helper;
    private final SCompAnalisePrVendaProd scomp;

    @Autowired
    public ServiceAnalisePrVendaProdImpl(DaoAnalisePrVendaProdImpl dao, ServiceProdutoImpl serviceProduto, ServiceTabelaPrecoBaseProdutoImpl serviceTabPrecoBaseProduto, ServicePreTabelaPrecoBaseProdutoImpl servicePreTabelaPrecoBaseProd, ServiceAnalisePrVendaProdCenImpl serviceAnalisePrVendaProdCen, ServiceAnalisePrecoVendaImpl serviceAnalisePreco, ServiceCelulaProdutivaImpl serviceCelulaProdutiva, ServiceGradeCorImpl serviceGradeCor, ServiceKitProdutosImpl serviceKitProdutos, ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceFuncaoImpl serviceFuncao, ServiceAnalisePrVendaProdEncImpl serviceAnalisePrVendaProdEnc, SCompAnalisePrVendaProd scomp, ServiceAnalisePrVendaProdTabImpl serviceAnalisePrVendaProdTab, ServiceAvaliadorExpressoesImpl serviceAvaliadorExpressoes, ServiceConversorExpressoesDinamicoImpl serviceConversorExpressoesDinamico, ServiceAnalisePrVendaProdCelMatEncImpl serviceAnalisePrVendaProdCelMatEnc, HelperGradeCor helperGradeCor, HelperAnalisePrecoVenda helper) {
        super(dao);
        this.serviceProduto = serviceProduto;
        this.serviceTabPrecoBaseProduto = serviceTabPrecoBaseProduto;
        this.servicePreTabelaPrecoBaseProd = servicePreTabelaPrecoBaseProd;
        this.serviceAnalisePrVendaProdCen = serviceAnalisePrVendaProdCen;
        this.serviceAnalisePreco = serviceAnalisePreco;
        this.serviceCelulaProdutiva = serviceCelulaProdutiva;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceKitProdutos = serviceKitProdutos;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceFuncao = serviceFuncao;
        this.serviceAnalisePrVendaProdEnc = serviceAnalisePrVendaProdEnc;
        this.serviceAnalisePrVendaProdTab = serviceAnalisePrVendaProdTab;
        this.serviceAvaliadorExpressoes = serviceAvaliadorExpressoes;
        this.serviceConversorExpressoesDinamico = serviceConversorExpressoesDinamico;
        this.serviceAnalisePrVendaProdCelMatEnc = serviceAnalisePrVendaProdCelMatEnc;
        this.helperGradeCor = helperGradeCor;
        this.helper = helper;
        this.scomp = scomp;
    }

    @Override
    public AnalisePrVendaProd beforeSaveEntity(AnalisePrVendaProd vo) {
        if (ServiceAnalisePrVendaProdImpl.isWithData(vo.getCenarios())) {
            for (AnalisePrVendaProdCen cen : vo.getCenarios()) {
                cen.setAnalisePrVendaProd(vo);
                if (this.isNotNull(cen.getAnalisePrVendaProdTab()).booleanValue()) {
                    if (ServiceAnalisePrVendaProdImpl.isWithData(cen.getAnalisePrVendaProdTab().getTabelaVariaveis())) {
                        cen.getAnalisePrVendaProdTab().getTabelaVariaveis().forEach(i -> i.setAnalisePrVendaProdTab(cen.getAnalisePrVendaProdTab()));
                    }
                    if (ServiceAnalisePrVendaProdImpl.isWithData(cen.getAnalisePrVendaProdTab().getAvaliadoresVinculados())) {
                        cen.getAnalisePrVendaProdTab().getAvaliadoresVinculados().forEach(i -> i.setAnalisePrVendaProdTab(cen.getAnalisePrVendaProdTab()));
                    }
                }
                if (!ServiceAnalisePrVendaProdImpl.isWithData(cen.getVariaveis())) continue;
                cen.getVariaveis().forEach(i -> i.setAnalisePrVendaProdCen(cen));
            }
        }
        if (ServiceAnalisePrVendaProdImpl.isWithData(vo.getAnalises())) {
            for (AnalisePrVendaProd analise : vo.getAnalises()) {
                this.beforeSaveEntity(analise);
                analise.setAnalisePai(vo);
            }
        }
        if (this.isNotNull(vo.getAnalisePrVendaPCPEnc()).booleanValue()) {
            this.serviceAnalisePrVendaProdEnc.beforeSaveEntity(vo.getAnalisePrVendaPCPEnc());
        }
        return vo;
    }

    public DTOAnalisePrVendaProd novaAnalise(Long produtoIdentificador, Empresa empresa) throws ExceptionObjNotFound {
        List<PreTabelaPrecoBaseProduto> preTabelas;
        AnalisePrVendaProd vo = new AnalisePrVendaProd();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(empresa);
        vo.setProduto((Produto)this.serviceProduto.getOrThrow(produtoIdentificador));
        vo.setDescricao(vo.getProduto().getNome());
        vo.setAnalisePrVendaPCPEnc(new AnalisePrVendaProdEnc());
        vo.setGradeCor(this.helperGradeCor.buscarGradePrincipalAtivoDoProduto(vo.getProduto()));
        List<TabelaPrecoBaseProduto> tabelas = this.serviceTabPrecoBaseProduto.getTabPrecoBaseProdsAtivos(vo.getProduto());
        if (ServiceAnalisePrVendaProdImpl.isWithData(tabelas)) {
            vo.setTabelaPrecoBaseProduto(tabelas.getFirst());
        }
        if (ServiceAnalisePrVendaProdImpl.isWithData(preTabelas = this.servicePreTabelaPrecoBaseProd.getPreTabPrecoBaseProdutos(vo.getProduto()))) {
            vo.setPreTabelaPrecoBaseProduto(preTabelas.getFirst());
        }
        return this.buildToDTO(vo, DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd atualizarTabelaProdutoAnalise(Long idTabelaPreco, DTOAnalisePrVendaProd dto) throws ExceptionObjNotFound {
        List<PreTabelaPrecoBaseProduto> preTabelas;
        AnalisePrVendaProd entity = (AnalisePrVendaProd)this.buildToEntity(dto);
        TabelaPrecoBaseProduto tabela = (TabelaPrecoBaseProduto)this.serviceTabPrecoBaseProduto.getOrThrow(idTabelaPreco);
        entity.setTabelaPrecoBaseProduto(tabela);
        entity.setProduto(entity.getTabelaPrecoBaseProduto().getProduto());
        entity.setDescricao(entity.getTabelaPrecoBaseProduto().getProduto().getNome());
        entity.setGradeCor(this.helperGradeCor.buscarGradePrincipalAtivoDoProduto(entity.getProduto()));
        if (this.isNull(entity.getAnalisePrVendaPCPEnc()).booleanValue()) {
            entity.setAnalisePrVendaPCPEnc(new AnalisePrVendaProdEnc());
        }
        if (ServiceAnalisePrVendaProdImpl.isWithData(preTabelas = this.servicePreTabelaPrecoBaseProd.getPreTabPrecoBaseProdutos(entity.getTabelaPrecoBaseProduto().getProduto()))) {
            entity.setPreTabelaPrecoBaseProduto(preTabelas.getFirst());
        }
        return this.buildToDTO(entity, DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd atualizarProdutoAnalise(Long idProduto, DTOAnalisePrVendaProd dto) throws ExceptionObjNotFound {
        AnalisePrVendaProd entity = (AnalisePrVendaProd)this.buildToEntity(dto);
        Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
        entity.setProduto(produto);
        entity.setDescricao(produto.getNome());
        entity.setTabelaPrecoBaseProduto(null);
        entity.setGradeCor(this.helperGradeCor.buscarGradePrincipalAtivoDoProduto(entity.getProduto()));
        if (this.isNull(entity.getAnalisePrVendaPCPEnc()).booleanValue()) {
            entity.setAnalisePrVendaPCPEnc(new AnalisePrVendaProdEnc());
        }
        return this.buildToDTO(entity, DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd criarAnalise(Double quantidade, DTOAnalisePrVendaProd dto) throws ExceptionReflection, ExceptionInvalidData {
        AnalisePrVendaProd vo = this.helper.cloneIt((AnalisePrVendaProd)this.buildToEntity(dto));
        if (this.isNotNull(vo).booleanValue()) {
            if (this.isNotNull(quantidade).booleanValue() && quantidade > 0.0) {
                vo.setQuantidade(quantidade);
            } else {
                vo.setQuantidade(Double.valueOf(1.0));
            }
            vo.setValorTotal(Double.valueOf(vo.getQuantidade() * vo.getValorTotal()));
            if (this.isNull(dto.getAnalises()).booleanValue()) {
                dto.setAnalises(new LinkedList());
            }
            dto.getAnalises().add(this.buildToDTOGeneric(vo, DTOAnalisePrVendaProdSub.class));
        }
        return dto;
    }

    public DTOAnalisePrVendaProd replicarDadosSubAnalises(DTOAnalisePrVendaProd dto) throws ExceptionReflection, ExceptionInvalidData {
        AnalisePrVendaProd vo = (AnalisePrVendaProd)this.buildToEntity(dto);
        List<AnalisePrVendaProdCen> cenariosEscolhidos = this.helper.getCenariosEscolhidos(vo);
        if (TMethods.isNull((Object)vo.getQuantidade()).booleanValue() || vo.getQuantidade() <= 0.0) {
            vo.setQuantidade(Double.valueOf(1.0));
        }
        vo.setValorTotal(Double.valueOf(vo.getQuantidade() * cenariosEscolhidos.getFirst().getResultado()));
        if (TMethods.isWithData((Collection)vo.getAnalises())) {
            for (AnalisePrVendaProd sub : vo.getAnalises()) {
                if (TMethods.isNull((Object)sub.getQuantidade()).booleanValue() || sub.getQuantidade() <= 0.0) {
                    sub.setQuantidade(Double.valueOf(1.0));
                }
                new AuxAnalisePrVendaProdSynchronizer().replicarInformacoesAnaliseMaster(vo, sub);
                sub.setValorTotal(Double.valueOf(cenariosEscolhidos.getFirst().getResultado() * sub.getQuantidade()));
                if (!TMethods.isNotNull((Object)sub.getAnalisePrVendaPCPEnc()).booleanValue()) continue;
                this.helper.recalcularVlrsPrevistosCel(sub.getAnalisePrVendaPCPEnc(), sub.getQuantidade());
                this.helper.calcularValorTotalOrcado(sub.getAnalisePrVendaPCPEnc(), sub.getQuantidade());
            }
        }
        return this.buildToDTOGeneric(vo, DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc processarFormulacaoFases(DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc dto, Empresa empresa, OpcoesFaturamento opcoesFaturamento, Long idFormulacao, Long idRoteiro, Double quantidade, Short tipoCusto) throws ExceptionObjNotFound {
        ServiceRoteiroProducaoImpl serviceRoteiroProducao = this.getBean(ServiceRoteiroProducaoImpl.class);
        ServiceFormulacaoFasesImpl serviceFormulacaoFases = this.getBean(ServiceFormulacaoFasesImpl.class);
        FormulacaoFases formulacao = (FormulacaoFases)serviceFormulacaoFases.getOrThrow(idFormulacao);
        RoteiroProducao roteiro = (RoteiroProducao)serviceRoteiroProducao.getOrThrow(idRoteiro);
        AnalisePrVendaProdEnc vo = (AnalisePrVendaProdEnc)this.serviceAnalisePrVendaProdEnc.buildToEntity(dto);
        this.helper.processarFormulacaoFases(vo, formulacao, roteiro, empresa, opcoesFaturamento, quantidade, EnumConstTipoCusto.get((Object)tipoCusto));
        return this.serviceAnalisePrVendaProdEnc.buildToDTO(vo, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc.class);
    }

    public DTOAnalisePrVendaProd recalcularAnalises(DTOAnalisePrVendaProd dto) throws ExceptionInvalidData {
        AnalisePrVendaProd vo = (AnalisePrVendaProd)this.buildToEntity(dto);
        return this.buildToDTO(this.helper.recalcularAnaliseSubAnalises(vo), DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd recalcularAnalise(DTOAnalisePrVendaProd dto) throws ExceptionInvalidData {
        AnalisePrVendaProd vo = (AnalisePrVendaProd)this.buildToEntity(dto);
        return this.buildToDTO(this.helper.recalcularValoresAnalise(vo), DTOAnalisePrVendaProd.class);
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen criarCenarioAnalise() {
        AnalisePrVendaProdCen vo = new AnalisePrVendaProdCen();
        vo.setTipoAnalise(EnumConstAnalisePrecoVendaProduto.PRECO_VENDA.getEnumId());
        vo.setResultado(Double.valueOf(0.0));
        return this.buildToDTOGeneric(vo, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen.class);
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen calcularCenario(DTOAnalisePrVendaProd dto, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionInvalidData, ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        AnalisePrVendaProd entity = (AnalisePrVendaProd)this.buildToEntity(dto);
        if (ServiceAnalisePrVendaProdImpl.isWithData(entity.getCenarios())) {
            DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen dtoCen = this.calcularMontarGraficoCenario(entity, (AnalisePrVendaProdCen)entity.getCenarios().getFirst(), emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
            return dtoCen;
        }
        throw new ExceptionInvalidData("E.ERP.2015.001", new Object[0]);
    }

    private DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen calcularMontarGraficoCenario(AnalisePrVendaProd entity, AnalisePrVendaProdCen cenario, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionInvalidData, ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        this.beforeSaveEntity(entity);
        this.serviceAnalisePreco.calcularCenario(entity, cenario, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
        DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen dtoCen = this.serviceAnalisePrVendaProdCen.buildToDTO(cenario, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen.class);
        this.helper.buildGraficos(entity, cenario, dtoCen);
        return dtoCen;
    }

    public DTOAnalisePrVendaProd calcularCenarios(DTOAnalisePrVendaProd dto, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionInvalidData, ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        AnalisePrVendaProd entity = (AnalisePrVendaProd)this.buildToEntity(dto);
        if (ServiceAnalisePrVendaProdImpl.isWithData(entity.getCenarios())) {
            this.beforeSaveEntity(entity);
            dto.getCenarios().clear();
            for (AnalisePrVendaProdCen cenario : entity.getCenarios()) {
                dto.getCenarios().add(this.calcularMontarGraficoCenario(entity, cenario, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP));
            }
            return dto;
        }
        throw new ExceptionInvalidData("E.ERP.2015.001", new Object[0]);
    }

    public void buildGraficos(DTOAnalisePrVendaProd dto) {
        AnalisePrVendaProd entity;
        if (this.isNotNull(dto).booleanValue() && ServiceAnalisePrVendaProdImpl.isWithData((entity = (AnalisePrVendaProd)this.buildToEntity(dto)).getCenarios())) {
            for (AnalisePrVendaProdCen cen : entity.getCenarios()) {
                Optional<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen> opt = dto.getCenarios().stream().filter(i -> this.isEquals(i.getIdentificador(), cen.getIdentificador())).findFirst();
                if (!opt.isPresent()) continue;
                this.helper.buildGraficos(entity, cen, opt.get());
            }
        }
    }

    public List<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelEnc> criarCelulas(Long[] identificadores) {
        List celulas = this.serviceCelulaProdutiva.gets(identificadores);
        LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelEnc> ret = new LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelEnc>();
        if (ServiceAnalisePrVendaProdImpl.isWithData(celulas)) {
            for (CelulaProdutiva cp : celulas) {
                ret.add(this.buildToDTOGeneric(this.helper.novaCelulaAnalise(cp), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelEnc.class));
            }
        }
        return ret;
    }

    public List<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc> importarMateriaisCelulaProd(Long[] identificadores, Empresa empresa, OpcoesFaturamento opcoesFaturamento, EnumConstTipoCusto tipoCusto) {
        List grades = this.serviceGradeCor.gets(identificadores);
        LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc> ret = new LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc>();
        if (ServiceAnalisePrVendaProdImpl.isWithData(grades)) {
            for (GradeCor gc : grades) {
                AnalisePrVendaProdCelMatEnc itemMaterial = this.helper.novoMaterialInfCelula(gc);
                this.scomp.buscarValorUnitarioMaterial(itemMaterial, empresa, opcoesFaturamento, tipoCusto);
                DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc dto = this.buildToDTOGeneric(this.helper.novoMaterialInfCelula(gc), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc.class);
                dto.setEstoque(this.buscarSaldoEstoqueMaterial(itemMaterial, empresa));
                ret.add(dto);
            }
        }
        return ret;
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc importarMateriaisCelulaProd() {
        return this.buildToDTOGeneric(this.helper.novoMaterialInfCelula(), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc.class);
    }

    public List<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc> importarKitsCelulaProd(Long[] identificadores, Empresa empresa, OpcoesFaturamento opcoesFaturamento, Double quantidade, EnumConstTipoCusto tipoCusto) {
        List kitProdutos = this.serviceKitProdutos.gets(identificadores);
        LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc> ret = new LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc>();
        if (ServiceAnalisePrVendaProdImpl.isWithData(kitProdutos)) {
            for (KitProdutos kitProd : kitProdutos) {
                for (ItemKitProd itemKit : kitProd.getItensKitProdutos()) {
                    AnalisePrVendaProdCelMatEnc itemMaterial = this.helper.novoMaterialKitCelula(kitProd, itemKit, quantidade);
                    this.scomp.buscarValorUnitarioMaterial(itemMaterial, empresa, opcoesFaturamento, tipoCusto);
                    DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc dto = this.buildToDTOGeneric(itemMaterial, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc.class);
                    dto.setEstoque(this.buscarSaldoEstoqueMaterial(itemMaterial, empresa));
                    ret.add(dto);
                }
            }
        }
        return ret;
    }

    public Double buscarSaldoEstoqueMaterial(AnalisePrVendaProdCelMatEnc itemMaterial, Empresa empresa) {
        SaldoEstoqueGeralBasico saldoEstoque = this.serviceSaldoEstoque.findSaldoGradeCor(itemMaterial.getGradeCor().getProdutoGrade().getProduto(), itemMaterial.getGradeCor(), new Date(), empresa, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (this.isNotNull(saldoEstoque).booleanValue()) {
            return saldoEstoque.getQuantidade();
        }
        return 0.0;
    }

    public List<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc> importarArquivoExcel(File file, EnumConstIdentificacaoProduto tipoPesquisa, Integer linhaInicial) throws ExceptionIO, ExceptionInvalidData, ExceptionParseObject {
        ExcelSheet sheet = ToolExcel.read((File)file);
        if (linhaInicial < 0 || linhaInicial > sheet.getRowsNumber()) {
            throw new ExceptionInvalidData("E.ERP.2015.002", new Object[0]);
        }
        List<AnalisePrVendaProdCelMatEnc> materiais = new UtilAnalisePrVendaImpMateriaisPlanilha(this.serviceProduto, this.helperGradeCor, this.helper).importarArquivoExcel(file, tipoPesquisa, linhaInicial);
        return this.buildToDTOGeneric(materiais, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc.class);
    }

    public List<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc> criarFuncoesCelula(Long[] identificadores) {
        LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc> ret = new LinkedList<DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc>();
        List funcoes = this.serviceFuncao.gets(identificadores);
        if (ServiceAnalisePrVendaProdImpl.isWithData(funcoes)) {
            for (Funcao fun : funcoes) {
                ret.add(this.buildToDTOGeneric(this.helper.novaFuncaoCelula(fun), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc.class));
            }
        }
        return ret;
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc criarFuncaoManualCelula() {
        return this.buildToDTOGeneric(this.helper.novaFuncaoCelula(), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelFunEnc.class);
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc atualizarValorPrevistoCelProdutiva(DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc input, Double quantidade) {
        AnalisePrVendaProdEnc vo = (AnalisePrVendaProdEnc)this.serviceAnalisePrVendaProdEnc.buildToEntity(input);
        return this.buildToDTOGeneric(this.helper.recalcularVlrsPrevistosCel(vo, quantidade), DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc.class);
    }

    public List<DTOAnalisePrVendaProdTab> buscarTabelaVariaveis(Long idAvaliadorExpressoes) throws ExceptionObjNotFound {
        AvaliadorExpressoes avaliadorExp = (AvaliadorExpressoes)this.serviceAvaliadorExpressoes.getOrThrow(idAvaliadorExpressoes);
        return this.buildToDTOGeneric(this.serviceAnalisePrVendaProdTab.getTabelaAvaliadores(avaliadorExp), DTOAnalisePrVendaProdTab.class);
    }

    public DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc calcularValorTotalOrcado(DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc input, Double quantidade) {
        AnalisePrVendaProdEnc vo = this.helper.calcularValorTotalOrcado((AnalisePrVendaProdEnc)this.serviceAnalisePrVendaProdEnc.buildToEntity(input), quantidade);
        return this.buildToDTOGeneric(vo, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdEnc.class);
    }

    public Double buildResultadoExpressao(DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCelMatEnc input, Long idConversorExpressoesDinamico) throws ExceptionInvalidData, ExceptionObjNotFound {
        ConversorExpressoesDinamico conversorExpDinamico = (ConversorExpressoesDinamico)this.serviceConversorExpressoesDinamico.getOrThrow(idConversorExpressoesDinamico);
        AnalisePrVendaProdCelMatEnc source = (AnalisePrVendaProdCelMatEnc)this.serviceAnalisePrVendaProdCelMatEnc.buildToEntity(input);
        return this.serviceConversorExpressoesDinamico.getResultadoExpressao(conversorExpDinamico, input.getTokensExpressao(), source);
    }

    public DTOAnalisePrVendaProd clonarAnalise(Long identificador) throws ExceptionObjNotFound, ExceptionReflection {
        AnalisePrVendaProd source = (AnalisePrVendaProd)this.getOrThrow(identificador);
        AnalisePrVendaProd result = (AnalisePrVendaProd)ToolClone.cloneEntity((Object)source);
        return this.buildToDTO(result, DTOAnalisePrVendaProd.class);
    }
}

