/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseprecovenda;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstCustoPcpTpAnaCusto;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstCustoPcpTpCapProdutiva;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstTipoPesq;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCenVar;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdTab;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdValor;
import com.touchcomp.basementor.model.vo.AvaliadorExpFormulas;
import com.touchcomp.basementor.model.vo.AvaliadorExpressoes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBasePadAnaPr;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.engenhariaprodutos.ExceptionEngProdutos;
import com.touchcomp.basementorservice.components.analiseprecovenda.CompAnalisePrecoVenda;
import com.touchcomp.basementorservice.components.avaliadorexpressoes.CompAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.service.impl.buildcustoprodlinhaprod.ServiceBuildCustoProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstAvaliacaoExpTpToken;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAnalisePrecoVendaImpl {
    @Autowired
    CompAnalisePrecoVenda compAnalisePrecoVenda;

    public AnalisePrVendaProd calcular(AnalisePrVendaProd vo, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        for (AnalisePrVendaProdCen cenario : vo.getCenarios()) {
            this.calcularCenario(vo, cenario, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
        }
        return vo;
    }

    public List calcular(List<TabelaPrecoBasePadAnaPr> itensTabPreco, List<TabelaPrecoBaseProduto> produtosTabPreco, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, Double toleranciaAbaixo, Double toleranciaAcima, boolean atualizarParametros, OpcoesPCP opcoesPCP) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        List<TabelaPrecoBaseProduto> itensTab = produtosTabPreco;
        for (TabelaPrecoBaseProduto tp : itensTab) {
            this.analisarCriarItem(tp, itensTabPreco, emp, toleranciaAbaixo, toleranciaAcima, atualizarParametros);
            this.calcular(tp.getAnalisePrecoVendaProd(), emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
        }
        return produtosTabPreco;
    }

    public void calcularCenario(AnalisePrVendaProd vo, AnalisePrVendaProdCen cenario, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        Map values = this.buildMap(vo, cenario, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
        if (TMethods.isAffirmative((Number)cenario.getInformarManual())) {
            Optional<AnalisePrVendaProdValor> found;
            if (TMethods.isNotNull((Object)cenario.getAnalisePrVendaProdTab()).booleanValue() && (found = cenario.getAnalisePrVendaProdTab().getTabelaVariaveis().stream().filter(i -> i.getAvalExpressoesAnaVenda() != null).findFirst()).isPresent()) {
                AnalisePrVendaProdValor ana = found.get();
                DTOResultCalcExpressoes result = CompAvaliadorExpressoes.processAndValidateValue(found.get().getAvalExpressoesAnaVenda(), values);
                if (result.getResultado().isInfinite() || result.getResultado().isNaN()) {
                    result.setResultado(Double.valueOf(0.0));
                }
                result.getPreExpressoes().forEach(i -> this.setOrAddVar(cenario, (DTOResultCalcExpressoes.DTOToken)i));
                AnalisePrVendaProdCenVar var = this.setOrAddVar(cenario, ana.getChave(), ana.getValor(), EnumConstAvaliacaoExpTpToken.CONSTANTE_AVALIACAO);
                if (var != null) {
                    var.setValor(result.getResultado());
                }
            }
        } else if (TMethods.isNotNull((Object)cenario.getAvaliadorExpressoes()).booleanValue()) {
            DTOResultCalcExpressoes result = CompAvaliadorExpressoes.processAndValidateValue(cenario.getAvaliadorExpressoes(), values);
            if (result.getResultado().isInfinite() || result.getResultado().isNaN()) {
                result.setResultado(Double.valueOf(0.0));
            }
            cenario.setResultado(result.getResultado());
            result.getPreExpressoes().forEach(i -> this.setOrAddVar(cenario, (DTOResultCalcExpressoes.DTOToken)i));
        }
    }

    private AnalisePrVendaProdCenVar setOrAddVar(AnalisePrVendaProdCen cenario, DTOResultCalcExpressoes.DTOToken token) {
        return this.setOrAddVar(cenario, token.getChave(), token.getValor(), token.getTipo());
    }

    private AnalisePrVendaProdCenVar setOrAddVar(AnalisePrVendaProdCen cenario, String chave, Double valor, EnumConstAvaliacaoExpTpToken tipo) {
        if (cenario == null || cenario.getVariaveis() == null) {
            return null;
        }
        AnalisePrVendaProdCenVar var = null;
        Optional<AnalisePrVendaProdCenVar> found = cenario.getVariaveis().stream().filter(i -> TMethods.isEquals((Object)i.getDescricao(), (Object)chave)).findFirst();
        if (found.isPresent()) {
            var = found.get();
        }
        if (var == null) {
            var = new AnalisePrVendaProdCenVar();
            var.setDescricao(chave);
            var.setAnalisePrVendaProdCen(cenario);
            var.setValor(valor);
            var.setTipo(Short.valueOf(tipo.getValue()));
            cenario.getVariaveis().add(var);
        }
        return var;
    }

    private Map buildMap(AnalisePrVendaProd vo, AnalisePrVendaProdCen cenario, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP) throws ExceptionEngProdutos {
        List<StringToken> tokens;
        HashMap<String, Object> h = new HashMap<String, Object>();
        if (cenario.getAnalisePrVendaProd().getProduto() != null) {
            h.put(Produto.class.getCanonicalName(), cenario.getAnalisePrVendaProd().getProduto());
        }
        h.put(Empresa.class.getCanonicalName(), emp);
        h.put(OpcoesFinanceiras.class.getCanonicalName(), opFinanceiras);
        h.put(TabelaPrecoBaseProduto.class.getCanonicalName(), cenario.getAnalisePrVendaProd().getTabelaPrecoBaseProduto());
        h.put(PreTabelaPrecoBaseProduto.class.getCanonicalName(), cenario.getAnalisePrVendaProd().getPreTabelaPrecoBaseProduto());
        h.put(OpcoesFaturamento.class.getCanonicalName(), opFaturamento);
        h.put(OpcoesVendas.class.getCanonicalName(), opVendas);
        h.put(OpcoesPCP.class.getCanonicalName(), opcoesPCP);
        h.put(AnalisePrVendaProdTab.class.getCanonicalName(), cenario.getAnalisePrVendaProdTab());
        if (cenario.getAnalisePrVendaProdTab() != null) {
            for (AnalisePrVendaProdValor tab : cenario.getAnalisePrVendaProdTab().getTabelaVariaveis()) {
                h.put(tab.getChave(), tab.getValor());
            }
        }
        if (cenario.getVariaveis() != null) {
            for (AnalisePrVendaProdValor tab : cenario.getVariaveis()) {
                h.put(tab.getDescricao(), tab.getValor());
            }
        }
        if (this.contains(tokens = this.getAllTokens(cenario.getAvaliadorExpressoes()), "preco_medio_prod") && cenario.getAnalisePrVendaProd().getProduto() != null) {
            h.put("preco_medio_prod", this.getCustoMedioProd(cenario.getAnalisePrVendaProd().getProduto(), emp));
        }
        if (this.contains(tokens, "preco_medio_prod") && cenario.getAnalisePrVendaProd().getProduto() != null) {
            h.put("preco_medio_prod", this.getUltPrecoCustoCompra(cenario.getAnalisePrVendaProd().getProduto(), emp));
            h.put("preco_medio_prod", this.getUltPrecoCustoCompra(cenario.getAnalisePrVendaProd().getProduto(), emp));
        }
        if ((this.contains(tokens, "custo_pcp_linha_prod_prod_pr_medio") || this.contains(tokens, "custo_pcp_linha_prod_prod_ult_custo")) && cenario.getAnalisePrVendaProd().getProduto() != null) {
            this.putValoresCustoLinhaProd(cenario.getAnalisePrVendaProd().getProduto(), emp, opcoesPCP, h);
        }
        if (this.contains(tokens, "valor_custo_pcp_analise") && vo.getAnalisePrVendaPCPEnc() != null) {
            h.put("valor_custo_pcp_analise", vo.getAnalisePrVendaPCPEnc().getValorTotal());
        }
        h.put("valor_venda_inf_cenario_manual", 0.0);
        if (TMethods.isAffirmative((Number)cenario.getInformarManual())) {
            h.put("valor_venda_inf_cenario_manual", cenario.getResultado());
        }
        return h;
    }

    private Object getCustoMedioProd(Produto produto, Empresa empresa) {
        ServiceSaldoEstoqueImpl service = (ServiceSaldoEstoqueImpl)Context.get(ServiceSaldoEstoqueImpl.class);
        return service.findPrecoMedioIdProduto(produto.getIdentificador(), empresa.getIdentificador(), new Date());
    }

    private Object getUltPrecoCustoCompra(Produto produto, Empresa empresa) {
        CompEstoque compEstoque = (CompEstoque)Context.get(CompEstoque.class);
        Double vlr = compEstoque.getUltimoCusto(produto, empresa);
        return vlr;
    }

    private void analisarCriarItem(TabelaPrecoBaseProduto tp, List<TabelaPrecoBasePadAnaPr> padroes, Empresa empresa, Double toleranciaAbaixo, Double toleranciaAcima, boolean atualizarParametros) {
        AnalisePrVendaProd pr = tp.getAnalisePrecoVendaProd();
        boolean isNew = false;
        if (pr == null) {
            pr = this.compAnalisePrecoVenda.novaAnalise(empresa, tp.getProduto(), false);
            pr.setTabelaPrecoBaseProduto(tp);
            tp.setAnalisePrecoVendaProd(pr);
            isNew = true;
        }
        if (isNew || atualizarParametros) {
            pr.setToleranciaPrecoAbaixo(toleranciaAbaixo);
            pr.setToleranciaPrecoAcima(toleranciaAcima);
        }
        AnalisePrVendaProd temp = pr;
        padroes.forEach(item -> {
            Optional<AnalisePrVendaProdCen> found = temp.getCenarios().stream().filter(i -> Objects.equals(i.getAvaliadorExpressoes(), item.getAvaliadorExpressoes()) && Objects.equals(i.getAnalisePrVendaProdTab(), item.getTabelaVariaveis())).findFirst();
            if (!found.isPresent()) {
                AnalisePrVendaProdCen cen = new AnalisePrVendaProdCen();
                cen.setAnalisePrVendaProd(temp);
                cen.setAnalisePrVendaProdTab(item.getTabelaVariaveis());
                cen.setAvaliadorExpressoes(item.getAvaliadorExpressoes());
                cen.setDescricao(item.getDescricao());
                temp.getCenarios().add(cen);
            }
        });
        Optional<AnalisePrVendaProdCen> cenarioEsc = temp.getCenarios().stream().filter(i -> i.getCenarioEscolhido() == 1).findFirst();
        Optional<TabelaPrecoBasePadAnaPr> padraoSug = padroes.stream().filter(i -> i.getSugerido() == 1).findFirst();
        for (AnalisePrVendaProdCen cenario : pr.getCenarios()) {
            if (cenarioEsc.isPresent() && !atualizarParametros || !padraoSug.isPresent() || !cenario.getAvaliadorExpressoes().equals((Object)padraoSug.get().getAvaliadorExpressoes())) continue;
            cenario.setCenarioEscolhido(Short.valueOf((short)1));
            break;
        }
    }

    private void putValoresCustoLinhaProd(Produto produto, Empresa emp, OpcoesPCP opcoesPCP, Map h) throws ExceptionEngProdutos {
        ServiceBuildCustoProdLinhaProdImpl service = (ServiceBuildCustoProdLinhaProdImpl)ConfApplicationContext.getBean(ServiceBuildCustoProdLinhaProdImpl.class);
        List<VOEngenhariaProdutos> dados = service.calcularEngenhariaProdutos(new Date(), new Date(), new Date(), 1.0, 999, EnumConstCustoPcpTpAnaCusto.ANALISAR_POR_CELULA, null, EnumConstTipoPesq.PRODUTO, produto.getIdentificador(), produto.getIdentificador(), null, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, EnumConstCustoPcpTpCapProdutiva.TP_ANAL_CAP_PROD_ROTEIRO_PROD, null, emp, 100.0, EnumConstantsMentorSimNao.NAO, 0L, 999L, EnumConstantsMentorSimNao.NAO, 0L, 999L, EnumConstantsMentorSimNao.SIM);
        if (dados.isEmpty()) {
            h.put("custo_pcp_linha_prod_prod_pr_medio", 0.0);
            h.put("custo_pcp_linha_prod_prod_ult_custo", 0.0);
        } else {
            h.put("custo_pcp_linha_prod_prod_ult_custo", dados.get(0).getTotalGeralUltPrecoCusto());
            h.put("custo_pcp_linha_prod_prod_pr_medio", dados.get(0).getTotalGeralUltPrecoMedio());
        }
    }

    private List<StringToken> getAllTokens(AvaliadorExpressoes avaliadorExpressoes) {
        HashSet s = new HashSet();
        if (TMethods.isNotNull((Object)avaliadorExpressoes).booleanValue()) {
            for (AvaliadorExpFormulas formula : avaliadorExpressoes.getFormulas()) {
                s.addAll(ToolString.getReplaceTokens((String)formula.getCondAplicacao()));
                s.addAll(ToolString.getReplaceTokens((String)formula.getFormula()));
            }
        }
        return new ArrayList<StringToken>(s);
    }

    private boolean contains(List<StringToken> tokens, String token) {
        Optional<StringToken> opt = tokens.stream().filter(i -> i.getChave().equalsIgnoreCase(token)).findAny();
        return opt.isPresent();
    }
}

