/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.analiseprecovenda;

import com.touchcomp.basementor.constants.enums.produto.EnumConstIdentificacaoProduto;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorservice.helpers.impl.analiseprecovenda.HelperAnalisePrecoVenda;
import com.touchcomp.basementorservice.helpers.impl.gradecor.HelperGradeCor;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.excel.ToolExcel;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class UtilAnalisePrVendaImpMateriaisPlanilha {
    private final ServiceProdutoImpl serviceProduto;
    private final HelperGradeCor helperGradeCor;
    private final HelperAnalisePrecoVenda helperAnalisePrVenda;

    public UtilAnalisePrVendaImpMateriaisPlanilha(ServiceProdutoImpl serviceProduto, HelperGradeCor helperGradeCor, HelperAnalisePrecoVenda helperAnalisePrVenda) {
        this.serviceProduto = serviceProduto;
        this.helperGradeCor = helperGradeCor;
        this.helperAnalisePrVenda = helperAnalisePrVenda;
    }

    public List<AnalisePrVendaProdCelMatEnc> importarArquivoExcel(File file, EnumConstIdentificacaoProduto tipoPesquisa, Integer linhaInicial) throws ExceptionIO, ExceptionInvalidData, ExceptionParseObject {
        ExcelSheet sheet = ToolExcel.read((File)file);
        if (linhaInicial < 0 || linhaInicial > sheet.getRowsNumber()) {
            throw new ExceptionInvalidData("E.ERP.2015.002", new Object[0]);
        }
        LinkedList<AnalisePrVendaProdCelMatEnc> ret = new LinkedList<AnalisePrVendaProdCelMatEnc>();
        for (int i = linhaInicial.intValue(); i < sheet.getRowsNumber(); ++i) {
            AnalisePrVendaProdCelMatEnc material;
            ExcelSheet.Row row = (ExcelSheet.Row)sheet.getRows().get(i);
            if (row.getCellsSize() < 5) continue;
            String identificacaoProd = row.getCellAsString(0);
            Produto produto = null;
            switch (tipoPesquisa) {
                case CODIGO_AUXILIAR: {
                    produto = this.serviceProduto.getByCodigoAuxiliar(this.getCodigoAuxiliar(identificacaoProd));
                    break;
                }
                case IDENTIFICADOR: {
                    produto = (Produto)this.serviceProduto.get(this.getIdentificadorProduto(identificacaoProd));
                    break;
                }
                default: {
                    throw new AssertionError((Object)tipoPesquisa.name());
                }
            }
            if (produto == null || !ToolMethods.isNotNull((Object)(material = this.criarMaterialPlanilhaExcel(produto, row))).booleanValue()) continue;
            ret.add(material);
        }
        return ret;
    }

    private String getCodigoAuxiliar(String input) {
        if (ToolString.isADoubleNumber((String)input)) {
            return String.valueOf((int)Double.parseDouble(input));
        }
        if (ToolString.isADoubleNumberPT((String)input)) {
            return String.valueOf((int)Double.parseDouble(input.replace(",", ".")));
        }
        return ToolString.refina((String)input);
    }

    private Double getDoubleValue(String input) {
        if (ToolString.isADoubleNumber((String)input)) {
            return Double.valueOf(input);
        }
        if (ToolString.isADoubleNumberPT((String)input)) {
            return Double.valueOf(input.replace(",", "."));
        }
        return 1.0;
    }

    private Long getIdentificadorProduto(String input) {
        if (ToolString.isADoubleNumber((String)input)) {
            return Double.valueOf(input).longValue();
        }
        if (ToolString.isADoubleNumberPT((String)input)) {
            return Double.valueOf(input.replace(",", ".")).longValue();
        }
        if (ToolString.isALongNumber((String)input)) {
            return Long.valueOf(input);
        }
        return 0L;
    }

    private AnalisePrVendaProdCelMatEnc criarMaterialPlanilhaExcel(Produto produto, ExcelSheet.Row row) throws ExceptionParseObject {
        Double quantidade = this.getDoubleValue(row.getCellAsString(1));
        Double quantidadeRef = this.getDoubleValue(row.getCellAsString(2));
        Double comprimento = this.getDoubleValue(row.getCellAsString(3));
        Double altura = this.getDoubleValue(row.getCellAsString(4));
        Double largura = this.getDoubleValue(row.getCellAsString(5));
        AnalisePrVendaProdCelMatEnc i = new AnalisePrVendaProdCelMatEnc();
        i.setDescricaoGrade(produto.getNome());
        i.setCodAuxiliarGrade(produto.getCodigoAuxiliar());
        i.setUnidMedidaGrade(produto.getUnidadeMedida().getSigla());
        i.setGradeCor(this.helperGradeCor.buscarGradePrincipalAtivoDoProduto(produto));
        i.setQuantidade(quantidade);
        i.setAltura(altura);
        i.setComprimento(comprimento);
        i.setLargura(largura);
        i.setQuantidadeRef(quantidadeRef);
        if (ToolMethods.isNotNull((Object)i.getAltura()).booleanValue() && ToolMethods.isNotNull((Object)i.getComprimento()).booleanValue() && ToolMethods.isNotNull((Object)i.getLargura()).booleanValue()) {
            i.setVolume(Double.valueOf(i.getAltura() * i.getComprimento() * i.getLargura()));
        }
        this.helperAnalisePrVenda.sugerirPesoMaterial(i);
        return i;
    }
}

