/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaoanaliseleite;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ApuracaoAnaliseLeite;
import com.touchcomp.basementor.model.vo.ItemApuracaoAnaliseLeite;
import com.touchcomp.basementor.model.vo.ProducaoApuracaoAnaliseLeite;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoApuracaoAnaliseLeiteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.pontoanaliseleite.ServicePontoAnaliseLeiteImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.apuracaoanaliseleite.web.DTOApuracaoAnaliseLeite;
import com.touchcomp.touchvomodel.vo.itemapuracaoanaliseleite.web.DTOItemApuracaoAnaliseLeite;
import com.touchcomp.touchvomodel.vo.producaoapuracaoanaliseleite.web.DTOProducaoApuracaoAnaliseLeite;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceApuracaoAnaliseLeiteImpl
extends ServiceGenericEntityImpl<ApuracaoAnaliseLeite, Long, DaoApuracaoAnaliseLeiteImpl> {
    ServicePontoAnaliseLeiteImpl servicePontoAnaliseLeiteImpl;

    @Autowired
    public ServiceApuracaoAnaliseLeiteImpl(DaoApuracaoAnaliseLeiteImpl dao, ServicePontoAnaliseLeiteImpl servicePontoAnaliseLeiteImpl) {
        super(dao);
        this.servicePontoAnaliseLeiteImpl = servicePontoAnaliseLeiteImpl;
    }

    @Override
    public ApuracaoAnaliseLeite beforeSaveEntity(ApuracaoAnaliseLeite vo) {
        vo.getItensApuracao().forEach(i -> i.setApuracaoAnaliseLeite(vo));
        vo.getProducaoApuracao().forEach(i -> i.setApuracaoAnaliseLeite(vo));
        return vo;
    }

    public DTOApuracaoAnaliseLeite getCarregarTodos(DTOApuracaoAnaliseLeite input) {
        List pontoAnaliseLeite = this.servicePontoAnaliseLeiteImpl.findAllAtivos();
        List itemApuracaoAnaliseLeites = pontoAnaliseLeite.stream().filter(ponto -> input.getItensApuracao().stream().noneMatch(dto -> this.isEquals(dto.getPontoAnaliseLeiteIdentificador(), ponto.getIdentificador()))).map(i -> {
            ItemApuracaoAnaliseLeite item = new ItemApuracaoAnaliseLeite();
            item.setPontoAnaliseLeite(i);
            return item;
        }).collect(Collectors.toList());
        input.getItensApuracao().addAll(this.buildToDTOGeneric(itemApuracaoAnaliseLeites, DTOItemApuracaoAnaliseLeite.class));
        if (this.isNotNull(input.getDataInicial()).booleanValue() && this.isNotNull(input.getDataFinal()).booleanValue()) {
            List producaoApuracaoAnaliseLeite = Stream.iterate(ToolDate.dataSemHora((Date)input.getDataInicial()), data -> !data.after(ToolDate.dataSemHora((Date)input.getDataFinal())), data -> ToolDate.nextDays((Date)data, (int)1)).filter(data -> input.getProducaoApuracao().stream().noneMatch(dto -> dto.getDataProducao().equals(data))).map(data -> {
                ProducaoApuracaoAnaliseLeite item = new ProducaoApuracaoAnaliseLeite();
                item.setDataProducao(data);
                return item;
            }).collect(Collectors.toList());
            input.getProducaoApuracao().addAll(this.buildToDTOGeneric(producaoApuracaoAnaliseLeite, DTOProducaoApuracaoAnaliseLeite.class));
        }
        return input;
    }

    public List<DTOItemApuracaoAnaliseLeite> getAdicionarItemApuracao(Long[] ids) {
        List pontoAnaliseLeite = this.servicePontoAnaliseLeiteImpl.gets(ids);
        List itemApuracaoAnaliseLeites = pontoAnaliseLeite.stream().filter(ponto -> this.isEquals(ponto.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue())).map(i -> {
            ItemApuracaoAnaliseLeite item = new ItemApuracaoAnaliseLeite();
            item.setPontoAnaliseLeite(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemApuracaoAnaliseLeites, DTOItemApuracaoAnaliseLeite.class);
    }

    public DTOProducaoApuracaoAnaliseLeite getAdicionarProducaoApuracao(Long data) {
        Date dataProducao = new Date(data);
        if (this.isNull(dataProducao).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1804.001"));
        }
        ProducaoApuracaoAnaliseLeite producaoApuracaoAnaliseLeite = new ProducaoApuracaoAnaliseLeite();
        producaoApuracaoAnaliseLeite.setDataProducao(dataProducao);
        return this.buildToDTOGeneric(producaoApuracaoAnaliseLeite, DTOProducaoApuracaoAnaliseLeite.class);
    }
}

