/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaocustoprovisao;

import com.touchcomp.basementor.model.vo.ApuracaoCustoProvisao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemCustoMensalColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoApuracaoCustoProvisaoImpl;
import com.touchcomp.basementorservice.helpers.impl.apuracaocustomensal.HelperApuracaoCustoMensal;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.calculoinssempresa.CalculoInssEmpresaService;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceApuracaoCustoProvisaoImpl
extends ServiceGenericEntityImpl<ApuracaoCustoProvisao, Long, DaoApuracaoCustoProvisaoImpl> {
    @Autowired
    private HelperApuracaoCustoMensal helper;
    @Autowired
    CalculoInssEmpresaService serviceCalcInssEmp;
    @Autowired
    ServiceMovimentoFolhaImpl serviceMovFolha;

    @Autowired
    public ServiceApuracaoCustoProvisaoImpl(DaoApuracaoCustoProvisaoImpl dao) {
        super(dao);
    }

    @Override
    public ApuracaoCustoProvisao beforeSave(ApuracaoCustoProvisao vo) {
        if (vo.getItensCusto() != null) {
            vo.getItensCusto().forEach(it -> it.setApuracaoCusto(vo));
        }
        return vo;
    }

    public List<ItemCustoMensalColaborador> apuracaoCustoPorColaborador(Date periodo, EmpresaRh empresaRh, Empresa empresa) {
        Date dataFinal;
        Date dataInicial = ToolDate.getDateFirstMonthDay((Date)periodo);
        Double percDesoneracao = this.serviceCalcInssEmp.percentualDesoneracaoInssEmpresa(dataInicial, dataFinal = ToolDate.getLastDateOnMonth((Date)periodo), empresa);
        if (percDesoneracao == null) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1183.001", new String[]{ToolDate.dateToStr((Date)dataInicial), ToolDate.dateToStr((Date)dataFinal)}));
        }
        List<MovimentoFolha> movsFolha = this.serviceMovFolha.findFolhaCustoMensal(dataInicial, dataFinal, empresa);
        return this.helper.calcularCustoMensalPorColaborador(movsFolha, empresaRh, percDesoneracao, dataFinal);
    }
}

