/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaoreinf;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.constants.enums.reinf.EnumConstAmbienteReinf;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinf4040;
import com.touchcomp.basementor.model.vo.ItemReinfDeducao4010;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoApuracaoReinfImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxApuracaoReinf2010;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxApuracaoReinf2020;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxApuracaoReinf4010;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxApuracaoReinf4020;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxApuracaoReinf4040;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility.AuxBeforeSaveApuracaoReinf;
import com.touchcomp.basementorservice.service.impl.baixatitulopiscofins.ServiceBaixaTituloPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemcooperadojuros.ServiceItemCooperadoJurosImpl;
import com.touchcomp.basementorservice.service.impl.itemdistribuicaosobracooperado.ServiceItemDistribuicaoSobraCooperadoImpl;
import com.touchcomp.basementorservice.service.impl.itemreinf2010.ServiceItemReinf2010Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf2020.ServiceItemReinf2020Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4010.ServiceItemReinf4010Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4020.ServiceItemReinf4020Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4020naoidentificado.ServiceItemReinf4020NaoIdentificadoImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.r1000.ServiceR1000Impl;
import com.touchcomp.basementorservice.service.impl.rps.ServiceRpsImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceReinfPreEvento;
import com.touchcomp.touchvomodel.vo.apuracaoreinf.web.DTOApuracaoReinf;
import com.touchcomp.touchvomodel.vo.itemreinf2010.web.DTOItemReinf2010;
import com.touchcomp.touchvomodel.vo.itemreinf2020.web.DTOItemReinf2020;
import com.touchcomp.touchvomodel.vo.itemreinf4010.web.DTOItemReinf4010;
import com.touchcomp.touchvomodel.vo.itemreinf4020.web.DTOItemReinf4020;
import com.touchcomp.touchvomodel.vo.itemreinf4040.web.DTOItemReinf4040;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceApuracaoReinfImpl
extends ServiceGenericEntityImpl<ApuracaoReinf, Long, DaoApuracaoReinfImpl> {
    @Autowired
    private ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    private ServiceNotaFiscalPropriaImpl serviceNotaPropria;
    @Autowired
    private ServiceRpsImpl serviceRps;
    @Autowired
    private ServiceItemDistribuicaoSobraCooperadoImpl serviceItemDistribuicaoSobraCooperado;
    @Autowired
    private ServiceItemCooperadoJurosImpl serviceItemCooperadoJuros;
    @Autowired
    private ServiceBaixaTituloPisCofinsImpl serviceBaixaTituloPisCofins;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    private ServiceR1000Impl serviceR1000;
    @Autowired
    private ServiceReinfPreEvento serviceReinfPreEvento;
    @Autowired
    private ServiceItemReinf2010Impl serviceItemReinf2010;
    @Autowired
    private ServiceItemReinf2020Impl serviceItemReinf2020;
    @Autowired
    private ServiceItemReinf4010Impl serviceItemReinf4010;
    @Autowired
    private ServiceItemReinf4020Impl serviceItemReinf4020;
    @Autowired
    private ServiceItemReinf4020NaoIdentificadoImpl serviceItemReinf4020NI;

    @Autowired
    public ServiceApuracaoReinfImpl(DaoApuracaoReinfImpl dao) {
        super(dao);
    }

    @Override
    public ApuracaoReinf beforeSave(ApuracaoReinf vo) {
        return new AuxBeforeSaveApuracaoReinf().beforeSave(vo);
    }

    public List<HashMap> getDadosDetalhamentoImpostoItensReinf4020ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoApuracaoReinfImpl)this.getGenericDao()).getDadosDetalhamentoImpostoItensReinf4020ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public List<HashMap> getDadosDetalhamentoImpostoItensReinf4020NIByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoApuracaoReinfImpl)this.getGenericDao()).getDadosDetalhamentoImpostoItensReinf4020NIByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public Double getDadosDetalhamentoImpostoItensReinf4010ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoApuracaoReinfImpl)this.getGenericDao()).getDadosDetalhamentoImpostoItensReinf4010ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public Double getDadosDetalhamentoImpostoItensReinf4040ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoApuracaoReinfImpl)this.getGenericDao()).getDadosDetalhamentoImpostoItensReinf4040ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public List<HashMap> getDadosDetalhamentoImpostoItensReinf2010ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoApuracaoReinfImpl)this.getGenericDao()).getDadosDetalhamentoImpostoItensReinf2010ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public DTOApuracaoReinf apurar(DTOApuracaoReinf dadosApuracao, GrupoEmpresa grupoEmpresa, OpcoesContabeis opcoesContabeis, Empresa empresa) throws ExceptionInvalidData {
        if (this.isNull(dadosApuracao.getPeriodo()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1696.002", new Object[0]);
        }
        Boolean filtrasNotasRet = this.isEquals(dadosApuracao.getFiltrarNotasRetidas(), EnumConstantsMentorSimNao.SIM.getValue());
        R1000 reinf = this.serviceR1000.getFirstByEmpresa(empresa.getIdentificador());
        List<ItemReinf2010> itens2010 = new AuxApuracaoReinf2010().apurarItens2010(this.serviceNotaFiscalTerceiros.findNotasNaoApuradasReinf2010(grupoEmpresa, dadosApuracao.getPeriodo(), filtrasNotasRet));
        List itens2020 = new AuxApuracaoReinf2020().apurarItens2020(this.serviceRps.findNotasNaoApuradasReinf2020(grupoEmpresa, dadosApuracao.getPeriodo(), filtrasNotasRet), this.serviceNotaPropria.findNotasNaoApuradasReinf2020(grupoEmpresa, dadosApuracao.getPeriodo(), filtrasNotasRet));
        List<ItemReinf4010> itens4010 = new AuxApuracaoReinf4010().apuracaoValores4010(this.serviceNotaFiscalTerceiros.findNotasNaoApuradasReinf4010(grupoEmpresa, dadosApuracao.getPeriodo()));
        List<ItemReinf4020> itens4020 = new AuxApuracaoReinf4020(this.serviceNotaFiscalTerceiros, this.serviceBaixaTituloPisCofins).apuracaoValores4020(grupoEmpresa, opcoesContabeis, reinf, dadosApuracao.getPeriodo());
        List<ItemReinf4040> itens4040 = new AuxApuracaoReinf4040().apuracaoValores4040(this.serviceItemDistribuicaoSobraCooperado.findItemDistribuicaoSobraCooperado(dadosApuracao.getPeriodo(), dadosApuracao.getFiltrarNotasRetidas()), this.serviceItemCooperadoJuros.findItemDistribuicaoSobraCooperado(dadosApuracao.getPeriodo(), dadosApuracao.getFiltrarNotasRetidas()));
        List<ItemReinf4020NaoIdentificado> itens4020NaoIdentificado = new AuxApuracaoReinf4020(this.serviceNotaFiscalTerceiros, this.serviceBaixaTituloPisCofins).apuracaoValores4020NaoIdentificado(this.serviceItemCooperadoJuros.findItemDistribuicaoSobraCooperado(dadosApuracao.getPeriodo(), EnumConstTipoPessoaComplementar.JURIDICA.getEnumId()));
        dadosApuracao.setItens2010(this.buildToDTOGeneric(itens2010, DTOItemReinf2010.class));
        dadosApuracao.setItens2020(this.buildToDTOGeneric(itens2020, DTOItemReinf2020.class));
        dadosApuracao.setItensReinf4010(this.buildToDTOGeneric(itens4010, DTOItemReinf4010.class));
        dadosApuracao.setItensReinf4020(this.buildToDTOGeneric(itens4020, DTOItemReinf4020.class));
        dadosApuracao.setItensReinf4040(this.buildToDTOGeneric(itens4040, DTOItemReinf4040.class));
        dadosApuracao.setItensReinf4020NI(this.buildToDTOGeneric(itens4020NaoIdentificado, DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado.class));
        return dadosApuracao;
    }

    public DTOItemReinf2010 retificarEvento2010(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf2010 vo = (ItemReinf2010)this.serviceItemReinf2010.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
        return this.buildToDTOGeneric(this.serviceItemReinf2010.get(identificador), DTOItemReinf2010.class);
    }

    public void excluirEvento2010(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf2010 vo = (ItemReinf2010)this.serviceItemReinf2010.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
    }

    public DTOItemReinf2020 retificarEvento2020(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf2020 vo = (ItemReinf2020)this.serviceItemReinf2020.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
        return this.buildToDTOGeneric(this.serviceItemReinf2020.get(identificador), DTOItemReinf2020.class);
    }

    public void excluirEvento2020(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf2020 vo = (ItemReinf2020)this.serviceItemReinf2020.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
    }

    public DTOItemReinf4010 retificarEvento4010(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4010 vo = (ItemReinf4010)this.serviceItemReinf4010.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
        return this.buildToDTOGeneric(this.serviceItemReinf4010.get(identificador), DTOItemReinf4010.class);
    }

    public void excluirEvento4010(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4010 vo = (ItemReinf4010)this.serviceItemReinf4010.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
    }

    public DTOItemReinf4020 retificarEvento4020(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4020 vo = (ItemReinf4020)this.serviceItemReinf4020.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
        return this.buildToDTOGeneric(this.serviceItemReinf4020.get(identificador), DTOItemReinf4020.class);
    }

    public void excluirEvento4020(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4020 vo = (ItemReinf4020)this.serviceItemReinf4020.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
    }

    public DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado retificarEvento4020NI(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4020NaoIdentificado vo = (ItemReinf4020NaoIdentificado)this.serviceItemReinf4020NI.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
        return this.buildToDTOGeneric(this.serviceItemReinf4020NI.get(identificador), DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado.class);
    }

    public void excluirEvento4020NI(Usuario usuario, Long identificador, Short tipoAmbiente) throws ExceptionObjNotFound {
        ItemReinf4020NaoIdentificado vo = (ItemReinf4020NaoIdentificado)this.serviceItemReinf4020NI.getOrThrow(identificador);
        EnumConstAmbienteReinf ambiente = EnumConstAmbienteReinf.get((Object)tipoAmbiente);
        this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, String.valueOf(ambiente.getValue()), new Date(), null);
    }

    public WebDTOResult<List<DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado>> createItemReinf4020NaoIdentificado(Long[] ids) {
        WebDTOResult result = new WebDTOResult();
        ArrayList<DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado> ret = new ArrayList<DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado>();
        List empresas = this.serviceEmpresa.gets(ids);
        for (Empresa emp : empresas) {
            if (!this.isAffimative(emp.getPessoa().getAtivo()) || !this.isAffimative(emp.getEmpresaDados().getAtivo())) {
                result.addWarning("E.ERP.1696.004", new Object[]{String.valueOf(emp)});
                continue;
            }
            ItemReinf4020NaoIdentificado vo = new ItemReinf4020NaoIdentificado();
            vo.setEmpresa(emp);
            ret.add(this.buildToDTOGeneric(vo, DTOApuracaoReinf.DTOItemReinf4020NaoIdentificado.class));
        }
        result.setResult(ret);
        return result;
    }

    public WebDTOResult<List<DTOItemReinf4040>> createItemReinf4040(Long[] ids) {
        WebDTOResult result = new WebDTOResult();
        ArrayList<DTOItemReinf4040> ret = new ArrayList<DTOItemReinf4040>();
        List empresas = this.serviceEmpresa.gets(ids);
        for (Empresa emp : empresas) {
            if (!this.isAffimative(emp.getPessoa().getAtivo()) || !this.isAffimative(emp.getEmpresaDados().getAtivo())) {
                result.addWarning("E.ERP.1696.004", new Object[]{String.valueOf(emp)});
                continue;
            }
            ItemReinf4040 vo = new ItemReinf4040();
            vo.setEmpresa(emp);
            ret.add(this.buildToDTOGeneric(vo, DTOItemReinf4040.class));
        }
        result.setResult(ret);
        return result;
    }

    public DTOItemReinf4040.DTOItemReinfDeducao4010 newItemReinfDeducao() {
        return this.buildToDTOGeneric(new ItemReinfDeducao4010(), DTOItemReinf4040.DTOItemReinfDeducao4010.class);
    }
}

