/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2010;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementorservice.BaseMethods;
import java.util.ArrayList;
import java.util.List;

public class AuxApuracaoReinf2010
extends BaseMethods {
    public List<ItemReinf2010> apurarItens2010(List<NotaFiscalTerceiros> notas) {
        ArrayList<ItemReinf2010> itens = new ArrayList<ItemReinf2010>();
        if (AuxApuracaoReinf2010.isWithData(notas)) {
            for (NotaFiscalTerceiros nota : notas) {
                Short indicadorObra = this.getIndicador(nota.getInformarNotaObra());
                Short indicadorEmpreitada = this.getIndicador(nota.getTipoObraConstrucao());
                CadastroNacionalObra cno = nota.getCadastroNacionalObra();
                Boolean reinfFornecedorCad = false;
                for (ItemReinf2010 item : itens) {
                    if (!this.isEquals(item.getPessoa(), nota.getUnidadeFatFornecedor().getFornecedor().getPessoa()) || !this.isEquals(item.getIndicadorObra(), indicadorObra) || !this.isEquals(item.getIndicadorEmpreitada(), indicadorEmpreitada) || !this.isNull(cno).booleanValue() && !this.isEquals(item.getCno(), cno) || !this.isEquals(item.getEmpresa(), nota.getEmpresa())) continue;
                    ItemReinfNotas2010 ii = new ItemReinfNotas2010();
                    ii.setNotaTerceiros(nota);
                    ii.setItemReinf2010(item);
                    item.getItens().add(ii);
                    reinfFornecedorCad = true;
                    break;
                }
                if (reinfFornecedorCad.booleanValue()) continue;
                itens.add(this.getItemReinf2010(nota, cno, indicadorObra, indicadorEmpreitada));
            }
        }
        return itens;
    }

    private ItemReinf2010 getItemReinf2010(NotaFiscalTerceiros nota, CadastroNacionalObra cno, Short indicadorObra, Short indicadorEmpreitada) {
        ItemReinf2010 i = new ItemReinf2010();
        i.setPessoa(nota.getUnidadeFatFornecedor().getFornecedor().getPessoa());
        i.setIndicadorObra(indicadorObra);
        i.setIndicadorEmpreitada(indicadorEmpreitada);
        i.setCno(cno);
        i.setEmpresa(nota.getEmpresa());
        ItemReinfNotas2010 ii = new ItemReinfNotas2010();
        ii.setNotaTerceiros(nota);
        ii.setItemReinf2010(i);
        i.getItens().add(ii);
        return i;
    }

    private Short getIndicador(Short indicador) {
        if (this.isNull(indicador).booleanValue()) {
            return EnumConstantsMentorSimNao.NAO.getValue();
        }
        return indicador;
    }
}

